/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p.ws;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.orchestra.b4p.TaskRepository;
import org.ow2.orchestra.b4p.TaskRuntime;
import org.ow2.orchestra.b4p.ws.CurrentUser;
import org.ow2.orchestra.b4p.ws.MemoryTaskRepository;
import org.ow2.orchestra.b4p.ws.TaskOperationsImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.ws_ht.TOrganizationalEntity;
import org.ow2.orchestra.ws_ht.TUserlist;
import org.ow2.orchestra.ws_ht.api.TStatus;
import org.ow2.orchestra.ws_ht.api.TTask;
import org.ow2.orchestra.ws_ht.api.wsdl.IllegalAccessFault;
import org.ow2.orchestra.ws_ht.api.wsdl.IllegalArgumentFault;
import org.ow2.orchestra.ws_ht.api.wsdl.IllegalStateFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TaskOperationsTest
extends TestCase {
    public void testNominate() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        taskRepository.addTaskRuntime(t1);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        taskOperations.nominate("t1", organizationalEntity);
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getStatus());
    }

    public void testNominateBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        taskRepository.addTaskRuntime(t1);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        try {
            taskOperations.nominate("t1", organizationalEntity);
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testNominateMultiple() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        taskRepository.addTaskRuntime(t1);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        taskOperations.nominate("t1", organizationalEntity);
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
    }

    public void testNominateBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        taskRepository.addTaskRuntime(t1);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        try {
            taskOperations.nominate("t1", organizationalEntity);
            TaskOperationsTest.fail((String)"expecting exception");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
    }

    public void testNominateBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        try {
            taskOperations.nominate("t1", organizationalEntity);
            TaskOperationsTest.fail((String)"expecting exception");
        }
        catch (IllegalArgumentFault e) {
            // empty catch block
        }
    }

    public void testClaim() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        taskOperations.claim("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getStatus());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
    }

    public void testClaimBusinessAdmin() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        taskOperations.claim("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getStatus());
        Assert.assertEquals((String)"admin1", (String)t1.getActualOwner());
    }

    public void testClaimBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.claim("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
    }

    public void testClaimBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.claim("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testClaimBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.claim("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testStart() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.RESERVED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.start("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)t1b.getStatus());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
    }

    public void testStartPotentialOwner() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        taskOperations.start("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)t1b.getStatus());
        Assert.assertEquals((String)"user2", (String)t1.getActualOwner());
    }

    public void testStartBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.start("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
    }

    public void testStartBadUserReserved() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.RESERVED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.start("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getStatus());
    }

    public void testStartBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.start("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testStartBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.start("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testComplete() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        final AtomicBoolean b = new AtomicBoolean(false);
        BpelExecution bpelExecution = new BpelExecution(){

            public void signal(String signal, Map<String, Object> parameters) {
                b.set(true);
            }
        };
        t1.setBpelExecution(bpelExecution);
        MessageVariable outputMessage = new MessageVariable(XmlUtil.getDocumentWithOneElement((QName)QName.valueOf("{test}test")).getOwnerDocument());
        t1.setOutputMessage(outputMessage);
        taskRepository.addTaskRuntime(t1);
        taskOperations.complete("t1", (Object)"ok");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.COMPLETED, (Object)t1b.getStatus());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
        Assert.assertTrue((boolean)b.get());
    }

    public void testCompleteBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.complete("t1", (Object)"ok");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)t1b.getStatus());
    }

    public void testCompleteBadData() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.complete("t1", null);
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)t1b.getStatus());
    }

    public void testCompleteBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.complete("t1", (Object)"ok");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testCompleteBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.complete("t1", (Object)"ok");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testActivate() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        taskRepository.addTaskRuntime(t1);
        taskOperations.activate("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
    }

    public void testActivateBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.activate("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testActivateBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.activate("t1");
            TaskOperationsTest.fail((String)"expecting exception");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
    }

    public void testActivateBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.activate("t1");
            TaskOperationsTest.fail((String)"expecting exception");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testStop() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.stop("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getStatus());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
    }

    public void testStopBusinessAdmin() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.stop("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getStatus());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
    }

    public void testStopBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.stop("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)t1b.getStatus());
    }

    public void testStopBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.stop("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testStopBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.stop("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testReleaseInProgress() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.release("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
        Assert.assertNull((Object)t1b.getActualOwner());
    }

    public void testReleaseReserved() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.RESERVED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.release("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
        Assert.assertNull((Object)t1b.getActualOwner());
    }

    public void testReleaseBusinessAdmin() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.release("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
        Assert.assertNull((Object)t1b.getActualOwner());
    }

    public void testReleaseBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.release("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)t1b.getStatus());
    }

    public void testReleaseBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.release("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testReleaseBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.release("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testSuspend() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.RESERVED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.suspend("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.SUSPENDED, (Object)t1b.getStatus());
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getResumeState());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
    }

    public void testSuspendBusinessAdmin() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.suspend("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.SUSPENDED, (Object)t1b.getStatus());
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)t1b.getResumeState());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
    }

    public void testSuspendPotentialOwner() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        taskOperations.suspend("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.SUSPENDED, (Object)t1b.getStatus());
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getResumeState());
        Assert.assertNull((Object)t1.getActualOwner());
    }

    public void testSuspendBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.suspend("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
    }

    public void testSuspendBadUserReserved() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.RESERVED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.suspend("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getStatus());
    }

    public void testSuspendBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.suspend("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testSuspendBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.suspend("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testResume() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.SUSPENDED);
        t1.setResumeState(TStatus.RESERVED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.resume("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.RESERVED, (Object)t1b.getStatus());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
    }

    public void testResumeBusinessAdmin() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.SUSPENDED);
        t1.setResumeState(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.resume("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.IN_PROGRESS, (Object)t1b.getStatus());
        Assert.assertEquals((String)"user1", (String)t1.getActualOwner());
    }

    public void testResumePotentialOwner() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.SUSPENDED);
        t1.setResumeState(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        taskOperations.resume("t1");
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.READY, (Object)t1b.getStatus());
        Assert.assertNull((Object)t1.getActualOwner());
    }

    public void testResumeBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.SUSPENDED);
        t1.setResumeState(TStatus.READY);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.resume("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.SUSPENDED, (Object)t1b.getStatus());
    }

    public void testResumeBadUserReserved() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.SUSPENDED);
        t1.setResumeState(TStatus.RESERVED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.resume("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.SUSPENDED, (Object)t1b.getStatus());
    }

    public void testResumeBadState() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.CREATED);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.resume("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalStateFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((Object)TStatus.CREATED, (Object)t1b.getStatus());
    }

    public void testResumeBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.resume("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testSetPriority() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        t1.setPriority(BigInteger.ONE);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.setPriority("t1", BigInteger.TEN);
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((int)10, (int)t1b.getPriority().intValue());
    }

    public void testSetPriorityBusinessAdmin() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        t1.setPriority(BigInteger.ONE);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        taskOperations.setPriority("t1", BigInteger.TEN);
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((int)10, (int)t1b.getPriority().intValue());
    }

    public void testSetPriorityBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        t1.setPriority(BigInteger.ONE);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.setPriority("t1", BigInteger.TEN);
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
        Assert.assertEquals((int)1, (int)t1b.getPriority().intValue());
    }

    public void testSetPriorityBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.setPriority("t1", BigInteger.TEN);
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testGetTaskInfo() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        t1.setPriority(BigInteger.ONE);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        TTask t1b = taskOperations.getTaskInfo("t1");
        Assert.assertEquals((Object)t1, (Object)t1b);
    }

    public void testGetTaskInfoBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.getTaskInfo("t1");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testSetOutput() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        elt.appendChild(elt2);
        elt2.appendChild(elt.getOwnerDocument().createElement("anonymous"));
        MessageVariable outMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setOutputMessage(outMessageVariable);
        taskRepository.addTaskRuntime(t1);
        taskOperations.setOutput("t1", "part", (Object)BpelXmlUtil.createElementWithContent((String)"test"));
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
    }

    public void testSetOutputBadPart() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        elt.appendChild(elt2);
        elt2.appendChild(elt.getOwnerDocument().createElement("anonymous"));
        MessageVariable outMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setOutputMessage(outMessageVariable);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.setOutput("t1", "part2", (Object)BpelXmlUtil.createElementWithContent((String)"test"));
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
    }

    public void testSetOutputBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.setOutput("t1", "part", (Object)BpelXmlUtil.createElementWithContent((String)"test"));
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
        TaskRuntime t1b = taskRepository.removeTaskRuntime("t1");
    }

    public void testSetOutputBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.setOutput("t1", "part", (Object)BpelXmlUtil.createElementWithContent((String)"test"));
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testGetOutput() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        Element elt3 = elt.getOwnerDocument().createElement("anonymous");
        elt.appendChild(elt2);
        elt2.appendChild(elt3);
        elt3.setTextContent("test");
        MessageVariable outMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setOutputMessage(outMessageVariable);
        taskRepository.addTaskRuntime(t1);
        Object out = taskOperations.getOutput("t1", "part");
        Assert.assertEquals((String)XmlUtil.toString((Node)elt3), (String)XmlUtil.toString((Node)((Node)out)));
    }

    public void testGetOutputBusinessAdmin() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        Element elt3 = elt.getOwnerDocument().createElement("anonymous");
        elt.appendChild(elt2);
        elt2.appendChild(elt3);
        elt3.setTextContent("test");
        MessageVariable outMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setOutputMessage(outMessageVariable);
        taskRepository.addTaskRuntime(t1);
        Object out = taskOperations.getOutput("t1", "part");
        Assert.assertEquals((String)XmlUtil.toString((Node)elt3), (String)XmlUtil.toString((Node)((Node)out)));
    }

    public void testGetOutputBadPart() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        Element elt3 = elt.getOwnerDocument().createElement("anonymous");
        elt.appendChild(elt2);
        elt2.appendChild(elt3);
        elt3.setTextContent("test");
        MessageVariable outMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setOutputMessage(outMessageVariable);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.getOutput("t1", "part2");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault e) {
            // empty catch block
        }
    }

    public void testGetOutputBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.getOutput("t1", "part");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
    }

    public void testGetOutputBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.getOutput("t1", "part");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }

    public void testGetInput() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        Element elt3 = elt.getOwnerDocument().createElement("anonymous");
        elt.appendChild(elt2);
        elt2.appendChild(elt3);
        elt3.setTextContent("test");
        MessageVariable inMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setInputMessage(inMessageVariable);
        taskRepository.addTaskRuntime(t1);
        Object in = taskOperations.getInput("t1", "part");
        Assert.assertEquals((String)XmlUtil.toString((Node)elt3), (String)XmlUtil.toString((Node)((Node)in)));
    }

    public void testGetInputPotentialOwner() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user2");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        Element elt3 = elt.getOwnerDocument().createElement("anonymous");
        elt.appendChild(elt2);
        elt2.appendChild(elt3);
        elt3.setTextContent("test");
        MessageVariable inMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setInputMessage(inMessageVariable);
        taskRepository.addTaskRuntime(t1);
        Object in = taskOperations.getInput("t1", "part");
        Assert.assertEquals((String)XmlUtil.toString((Node)elt3), (String)XmlUtil.toString((Node)((Node)in)));
    }

    public void testGetInputBusinessAdmin() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"admin1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        Element elt3 = elt.getOwnerDocument().createElement("anonymous");
        elt.appendChild(elt2);
        elt2.appendChild(elt3);
        elt3.setTextContent("test");
        MessageVariable inMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setInputMessage(inMessageVariable);
        taskRepository.addTaskRuntime(t1);
        Object in = taskOperations.getInput("t1", "part");
        Assert.assertEquals((String)XmlUtil.toString((Node)elt3), (String)XmlUtil.toString((Node)((Node)in)));
    }

    public void testGetInputBadPart() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        Element elt = BpelXmlUtil.createElement((String)"msg");
        Element elt2 = elt.getOwnerDocument().createElement("part");
        Element elt3 = elt.getOwnerDocument().createElement("anonymous");
        elt.appendChild(elt2);
        elt2.appendChild(elt3);
        elt3.setTextContent("test");
        MessageVariable inMessageVariable = new MessageVariable(elt.getOwnerDocument());
        t1.setInputMessage(inMessageVariable);
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.getInput("t1", "part2");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault e) {
            // empty catch block
        }
    }

    public void testGetInputBadUser() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user4");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        TaskRuntime t1 = new TaskRuntime();
        t1.setTaskType("TASK");
        t1.setId("t1");
        t1.setStatus(TStatus.IN_PROGRESS);
        TUserlist adminList = new TUserlist();
        adminList.getUser().add("admin1");
        TOrganizationalEntity adminOrganizationalEntity = new TOrganizationalEntity();
        adminOrganizationalEntity.setUsers(adminList);
        t1.setBusinessAdministrators(adminOrganizationalEntity);
        TUserlist userList = new TUserlist();
        userList.getUser().add("user1");
        userList.getUser().add("user2");
        TOrganizationalEntity organizationalEntity = new TOrganizationalEntity();
        organizationalEntity.setUsers(userList);
        t1.setPotentialOwners(organizationalEntity);
        t1.setActualOwner("user1");
        taskRepository.addTaskRuntime(t1);
        try {
            taskOperations.getInput("t1", "part");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalAccessFault e) {
            // empty catch block
        }
    }

    public void testGetInputBadTaskId() throws IllegalArgumentFault, IllegalAccessFault, IllegalStateFault {
        CurrentUser.setCurrentUser((String)"user1");
        MemoryTaskRepository taskRepository = new MemoryTaskRepository();
        TaskOperationsImpl taskOperations = new TaskOperationsImpl();
        taskOperations.setTaskRepository((TaskRepository)taskRepository);
        try {
            taskOperations.getInput("t1", "part");
            TaskOperationsTest.fail((String)"exception expected");
        }
        catch (IllegalArgumentFault illegalArgumentFault) {
            // empty catch block
        }
    }
}

