/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.xml.namespace.QName;
import org.jaxen.Function;
import org.ow2.orchestra.b4p.B4PCxfServlet;
import org.ow2.orchestra.b4p.HumanTaskAPIImpl;
import org.ow2.orchestra.b4p.binding.PeopleActivityBinding;
import org.ow2.orchestra.b4p.definition.PeopleActivity;
import org.ow2.orchestra.b4p.humantaskapi.HumanTaskAPI;
import org.ow2.orchestra.b4p.xpath.GetActualOwnerFunction;
import org.ow2.orchestra.b4p.xpath.GetBusinessAdministratorsFunction;
import org.ow2.orchestra.b4p.xpath.GetExcludedOwnersFunction;
import org.ow2.orchestra.b4p.xpath.GetInputFunction;
import org.ow2.orchestra.b4p.xpath.GetPotentialOwnersFunction;
import org.ow2.orchestra.b4p.xpath.GetTaskInitiatorFunction;
import org.ow2.orchestra.b4p.xpath.GetTaskPriorityFunction;
import org.ow2.orchestra.b4p.xpath.GetTaskStakeholdersFunction;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.ExtensionActivity;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.extension.ExtensionProvider;
import org.ow2.orchestra.services.itf.HttpComponent;
import org.ow2.orchestra.xml.Binding;
import org.ow2.orchestra.xml.Parse;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class B4PExtensionProviderImpl
implements ExtensionProvider,
HttpComponent {
    public static final String B4P_NS = "http://www.example.org/BPEL4People";
    public static final String WSHT_NS = "http://www.example.org/WS-HT";
    private HumanTaskAPI humanTaskAPI;

    public B4PExtensionProviderImpl(EnvironmentFactory environmentFactory) {
        this.humanTaskAPI = new HumanTaskAPIImpl(environmentFactory);
    }

    public String[] getSchemaResource() {
        String[] resource = new String[]{B4PExtensionProviderImpl.class.getResource("ws-bpel4people.xsd").toExternalForm(), B4PExtensionProviderImpl.class.getResource("ws-humantask.xsd").toExternalForm()};
        return resource;
    }

    public HumanTaskAPI getHumanTaskAPI() {
        return this.humanTaskAPI;
    }

    public List<Binding> getDefaultBindings() {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        bindings.add((Binding)new PeopleActivityBinding());
        return bindings;
    }

    public void parseExtensionAttribute(Element element, Parse parse) {
    }

    public void parseExtensionElement(Element element, Parse parse) {
    }

    public boolean isSupported(String namespace) {
        return namespace.equals(B4P_NS) || namespace.equals(WSHT_NS);
    }

    public void deployExtension(BpelProcess bpelProcess) {
        List extensionActivities = bpelProcess.getExtensionActivities();
        for (ExtensionActivity extensionActivity : extensionActivities) {
            if (extensionActivity.getActivity().getClass() != PeopleActivity.class) continue;
            PeopleActivity peopleActivity = (PeopleActivity)extensionActivity.getActivity();
            this.humanTaskAPI.deployTask(bpelProcess, peopleActivity, bpelProcess.getTargetNamespace(), peopleActivity.getUUID());
        }
    }

    public void undeployExtension(BpelProcess bpelProcess) {
        List extensionActivities = bpelProcess.getExtensionActivities();
        for (ExtensionActivity extensionActivity : extensionActivities) {
            if (extensionActivity.getActivity().getClass() != PeopleActivity.class) continue;
            PeopleActivity peopleActivity = (PeopleActivity)extensionActivity.getActivity();
            this.humanTaskAPI.undeployTask(peopleActivity.getUUID());
        }
    }

    public Map<String, Servlet> getServlets(Properties orchestraProperties) {
        B4PCxfServlet cxfServlet = new B4PCxfServlet(this.getHumanTaskAPI());
        HashMap<String, Servlet> result = new HashMap<String, Servlet>();
        result.put("/b4p", (Servlet)cxfServlet);
        return result;
    }

    public void publishExtension(BpelProcess bpelProcess) {
    }

    public void unpublishExtension(BpelProcess bpelProcess) {
    }

    public Map<QName, Function> getXPathFunctions() {
        HashMap<QName, Function> result = new HashMap<QName, Function>();
        result.put(new QName(WSHT_NS, "getPotentialOwners"), new GetPotentialOwnersFunction());
        result.put(new QName(WSHT_NS, "getActualOwner"), new GetActualOwnerFunction());
        result.put(new QName(WSHT_NS, "getTaskInitiator"), new GetTaskInitiatorFunction());
        result.put(new QName(WSHT_NS, "getTaskStakeholders"), new GetTaskStakeholdersFunction());
        result.put(new QName(WSHT_NS, "getBusinessAdministrators"), new GetBusinessAdministratorsFunction());
        result.put(new QName(WSHT_NS, "getExcludedOwners"), new GetExcludedOwnersFunction());
        result.put(new QName(WSHT_NS, "getTaskPriority"), new GetTaskPriorityFunction());
        result.put(new QName(WSHT_NS, "getInput"), new GetInputFunction());
        return result;
    }
}

