/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p.definition;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.b4p.B4PExtensionProviderImpl;
import org.ow2.orchestra.b4p.humantaskapi.HumanTaskAPI;
import org.ow2.orchestra.b4p.recorder.PeopleActivityDefinitionData;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.extension.ExtensionProvider;
import org.ow2.orchestra.facade.data.def.ActivityDefinitionData;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeopleActivity
extends AbstractBpelActivity {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(PeopleActivity.class.getName());
    protected boolean isSkipable;
    protected String inputVariable;
    protected String outputVariable;
    protected boolean isNotification;
    private Document taskDocument;
    protected List<Copy> outCopies;
    protected List<Copy> inCopies;
    protected Variable anonymousOutboundMessageVariable;
    protected Variable anonymousInboundMessageVariable;
    public static final String RECEIVED_MESSAGE = "SIGNAL_PARAMETER_RECEIVED_MSG";
    public static final String RECEIVED_EXCEPTION = "SIGNAL_PARAMETER_RECEIVED_EXCEPTION";

    protected void executeActivity(BpelExecution execution) {
        ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
        VariableRuntime anonymousOutboundMessageVariableRuntime = scopeRuntime.createVariable(execution, this.anonymousOutboundMessageVariable);
        for (Copy copy : this.outCopies) {
            copy.execute(execution);
        }
        List extensionProviders = (List)Environment.getFromCurrent((String)"extensionProviders");
        B4PExtensionProviderImpl b4PExtensionProvider = null;
        for (ExtensionProvider e : extensionProviders) {
            if (!(e instanceof B4PExtensionProviderImpl)) continue;
            b4PExtensionProvider = (B4PExtensionProviderImpl)e;
            break;
        }
        HumanTaskAPI humanTaskAPI = b4PExtensionProvider.getHumanTaskAPI();
        Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINEST, (String)"input message %s", (Object[])new Object[]{anonymousOutboundMessageVariableRuntime.getValue()});
        humanTaskAPI.createTaskInstance(this.getUUID(), (MessageVariable)anonymousOutboundMessageVariableRuntime.getValue(), execution, null, null);
        scopeRuntime.removeVariable(execution, this.anonymousOutboundMessageVariable);
        if (!this.isNotification()) {
            execution.waitForSignal();
        } else {
            this.afterRunned(execution);
        }
    }

    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        MessageVariable returnedMessage = (MessageVariable)parameters.get(RECEIVED_MESSAGE);
        ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
        VariableRuntime anonymousInboundMessageVariableRuntime = scopeRuntime.createVariable(execution, this.anonymousInboundMessageVariable);
        Misc.fastDynamicLog((Logger)LOG, (Level)Level.FINEST, (String)"output message %s", (Object[])new Object[]{anonymousInboundMessageVariableRuntime.getValue()});
        anonymousInboundMessageVariableRuntime.setValue(returnedMessage);
        for (Copy copy : this.inCopies) {
            copy.execute(execution);
        }
        scopeRuntime.removeVariable(execution, this.anonymousInboundMessageVariable);
        this.afterRunned(execution);
    }

    public Document getTaskDocument() {
        return this.taskDocument;
    }

    public void setTaskDocument(Document taskDocument) {
        this.taskDocument = taskDocument;
    }

    public ActivityType getType() {
        return ActivityType.EXTENSION_ACTIVITY;
    }

    public boolean isSkipable() {
        return this.isSkipable;
    }

    public void setSkipable(boolean isSkipable) {
        this.isSkipable = isSkipable;
    }

    public String getInputVariable() {
        return this.inputVariable;
    }

    public void setInputVariable(String inputVariable) {
        this.inputVariable = inputVariable;
    }

    public String getOutputVariable() {
        return this.outputVariable;
    }

    public void setOutputVariable(String outputVariable) {
        this.outputVariable = outputVariable;
    }

    public List<Copy> getInCopies() {
        return this.inCopies;
    }

    public void setInCopies(List<Copy> inCopies) {
        this.inCopies = inCopies;
    }

    public List<Copy> getOutCopies() {
        return this.outCopies;
    }

    public void setOutCopies(List<Copy> outCopies) {
        this.outCopies = outCopies;
    }

    public Variable getAnonymousOutboundMessageVariable() {
        return this.anonymousOutboundMessageVariable;
    }

    public void setAnonymousOutboundMessageVariable(Variable anonymousOutboundMessageVariable) {
        this.anonymousOutboundMessageVariable = anonymousOutboundMessageVariable;
    }

    public Variable getAnonymousInboundMessageVariable() {
        return this.anonymousInboundMessageVariable;
    }

    public void setAnonymousInboundMessageVariable(Variable anonymousInboundMessageVariable) {
        this.anonymousInboundMessageVariable = anonymousInboundMessageVariable;
    }

    public boolean isNotification() {
        return this.isNotification;
    }

    public void setNotification(boolean notification) {
        this.isNotification = notification;
    }

    public ActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new PeopleActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, this.name);
    }
}

