/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.b4p.recorder;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.b4p.TaskRuntime;
import org.ow2.orchestra.b4p.recorder.TaskRecorder;
import org.ow2.orchestra.b4p.ws.CurrentUser;

public class LoggerTaskRecorder
implements TaskRecorder {
    private static final Logger LOG = Logger.getLogger(LoggerTaskRecorder.class.getName());
    private final Level level;

    public LoggerTaskRecorder() {
        this(Level.FINE);
    }

    public LoggerTaskRecorder(String levelName) {
        this(Level.parse(levelName));
    }

    public LoggerTaskRecorder(Level level) {
        this.level = level;
    }

    public void recordTaskActualOwnerUpdate(TaskRuntime taskInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task [uuid:" + taskInstanceData.getId() + "] actual owner updated to: " + taskInstanceData.getActualOwner() + " by: " + CurrentUser.getCurrentUser());
        }
    }

    public void recordTaskPotentialOwnerUpdate(TaskRuntime taskInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task [uuid:" + taskInstanceData.getId() + "] potential owners updated to: " + taskInstanceData.getPotentialOwners() + " by: " + CurrentUser.getCurrentUser());
        }
    }

    public void recordTaskStateUpdate(TaskRuntime taskInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task [uuid:" + taskInstanceData.getId() + "] status updated to: " + taskInstanceData.getStatus() + " by: " + CurrentUser.getCurrentUser());
        }
    }

    public void recordTaskOutputUpdate(TaskRuntime taskInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task [uuid:" + taskInstanceData.getId() + "] output updated to: " + taskInstanceData.getOutputMessage() + " by: " + CurrentUser.getCurrentUser());
        }
    }

    public void recordTaskCreated(TaskRuntime taskInstanceData) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task [uuid:" + taskInstanceData.getId() + "] created by: " + CurrentUser.getCurrentUser());
        }
    }
}

