/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.faultManagement.compensationHandler;

import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.runtime.ScopeActivityInstance;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.FailWS;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

public class CompensationHandlerWithFaultTest
extends BpelTestCase {
    public CompensationHandlerWithFaultTest() {
        super("http://orchestra.ow2.org/compensationHandler", "compensationHandlerWithFault");
    }

    public void testFaultInCompensationHandler() throws Exception {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        FailWS failWS = new FailWS();
        WSRepository.addWS(FailWS.PORTTYPE_QNAME, failWS);
        String message = UUID.randomUUID().toString();
        String saveStateAfterFirstBranch = message + message;
        String expectedResponse = saveStateAfterFirstBranch + "compensationHandlerForSuccessful" + "catchAllInProcess";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), "compensationHandlerPT");
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            if (saveWS.getBuffer().equals(saveStateAfterFirstBranch)) break;
        }
        Assert.assertEquals((String)saveStateAfterFirstBranch, (String)saveWS.getBuffer());
        this.call(parts, portTypeQName, "resume");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        boolean result = (Boolean)commandService.execute((Command)new Command<Boolean>(){

            public Boolean execute(Environment environment) throws Exception {
                Set activityInstances = EnvTool.getQuerier().findActivityInstances(callResult.getProcessInstanceUUID());
                for (ActivityFullInstance activityInstance : activityInstances) {
                    ScopeActivityInstance scopeActivityInstance;
                    if (!(activityInstance instanceof ScopeActivityInstance) || (scopeActivityInstance = (ScopeActivityInstance)activityInstance).getCompensationHandlerActivityUUID() == null) continue;
                    return true;
                }
                return false;
            }
        });
        Assert.assertTrue((String)"Compensation activity UUID never logged!", (boolean)result);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) throws Exception {
                CompensationHandlerWithFaultTest.this.deleteInstance(callResult);
                return null;
            }
        });
        WSRepository.removeWS(FailWS.PORTTYPE_QNAME);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        this.undeploy();
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }
}

