/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty;

import java.util.HashMap;
import java.util.Map;
import org.apache.felix.http.jetty.Activator;
import org.mortbay.log.Logger;

public class LogServiceLog
implements Logger {
    private static Map loggers = new HashMap();
    private final String m_name;
    private boolean m_debugEnabled;

    public LogServiceLog() {
        this("org.mortbay.log");
    }

    public LogServiceLog(String name) {
        this.m_name = name;
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)loggers.get(name);
        if (logger == null) {
            logger = new LogServiceLog(name);
            logger.setDebugEnabled(this.isDebugEnabled());
            loggers.put(name, logger);
        }
        return logger;
    }

    public boolean isDebugEnabled() {
        return this.m_debugEnabled;
    }

    public void setDebugEnabled(boolean enabled) {
        this.m_debugEnabled = enabled;
    }

    public void debug(String msg, Throwable throwable) {
        this.log(4, msg, throwable);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        this.log(4, this.format(msg, arg0, arg1), null);
    }

    public void info(String msg, Object arg0, Object arg1) {
        this.log(3, this.format(msg, arg0, arg1), null);
    }

    public void warn(String msg, Throwable throwable) {
        this.log(2, msg, throwable);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        this.log(2, this.format(msg, arg0, arg1), null);
    }

    public String toString() {
        return this.m_name;
    }

    private String format(String msg, Object arg0, Object arg1) {
        int i1;
        int i0 = msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (arg1 != null && i1 >= 0) {
            msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
        }
        if (arg0 != null && i0 >= 0) {
            msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
        }
        return msg;
    }

    private void log(int level, String message, Throwable throwable) {
        Activator.log(level, this.m_name + ":" + message, throwable);
    }
}

