/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ow2.orchestra.facade.runtime.Message;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Serializable,
Message {
    private static final long serialVersionUID = 6047054200032920537L;
    protected Map<String, String> parts = new HashMap<String, String>();

    public MessageImpl(Map<String, Document> docParts) {
        if (docParts != null) {
            for (Map.Entry<String, Document> docPart : docParts.entrySet()) {
                this.parts.put(docPart.getKey(), XmlUtil.toString(docPart.getValue()));
            }
        }
    }

    @Override
    public Element getPartValue(String partName) {
        if (partName != null) {
            if (this.parts.get(partName) != null) {
                return XmlUtil.getDocumentFromString(this.parts.get(partName)).getDocumentElement();
            }
            return null;
        }
        return XmlUtil.getDocumentFromString(this.parts.values().iterator().next()).getDocumentElement();
    }

    public boolean isPartInitialized(String partName) {
        return this.parts.get(partName) != null;
    }

    @Override
    public boolean hasPart(String partName) {
        if (partName != null) {
            return this.parts.containsKey(partName);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<message>");
        for (String part : this.parts.keySet()) {
            if (this.parts.get(part) == null) continue;
            buf.append("<" + part + ">");
            if (this.parts.get(part) == null) {
                buf.append("no_value_for_this_part");
            } else {
                buf.append(this.parts.get(part));
            }
            buf.append("</" + part + ">");
        }
        buf.append("</message>");
        return buf.toString();
    }

    @Override
    public Map<String, Element> getParts() {
        HashMap<String, Element> res = new HashMap<String, Element>();
        if (this.parts != null) {
            for (Map.Entry<String, String> entry : this.parts.entrySet()) {
                if (entry.getValue() != null) {
                    res.put(entry.getKey(), XmlUtil.getDocumentFromString(entry.getValue()).getDocumentElement());
                    continue;
                }
                res.put(entry.getKey(), null);
            }
        }
        return res;
    }

    @Override
    public MessageImpl copy() {
        if (this.parts == null) {
            return null;
        }
        HashMap<String, String> duplicateMessageParts = new HashMap<String, String>(this.parts);
        MessageImpl newMsg = new MessageImpl(null);
        newMsg.parts = duplicateMessageParts;
        return newMsg;
    }
}

