/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.h2.constant.SysProperties;
import org.h2.util.ObjectUtils;
import org.h2.util.RandomUtils;
import org.h2.util.StatementBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArray<T>
implements Iterable<T> {
    private static final int CAPACITY_INIT = 4;
    private static final int CAPACITY_SHRINK = 256;
    int size;
    private T[] data;

    private ObjectArray(int n) {
        this.data = this.createArray(n);
    }

    private ObjectArray(Collection<T> collection) {
        this.size = collection.size();
        this.data = this.createArray(this.size);
        Iterator<T> iterator = collection.iterator();
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = iterator.next();
        }
    }

    public static <T> ObjectArray<T> newInstance(int n) {
        return new ObjectArray<T>(n);
    }

    public static <T> ObjectArray<T> newInstance(T ... TArray) {
        ObjectArray<T> objectArray = new ObjectArray<T>(4);
        for (T t : TArray) {
            objectArray.add(t);
        }
        return objectArray;
    }

    public static <T> ObjectArray<T> newInstance() {
        return new ObjectArray<T>(4);
    }

    public static <T> ObjectArray<T> newInstance(Collection<T> collection) {
        return new ObjectArray<T>(collection);
    }

    private T[] createArray(int n) {
        return new Object[n > 1 ? n : 1];
    }

    private void throwException(int n) {
        throw new ArrayIndexOutOfBoundsException("i=" + n + " size=" + this.size);
    }

    public void add(T t) {
        if (this.size >= this.data.length) {
            this.ensureCapacity(this.size);
        }
        this.data[this.size++] = t;
    }

    public T get(int n) {
        if (SysProperties.CHECK2 && n >= this.size) {
            this.throwException(n);
        }
        return this.data[n];
    }

    public Object remove(int n) {
        if (SysProperties.CHECK2 && n >= this.size) {
            this.throwException(n);
        }
        T t = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - n - 1);
        --this.size;
        this.data[this.size] = null;
        return t;
    }

    public void removeRange(int n, int n2) {
        if (SysProperties.CHECK2 && (n2 > this.size || n > n2)) {
            throw new ArrayIndexOutOfBoundsException("to=" + n2 + " from=" + n + " size=" + this.size);
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        for (int i = this.size + (n2 - n) - 1; i >= this.size; --i) {
            this.data[i] = null;
        }
    }

    public void setSize(int n) {
        this.ensureCapacity(n);
        this.size = n;
    }

    private void ensureCapacity(int n) {
        while (n >= this.data.length) {
            T[] TArray = this.createArray(Math.max(4, this.data.length * 2));
            System.arraycopy(this.data, 0, TArray, 0, this.size);
            this.data = TArray;
        }
    }

    public void trimToSize() {
        T[] TArray = this.createArray(this.size);
        System.arraycopy(this.data, 0, TArray, 0, this.size);
        this.data = TArray;
    }

    public void add(int n, T t) {
        if (SysProperties.CHECK2 && n > this.size) {
            this.throwException(n);
        }
        this.ensureCapacity(this.size);
        if (n == this.size) {
            this.add(t);
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
            this.data[n] = t;
            ++this.size;
        }
    }

    public void set(int n, T t) {
        if (SysProperties.CHECK2 && n >= this.size) {
            this.throwException(n);
        }
        this.data[n] = t;
    }

    public int size() {
        return this.size;
    }

    public void toArray(Object[] objectArray) {
        ObjectUtils.arrayCopy(this.data, objectArray, this.size);
    }

    public void clear() {
        if (this.data.length > 256) {
            this.data = this.createArray(4);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.data[i] = null;
            }
        }
        this.size = 0;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != object) continue;
            return i;
        }
        return -1;
    }

    public void addAll(ObjectArray<? extends T> objectArray) {
        for (int i = 0; i < objectArray.size; ++i) {
            this.add(objectArray.data[i]);
        }
    }

    private void swap(int n, int n2) {
        T t = this.data[n2];
        this.data[n2] = this.data[n];
        this.data[n] = t;
    }

    public void sort(Comparator<T> comparator) {
        this.sort(comparator, 0, this.size - 1);
    }

    private void sort(Comparator<T> comparator, int n, int n2) {
        T t;
        int n3;
        int n4;
        while (n2 - n > 10) {
            n4 = RandomUtils.nextInt(n2 - n - 4) + n + 2;
            if (comparator.compare(this.get(n), this.get(n2)) > 0) {
                this.swap(n, n2);
            }
            if (comparator.compare(this.get(n4), this.get(n)) < 0) {
                this.swap(n, n4);
            } else if (comparator.compare(this.get(n4), this.get(n2)) > 0) {
                this.swap(n4, n2);
            }
            n3 = n2 - 1;
            this.swap(n4, n3);
            t = this.get(n3);
            n4 = n;
            while (true) {
                if (comparator.compare(this.get(++n4), t) < 0) {
                    continue;
                }
                while (comparator.compare(this.get(--n3), t) > 0) {
                }
                if (n4 >= n3) break;
                this.swap(n4, n3);
            }
            this.swap(n4, n2 - 1);
            this.sort(comparator, n, n4 - 1);
            n = n4 + 1;
        }
        for (n4 = n + 1; n4 <= n2; ++n4) {
            t = this.get(n4);
            for (n3 = n4 - 1; n3 >= n && comparator.compare(this.get(n3), t) > 0; --n3) {
                this.set(n3 + 1, this.get(n3));
            }
            this.set(n3 + 1, t);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ObjectArrayIterator();
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder("{");
        for (int i = 0; i < this.size; ++i) {
            statementBuilder.appendExceptFirst(", ");
            T t = this.get(i);
            statementBuilder.append(t == null ? "" : t.toString());
        }
        return statementBuilder.append('}').toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ObjectArrayIterator
    implements Iterator<T> {
        private int index;

        ObjectArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ObjectArray.this.size;
        }

        @Override
        public T next() {
            return ObjectArray.this.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

