/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.activity.Flow;
import org.ow2.orchestra.definition.activity.Pick;
import org.ow2.orchestra.definition.activity.Receive;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.activity.Sequence;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.definition.element.Target;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.data.def.ProcessDefinitionData;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.StyleSheetRepository;
import org.ow2.orchestra.wsdl.WsdlsInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelProcess
extends ProcessDefinitionImpl {
    private static final long serialVersionUID = 1L;
    protected String queryLanguage;
    protected String expressionLanguage;
    protected boolean suppressJoinFailure = false;
    protected boolean exitOnStandardFault = false;
    protected String targetNamespace = null;
    protected ProcessDefinitionUUID processUUID;
    protected WsdlsInfos wsdlInfos;
    protected StyleSheetRepository styleSheetRepository;
    protected Map<OperationKey, InboundMessageElement> startElements;
    protected Map<OperationKey, Receiver> receivers = new HashMap<OperationKey, Receiver>();
    protected Collection<CorrelationSet> commonCorrelationSets = null;
    protected InstanceCounter instanceCounter;

    public BpelProcess(String name, String targetNamespace, long version) {
        this.name = name;
        this.targetNamespace = targetNamespace;
        this.processUUID = IdFactory.getNewProcessUUID(targetNamespace, name, Long.toString(version));
        this.instanceCounter = new InstanceCounter(this);
    }

    protected BpelProcess() {
    }

    @Override
    protected ExecutionImpl newProcessInstance() {
        ProcessInstanceUUID processInstanceUUID = IdFactory.getNewInstanceUUID(this.getUUID(), this.instanceCounter.getAndIncrementCounter());
        BpelExecution instance = new BpelExecution(processInstanceUUID);
        instance.setProcessDefinition(this);
        instance.setProcessInstance(instance);
        EnvTool.getRepository().storeInstance(instance);
        return instance;
    }

    public InboundMessageElement addStartElement(OperationKey operationKey, InboundMessageElement receivingElement) {
        if (this.startElements == null) {
            this.startElements = new HashMap<OperationKey, InboundMessageElement>();
        }
        return this.startElements.put(operationKey, receivingElement);
    }

    public InboundMessageElement getStartElement(OperationKey operationKey) {
        if (this.startElements != null) {
            return this.startElements.get(operationKey);
        }
        return null;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public boolean isSuppressJoinFailure() {
        return this.suppressJoinFailure;
    }

    public void setSuppressJoinFailure(boolean suppressJoinFailure) {
        this.suppressJoinFailure = suppressJoinFailure;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setWsdlInfos(WsdlsInfos wsdlInfos) {
        this.wsdlInfos = wsdlInfos;
    }

    public WsdlsInfos getWsdlInfos() {
        return this.wsdlInfos;
    }

    public QName getQName() {
        return new QName(this.targetNamespace, this.name);
    }

    public StyleSheetRepository getStyleSheetRepository() {
        return this.styleSheetRepository;
    }

    public void setStyleSheetRepository(StyleSheetRepository styleSheetRepository) {
        this.styleSheetRepository = styleSheetRepository;
    }

    public void staticAnalysisCheck(Parse parse) {
        if (this.startElements == null) {
            String message = StaticAnalysisFault.getMessage("SA00015", "  Process should have at least one receive or pick with createInstance set to yes");
            parse.addProblem(message, new StaticAnalysisException("SA00015"));
        } else {
            HashSet<InboundMessageElement> startElementFound = new HashSet<InboundMessageElement>();
            this.isFirstActivityCreateInstance(this.getInitial(), parse, startElementFound);
            HashSet<ReceivingElement> receivingElementFound = new HashSet<ReceivingElement>();
            for (InboundMessageElement inMsgElt : startElementFound) {
                receivingElementFound.addAll(inMsgElt.getReceivingElements());
            }
            int nbUnreachable = this.getStartElements().size() - receivingElementFound.size();
            if (nbUnreachable != 0) {
                String message = StaticAnalysisFault.getMessage("SA00056", nbUnreachable + " activities with \"createInstance='yes'\" are not process start activities.");
                parse.addProblem(message, new StaticAnalysisException("SA00056"));
            } else if (startElementFound.size() > 1) {
                try {
                    this.commonCorrelationSets = this.checkCommonCS();
                }
                catch (StaticAnalysisException e) {
                    parse.addProblem(e.getMessage(), e);
                }
            }
        }
    }

    private void isFirstActivityCreateInstance(NodeImpl node, Parse parse, Set<InboundMessageElement> startElementFound) {
        AbstractBpelActivity activity = (AbstractBpelActivity)node.getBehaviour();
        if (activity instanceof Receive) {
            if (((Receive)activity).isCreateInstance()) {
                startElementFound.add((InboundMessageElement)((Object)activity));
                return;
            }
        } else if (activity instanceof Pick && ((Pick)activity).isCreateInstance()) {
            startElementFound.add((InboundMessageElement)((Object)activity));
            return;
        }
        if (!this.hasControlDependencyOnStartActivity(activity)) {
            if (activity instanceof Scope) {
                this.isFirstActivityCreateInstance((NodeImpl)node.getNodes().get(0), parse, startElementFound);
            } else if (activity instanceof Sequence) {
                this.isFirstActivityCreateInstance((NodeImpl)node.getNodes().get(0), parse, startElementFound);
            } else if (activity instanceof Flow) {
                for (Node child : node.getNodes()) {
                    this.isFirstActivityCreateInstance((NodeImpl)child, parse, startElementFound);
                }
            } else {
                String message = StaticAnalysisFault.getMessage("SA00056", "Activity " + node.getName() + " is not a start activity");
                parse.addProblem(message, new StaticAnalysisException("SA00056"));
            }
        }
    }

    private boolean hasControlDependencyOnStartActivity(AbstractBpelActivity activity) {
        if (this.startElements.containsValue(activity)) {
            return true;
        }
        if (activity.getTargets() != null) {
            for (Target t : activity.getTargets()) {
                if (!this.hasControlDependencyOnStartActivity(t.getLink().getSourceActivity())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<CorrelationSet> checkCommonCS() {
        HashSet<CorrelationSet> commonCS = null;
        boolean initialized = false;
        for (InboundMessageElement inboundMessageElement : this.startElements.values()) {
            for (ReceivingElement startElement : inboundMessageElement.getReceivingElements()) {
                List<Correlation> correlations = startElement.getCorrelations();
                if (correlations != null && !correlations.isEmpty()) {
                    if (!initialized) {
                        commonCS = new HashSet<CorrelationSet>();
                        for (Correlation correlation : correlations) {
                            commonCS.add(correlation.getCorrelationSet());
                        }
                    } else {
                        if (commonCS == null) {
                            throw new StaticAnalysisException("SA00057");
                        }
                        HashSet<CorrelationSet> elementCs = new HashSet<CorrelationSet>();
                        for (Correlation correlation : correlations) {
                            elementCs.add(correlation.getCorrelationSet());
                        }
                        commonCS.retainAll(elementCs);
                        if (commonCS.isEmpty()) {
                            throw new StaticAnalysisException("SA00057");
                        }
                    }
                } else if (commonCS != null) {
                    throw new StaticAnalysisException("SA00057");
                }
                initialized = true;
            }
        }
        if (commonCS != null) {
            for (CorrelationSet cs : commonCS) {
                for (InboundMessageElement inboundMessageElement : this.startElements.values()) {
                    for (ReceivingElement startElement : inboundMessageElement.getReceivingElements()) {
                        for (Correlation correlation : startElement.getCorrelations()) {
                            if (!correlation.getCorrelationSet().equals(cs) || correlation.getInitiate().equals((Object)Correlation.Initiate.join)) continue;
                            throw new StaticAnalysisException("SA00057");
                        }
                    }
                }
            }
        }
        return commonCS;
    }

    public ProcessDefinitionUUID getUUID() {
        return this.processUUID;
    }

    public ProcessDefinitionData getProcessDefinitionData() {
        return new ProcessDefinitionData(this.getUUID(), this.name, this.targetNamespace);
    }

    public void addReceiver(Receiver receiver) {
        this.receivers.put(receiver.getOperationKey(), receiver);
    }

    public void removeReceiver(OperationKey operationKey) {
        this.receivers.remove(operationKey);
    }

    public Collection<Receiver> getReceivers() {
        return this.receivers.values();
    }

    public Receiver getReceiver(OperationKey operationKey) {
        return this.receivers.get(operationKey);
    }

    public Map<OperationKey, InboundMessageElement> getStartElements() {
        return this.startElements;
    }

    public Collection<CorrelationSet> getCommonCorrelationSets() {
        return this.commonCorrelationSets;
    }

    protected void setCommonCorrelationSets(Set<CorrelationSet> commonCorrelationSets) {
        this.commonCorrelationSets = commonCorrelationSets;
    }

    public static class InstanceCounter {
        protected long dbid;
        protected int value = 1;
        protected BpelProcess bpelProcess;
        protected ProcessDefinitionUUID processUUID;

        protected InstanceCounter() {
        }

        private InstanceCounter(BpelProcess bpelProcess) {
            this.bpelProcess = bpelProcess;
            this.processUUID = bpelProcess.getUUID();
        }

        protected int getAndIncrementCounter() {
            return this.value++;
        }

        public BpelProcess getBpelProcess() {
            return this.bpelProcess;
        }
    }
}

