/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.data.def.ReceiveActivityDefinitionData;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.ReceivingElementUtil;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Receive
extends AbstractBpelActivity
implements ReceivingElement,
InboundMessageElement {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Receive.class.getName());
    protected String partnerLinkName = null;
    protected OperationKey operationKey = null;
    protected String variable = null;
    protected boolean createInstance = false;
    protected String messageExchange = "Orchestra default message exchange";
    protected List<Correlation> correlations = null;
    protected List<Copy> inCopies;
    protected Variable anonymousInboundMessageVariable;

    public Receive() {
        this.executeSourcesAsync = true;
    }

    @Override
    public void executeActivity(BpelExecution execution) {
        execution.getProcessInstance().addWaitingExecution(execution);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Receive " + this.operationKey + " : waiting...");
        }
        execution.waitForSignal();
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        MessageVariable message = (MessageVariable)parameters.get("message");
        MessageCarrier messageCarrier = (MessageCarrier)parameters.get("messageCarrier");
        ReceivingElementUtil.receive(this, message, messageCarrier, execution);
        execution.getProcessInstance().getWaitingExecutions().remove(execution);
        this.afterRunned(execution);
    }

    @Override
    public String getPartnerLinkName() {
        return this.partnerLinkName;
    }

    @Override
    public String getOperation() {
        return this.getOperationKey().getOperationName();
    }

    @Override
    public QName getPortTypeQName() {
        return this.getOperationKey().getPortTypeQName();
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void setPartnerLinkName(String partnerLinkName) {
        this.partnerLinkName = partnerLinkName;
    }

    @Override
    public List<Correlation> getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(List<Correlation> correlations) {
        this.correlations = correlations;
    }

    public boolean isCreateInstance() {
        return this.createInstance;
    }

    public void setCreateInstance(boolean createInstance) {
        this.createInstance = createInstance;
    }

    @Override
    public String getMessageExchange() {
        return this.messageExchange;
    }

    public void setMessageExchange(String messageExchange) {
        this.messageExchange = messageExchange;
    }

    @Override
    public Variable getAnonymousInboundMessageVariable() {
        return this.anonymousInboundMessageVariable;
    }

    public void setAnonymousInboundMessageVariable(Variable anonymousInboundMessageVariable) {
        this.anonymousInboundMessageVariable = anonymousInboundMessageVariable;
    }

    @Override
    public List<Copy> getInCopies() {
        return this.inCopies;
    }

    public void setInCopies(List<Copy> inCopies) {
        this.inCopies = inCopies;
    }

    @Override
    public OperationKey getOperationKey() {
        return this.operationKey;
    }

    public void setOperationKey(OperationKey operationKey) {
        this.operationKey = operationKey;
    }

    @Override
    public List<ReceivingElement> getReceivingElements() {
        ArrayList<ReceivingElement> list = new ArrayList<ReceivingElement>();
        list.add(this);
        return list;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.RECEIVE;
    }

    @Override
    public ReceiveActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ReceiveActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name, null, null, null);
    }
}

