/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.ow2.orchestra.env.EnvFactoryRepository;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.commands.DeployCommand;
import org.ow2.orchestra.jmx.commands.ExitInstanceCommand;
import org.ow2.orchestra.jmx.commands.FindActivityInstancesCommand;
import org.ow2.orchestra.jmx.commands.FindJobsWithExceptionCommand;
import org.ow2.orchestra.jmx.commands.FindProcessDefinitionsCommand;
import org.ow2.orchestra.jmx.commands.FindProcessInstancesCommand;
import org.ow2.orchestra.jmx.commands.GetActivityDefinitionCommand;
import org.ow2.orchestra.jmx.commands.GetActivityInstanceCommand;
import org.ow2.orchestra.jmx.commands.GetProcessDefinitionCommand;
import org.ow2.orchestra.jmx.commands.GetProcessInstanceCommand;
import org.ow2.orchestra.jmx.commands.InitializeCommand;
import org.ow2.orchestra.jmx.commands.ResumeInstanceCommand;
import org.ow2.orchestra.jmx.commands.RetryJobCommand;
import org.ow2.orchestra.jmx.commands.SuspendInstanceCommand;
import org.ow2.orchestra.jmx.commands.UndeployCommand;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteDeployerImpl
implements RemoteDeployerMBean {
    protected CommandService getCommandService() {
        EnvironmentFactory environmentFactory = EnvFactoryRepository.get();
        Misc.badStateIfNull(environmentFactory, "environmentFactory is null.");
        return environmentFactory.get(CommandService.class);
    }

    public <T> T execute(Command<T> command) {
        return this.getCommandService().execute(command);
    }

    @Override
    public ProcessDefinition deploy(Deployment bpelDeployment) {
        return this.getCommandService().execute(new DeployCommand(bpelDeployment));
    }

    @Override
    public boolean undeploy(QName processQName) {
        return this.getCommandService().execute(new UndeployCommand(processQName));
    }

    @Override
    public boolean undeploy(ProcessDefinitionUUID pduuid) {
        return this.getCommandService().execute(new UndeployCommand(pduuid));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions() {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand());
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(ProcessState state) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(state));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processName, ProcessState state) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(state, processName));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processName) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(processName));
    }

    @Override
    public ProcessDefinition getProcessDefinition(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new GetProcessDefinitionCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefUUID) throws ActivityNotFoundException {
        try {
            return this.getCommandService().execute(new GetActivityDefinitionCommand(activityDefUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ActivityNotFoundException) {
                throw (ActivityNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessDefinition deployBar(byte[] barFile) {
        try {
            ZipEntry zipFile;
            new File(System.getProperty("java.io.tmpdir")).mkdirs();
            File tmpDir = File.createTempFile("orch", null, null);
            tmpDir.delete();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Cannot create the temporary directory '" + tmpDir + "'.");
            }
            ArrayList<URL> wsdlUrls = new ArrayList<URL>();
            URL bpelFile = null;
            ByteArrayInputStream in = new ByteArrayInputStream(barFile);
            ZipInputStream zipInput = new ZipInputStream(in);
            while ((zipFile = zipInput.getNextEntry()) != null) {
                File outFile = new File(tmpDir.getAbsolutePath() + File.separator + zipFile.getName());
                FileOutputStream outputFile = new FileOutputStream(outFile);
                try {
                    int c;
                    while ((c = zipInput.read()) != -1) {
                        outputFile.write(c);
                    }
                }
                finally {
                    outputFile.close();
                }
                if (zipFile.getName().endsWith(".wsdl")) {
                    wsdlUrls.add(outFile.toURI().toURL());
                    continue;
                }
                if (!zipFile.getName().endsWith(".bpel")) continue;
                if (bpelFile != null) {
                    throw new OrchestraRuntimeException("Bar contains more than one bpel file.");
                }
                bpelFile = outFile.toURI().toURL();
            }
            zipInput.close();
            ((InputStream)in).close();
            Deployment deployment = DeploymentUtil.generateDeployment(bpelFile, wsdlUrls);
            ProcessDefinition process = this.deploy(deployment);
            Misc.deleteDir(tmpDir);
            return process;
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("Unable to deploy bar", e);
        }
    }

    @Override
    public void initialize() {
        this.getCommandService().execute(new InitializeCommand());
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new FindActivityInstancesCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ActivityInstance> findActivityInstances(ProcessInstanceUUID processUUID, ActivityState activityState) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new FindActivityInstancesCommand(processUUID, activityState));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances() {
        return this.getCommandService().execute(new FindProcessInstancesCommand());
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new FindProcessInstancesCommand(processDefinitionUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new FindProcessInstancesCommand(processDefinitionUUID, processInstanceState));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstance> findProcessInstances(ActivityState processInstanceState) {
        return this.getCommandService().execute(new FindProcessInstancesCommand(processInstanceState));
    }

    @Override
    public ProcessInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new GetProcessInstanceCommand(processInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ActivityInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) throws ActivityInstanceNotFoundException {
        try {
            return this.getCommandService().execute(new GetActivityInstanceCommand(activityInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ActivityInstanceNotFoundException) {
                throw (ActivityInstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void exit(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new ExitInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public void resume(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new ResumeInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public void suspend(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new SuspendInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public List<JobData> findJobsWithException() {
        return this.getCommandService().execute(new FindJobsWithExceptionCommand());
    }

    @Override
    public void retryJob(JobData jobData, int retries) throws JobNotFoundException {
        if (!this.getCommandService().execute(new RetryJobCommand(retries, jobData)).booleanValue()) {
            throw new JobNotFoundException(jobData);
        }
    }
}

