/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.osgi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpService;
import org.ow2.orchestra.osgi.OrchestraExtensionService;
import org.ow2.orchestra.osgi.OrchestraOSGiEngine;
import org.ow2.orchestra.util.Misc;

public class OrchestraWSEngineActivator {
    private static final String DEFAULT_ENV_CONFIG_FILE = "conf/environment.xml";
    private static final String DEFAULT_ENV_CONFIG_RESOURCE = "environment.xml";
    protected HttpService httpService;
    protected OrchestraExtensionService orchestraExtensionService;
    protected ConfigurationAdmin configAdmin;
    private final BundleContext context;
    private Configuration engineConfig;

    public OrchestraWSEngineActivator(BundleContext context) {
        this.context = context;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setOrchestraExtensionService(OrchestraExtensionService orchestraExtensionService) {
        this.orchestraExtensionService = orchestraExtensionService;
    }

    public void unsetOrchestraExtensionService(OrchestraExtensionService orchestraExtensionService) {
        this.orchestraExtensionService = null;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void unsetConfigAdmin(ConfigurationAdmin configAdmin) throws IOException {
        if (this.engineConfig != null) {
            this.engineConfig.delete();
            this.engineConfig = null;
        }
        this.configAdmin = null;
    }

    public void start() throws Exception {
        URL envUrl = null;
        File envFile = new File(DEFAULT_ENV_CONFIG_FILE);
        if (envFile.exists()) {
            try {
                envUrl = envFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Misc.unreachableStatement();
            }
        }
        if (envUrl == null) {
            envUrl = this.context.getBundle().getResource(DEFAULT_ENV_CONFIG_RESOURCE);
        }
        Misc.log(Level.INFO, "Environment will be taken from: %s", envUrl);
        this.engineConfig = this.configAdmin.createFactoryConfiguration(OrchestraOSGiEngine.class.getName(), null);
        Properties engineProperties = new Properties();
        engineProperties.setProperty("environmentLocation", envUrl.toExternalForm());
        this.engineConfig.update((Dictionary)engineProperties);
    }

    public void stop() throws Exception {
        this.unsetConfigAdmin(this.configAdmin);
        this.unsetOrchestraExtensionService(this.orchestraExtensionService);
    }
}

