/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.Flow;
import org.ow2.orchestra.definition.element.Link;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.FlowActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.FlowActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(FlowBinding.class.getName());

    public FlowBinding() {
        super("flow", ActivityType.FLOW);
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        Flow flow = new Flow();
        this.setEnclosingScope(flow, parse);
        this.parseStandardAttributes(element, flow, parse);
        this.parseStandardElements(element, flow, parse);
        Element linksElement = XmlUtil.element(element, "links");
        if (linksElement != null) {
            List<Element> linkElements = XmlUtil.elements(linksElement, "link");
            this.parseLinks(linkElements, flow, parse);
        }
        NodeImpl activityNode = this.createActivityNodeWithChildren(element, parse, parser, flow);
        this.checkLinks(flow, parse);
        return activityNode;
    }

    private void parseLinks(List<Element> linkElements, Flow flow, Parse parse) {
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        FlowActivityFullDefinition flowActivityFullDefinition = (FlowActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
        ArrayList<String> linkList = new ArrayList<String>();
        HashMap<String, Link> links = new HashMap<String, Link>();
        if (linkElements != null) {
            for (Element linkElement : linkElements) {
                String linkName = XmlUtil.attribute(linkElement, "name");
                if (links.containsKey(linkName)) {
                    String message = StaticAnalysisFault.getMessage("SA00064", "  link " + linkName + " defined twice in flow " + flow.getName());
                    parse.addProblem(message, new StaticAnalysisException("SA00064"));
                    continue;
                }
                Link link = new Link();
                link.setName(linkName);
                links.put(linkName, link);
                linkList.add(linkName);
            }
        }
        flow.setLinks(links);
        flowActivityFullDefinition.setLinks(linkList);
    }

    private void checkLinks(Flow flow, Parse parse) {
        Map<String, Link> links = flow.getLinks();
        if (links != null) {
            for (Link link : links.values()) {
                if (link.getSourceActivity() != null && link.getTargetActivity() != null) continue;
                String message = StaticAnalysisFault.getMessage("SA00066", "  Link " + link.getName() + " missing either source or target");
                parse.addProblem(message, new StaticAnalysisException("SA00066"));
            }
        }
    }

    @Override
    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new FlowActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

