/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.ejb;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.ejb.LocalTimer;
import org.ow2.orchestra.pvm.internal.ejb.LocalTimerHome;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.job.Timer;
import org.ow2.orchestra.pvm.session.DbSession;
import org.ow2.orchestra.pvm.session.TimerSession;

public class EnterpriseTimerSession
implements TimerSession {
    private LocalTimerHome timerHome;
    private static final Log LOG = Log.getLog(EnterpriseTimerSession.class.getName());

    public void schedule(Timer timer) {
        LOG.debug("scheduling " + timer);
        DbSession dbSession = Environment.getCurrent().get(DbSession.class);
        dbSession.save(timer);
        dbSession.flush();
        try {
            LocalTimer timerBean = this.timerHome.findByPrimaryKey(timer.getDbid());
            timerBean.schedule();
        }
        catch (FinderException e) {
            throw new PvmException("could not find bean for timer: " + timer);
        }
    }

    public void cancel(Timer timer) {
        try {
            LocalTimer timerBean = this.timerHome.findByPrimaryKey(timer.getDbid());
            LOG.debug("canceling " + timer);
            timerBean.remove();
        }
        catch (FinderException e) {
            LOG.error("could not find bean for timer " + timer, e);
        }
        catch (RemoveException e) {
            LOG.error("could not remove bean for timer " + timer, e);
        }
    }
}

