/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.stream.UrlStreamSource;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.DeployerManagerDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class DeployerManagerBinding
extends WireDescriptorBinding {
    private static final Log LOG = Log.getLog(DeployerManagerBinding.class.getName());

    public DeployerManagerBinding() {
        super("deployer-manager");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        List<Element> languageElements;
        DeployerManagerDescriptor descriptor = new DeployerManagerDescriptor();
        if (element.hasAttribute("resource")) {
            String resource = element.getAttribute("resource");
            try {
                Enumeration<URL> enumeration = ReflectUtil.getResources(parse.getClassLoader(), resource);
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        URL url = enumeration.nextElement();
                        LOG.trace("importing language deployers from " + url);
                        parser.importStream(new UrlStreamSource(url), element, parse);
                    }
                }
            }
            catch (Exception e) {
                parse.addProblem("couldn't parse language deployer resource '" + resource + "'", e);
            }
        }
        if ((languageElements = XmlUtil.elements(element, "language")) != null) {
            for (Element languageElement : languageElements) {
                String language = null;
                if (languageElement.hasAttribute("name")) {
                    language = languageElement.getAttribute("name");
                } else {
                    parse.addProblem("name is a required attribute in element language: " + XmlUtil.toString(languageElement));
                }
                String extension = null;
                if (element.hasAttribute("extension")) {
                    language = element.getAttribute("extension");
                }
                ArrayList<Descriptor> deployerDescriptors = new ArrayList<Descriptor>();
                List<Element> deployerElements = XmlUtil.elements(languageElement);
                if (deployerElements != null) {
                    for (Element deployerElement : deployerElements) {
                        Descriptor deployerDescriptor = (Descriptor)parser.parseElement(deployerElement, parse, "descriptor");
                        deployerDescriptors.add(deployerDescriptor);
                    }
                }
                if (deployerDescriptors.isEmpty()) {
                    parse.addProblem("no deployers defined for " + language);
                }
                descriptor.addLanguage(language, extension, deployerDescriptors);
            }
        } else {
            parse.addProblem("at least one language is required in a deployer-manager: " + XmlUtil.toString(element));
        }
        return descriptor;
    }
}

