/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.pvm.internal.util.PvmXmlUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ArgDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.operation.Operation;
import org.ow2.orchestra.pvm.internal.wire.xml.WireParser;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class ObjectBinding
extends WireDescriptorBinding {
    public ObjectBinding() {
        super("object");
    }

    public static boolean isObjectDescriptor(Element element) {
        if (XmlUtil.attribute(element, "class") != null) {
            return true;
        }
        if (XmlUtil.attribute(element, "factory") != null) {
            return true;
        }
        return XmlUtil.element(element, "factory") != null;
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        ObjectDescriptor descriptor = new ObjectDescriptor();
        WireParser wireParser = (WireParser)parser;
        String className = XmlUtil.attribute(element, "class");
        String factoryObjectName = XmlUtil.attribute(element, "factory");
        Element factoryElement = XmlUtil.element(element, "factory");
        if (className != null) {
            Element constructorElement;
            descriptor.setClassName(className);
            if (factoryObjectName != null) {
                parse.addProblem("attribute 'factory' is specified together with attribute 'class' in element 'object': " + XmlUtil.toString(element));
            }
            if (factoryElement != null) {
                parse.addProblem("element 'factory' is specified together with attribute 'class' in element 'object': " + XmlUtil.toString(element));
            }
            if ((constructorElement = XmlUtil.element(element, "constructor")) != null) {
                List<Element> argElements = XmlUtil.elements(constructorElement, "arg");
                List<ArgDescriptor> argDescriptors = wireParser.parseArgs(argElements, parse);
                descriptor.setArgDescriptors(argDescriptors);
                if (element.hasAttribute("method")) {
                    parse.addProblem("attributes 'class' and 'method' indicate static method and also a 'constructor' element is specified for element 'object': " + XmlUtil.toString(element));
                }
            }
        } else if (factoryObjectName != null) {
            descriptor.setFactoryObjectName(factoryObjectName);
            if (factoryElement != null) {
                parse.addProblem("element 'factory' is specified together with attribute 'factory' in element 'object': " + XmlUtil.toString(element));
            }
        } else if (factoryElement != null) {
            Element factoryDescriptorElement = XmlUtil.element(factoryElement);
            Descriptor factoryDescriptor = (Descriptor)parser.parseElement(factoryDescriptorElement, parse, "descriptor");
            descriptor.setFactoryDescriptor(factoryDescriptor);
        } else {
            parse.addProblem("element 'object' must have one of {attribute 'class', attribute 'factory' or element 'factory'}: " + XmlUtil.toString(element));
        }
        if (element.hasAttribute("method")) {
            descriptor.setMethodName(element.getAttribute("method"));
            List<Element> argElements = XmlUtil.elements(element, "arg");
            List<ArgDescriptor> argDescriptors = wireParser.parseArgs(argElements, parse);
            descriptor.setArgDescriptors(argDescriptors);
        } else if (className == null) {
            parse.addProblem("element 'object' with a element 'factory' or a attribute 'factory' must have a attribute 'method': " + XmlUtil.toString(element));
        }
        if (className == null && XmlUtil.element(element, "constructor") != null) {
            parse.addProblem("element 'object' with a element 'factory' or a attribute 'factory' can't have a 'constructor' element: " + XmlUtil.toString(element));
        }
        ArrayList<Operation> operations = null;
        List<Element> elements = XmlUtil.elements(element);
        if (elements != null) {
            for (Element childElement : elements) {
                if (childElement.getTagName().equals("constructor") || childElement.getTagName().equals("factory") || childElement.getTagName().equals("arg")) continue;
                Operation operation = (Operation)parser.parseElement(childElement, parse, "operation");
                if (operation != null) {
                    if (operations == null) {
                        operations = new ArrayList<Operation>();
                    }
                    operations.add(operation);
                    continue;
                }
                parse.addProblem("element 'object' can only have 'factory', 'arg', 'constructor' elements or an operation element (" + parser.getBindings().getTagNames("operation") + ")." + " Invalid element '" + childElement.getTagName() + "' in: " + XmlUtil.toString(element));
            }
        }
        descriptor.setOperations(operations);
        Boolean isAutoWireEnabled = PvmXmlUtil.attributeBoolean(element, "auto-wire", false, parse);
        if (isAutoWireEnabled != null) {
            descriptor.setAutoWireEnabled(isAutoWireEnabled);
        }
        return descriptor;
    }
}

