/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.processlog;

import java.text.SimpleDateFormat;
import java.util.List;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.processlog.ProcessLog;
import org.ow2.orchestra.pvm.processlog.ProcessLogProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessLogXmlSerializer {
    public static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss,SSS");
    protected List<ProcessLogProperty> properties;

    public void appendLog(Document document, Element parent, ProcessLog processLog) {
        String logType = this.getEventType(processLog);
        String time = this.getTime(processLog);
        String executionDbid = this.getExecutionDbid(processLog);
        String processInstanceDbid = this.getProcessInstanceDbid(processLog);
        String processInstanceKey = this.getProcessInstanceKey(processLog);
        Element logElement = document.createElement("log");
        parent.appendChild(logElement);
        logElement.setAttribute("type", logType);
        logElement.setAttribute("time", time);
        if (executionDbid != null) {
            logElement.setAttribute("execution", executionDbid);
        }
        if (processInstanceDbid != null) {
            logElement.setAttribute("instance", processInstanceDbid);
        }
        if (processInstanceKey != null) {
            logElement.setAttribute("key", processInstanceKey);
        }
        this.appendProperties(document, logElement, processLog.getProperties());
    }

    protected void appendProperties(Document document, Element parent, List<ProcessLogProperty> properties) {
        if (properties != null) {
            for (ProcessLogProperty property : properties) {
                Element propertyElement = document.createElement("property");
                parent.appendChild(propertyElement);
                if (property.name != null) {
                    propertyElement.setAttribute("name", property.name);
                }
                if (property.value != null) {
                    propertyElement.setAttribute("value", property.value);
                }
                this.appendProperties(document, propertyElement, property.getProperties());
            }
        }
    }

    protected String getEventType(ProcessLog processLog) {
        return processLog.getType();
    }

    protected String getTime(ProcessLog processLog) {
        return dateFormatter.format(processLog.getTime());
    }

    protected String getExecutionDbid(ProcessLog processLog) {
        Execution execution = processLog.getExecution();
        return execution != null ? Long.toString(execution.getDbid()) : null;
    }

    protected String getProcessInstanceDbid(ProcessLog processLog) {
        Execution processInstance = processLog.getProcessInstance();
        return processInstance != null ? Long.toString(processInstance.getDbid()) : null;
    }

    protected String getProcessInstanceKey(ProcessLog processLog) {
        Execution processInstance = processLog.getProcessInstance();
        return processInstance != null ? processInstance.getKey() : null;
    }
}

