/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Message;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.data.runtime.VariableUpdateData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;

public class VariableRuntime {
    protected long dbid;
    private static Logger log = Logger.getLogger(VariableRuntime.class.getName());
    protected String name;
    protected MessageVariable messageValue;
    protected Document xmlValue;
    protected Variable variableDefinition;
    protected ActivityInstanceUUID scopeActivityInstanceUUID;

    protected VariableRuntime() {
    }

    public VariableRuntime(Variable variableDefinition, BpelExecution execution, ActivityInstanceUUID scopeActivityInstanceUUID) {
        this.scopeActivityInstanceUUID = scopeActivityInstanceUUID;
        this.name = variableDefinition.getName();
        this.variableDefinition = variableDefinition;
        if (this.variableDefinition.getMessageType() != null) {
            Message message = execution.getWsdlInfos().getMessage(this.variableDefinition.getMessageType());
            if (message != null) {
                this.messageValue = new MessageVariable(message);
            }
        } else if (this.variableDefinition.getXmlType() != null) {
            this.xmlValue = BpelXmlUtil.createDefaultElement().getOwnerDocument();
        } else if (this.variableDefinition.getElement() != null) {
            this.xmlValue = XmlUtil.getDocumentWithOneElement(this.variableDefinition.getElement()).getOwnerDocument();
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("initializeXmlType : variable is not a type and is not an element... : this case is forbiden");
        }
    }

    public void initializeXmlType(BpelExecution execution) {
        Copy initCopy = this.variableDefinition.getVirtualCopy();
        if (initCopy != null) {
            initCopy.execute(execution);
        }
        this.updated(execution.getActivityInstanceUUID());
    }

    public boolean isXmlInitialized() {
        if (this.variableDefinition.getMessageType() != null) {
            throw new OrchestraRuntimeException("Variable " + this.name + " is a message, we cannot call " + this.getClass().getName() + ".isXmlInitialized method." + "please call isPartInitialized method");
        }
        return this.xmlValue != null;
    }

    public boolean isPartInitialized(String partName) {
        if (this.variableDefinition.getMessageType() == null) {
            throw new OrchestraRuntimeException("Variable " + this.name + " is not a message, we cannot call " + this.getClass().getName() + ".isPartInitialized method." + "please call isXmlInitialized method");
        }
        if (this.messageValue == null) {
            return false;
        }
        return this.messageValue.isPartInitialized(partName);
    }

    public Variable getVariableDefinition() {
        return this.variableDefinition;
    }

    public void setVariableDefinition(Variable variableDefinition) {
        this.variableDefinition = variableDefinition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        if (this.variableDefinition.getMessageType() != null) {
            return this.messageValue;
        }
        if (this.xmlValue == null) {
            return null;
        }
        return this.xmlValue.getDocumentElement();
    }

    public void setValue(MessageVariable message) {
        if (this.variableDefinition.getMessageType() == null) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.mismatchedAssignmentFailure, "trying to set a messageValue and the variableDefinition is not a messageType : " + this.toString(), null);
        }
        this.messageValue = message;
    }

    public void setValue(Object value, boolean keepSrcElementName) {
        if (this.variableDefinition.getMessageType() != null) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.mismatchedAssignmentFailure, "trying to set a xmlValue and the variableDefinition is a messageType : " + this.toString(), null);
        }
        if (this.xmlValue == null) {
            if (this.variableDefinition.getXmlType() != null) {
                this.xmlValue = BpelXmlUtil.createDefaultElement().getOwnerDocument();
            } else if (this.variableDefinition.getElement() != null) {
                this.xmlValue = XmlUtil.getDocumentWithOneElement(this.variableDefinition.getElement()).getOwnerDocument();
            } else {
                throw new OrchestraRuntimeException("trying to set a xmlValue and the variableDefinition type is unknown.");
            }
        }
        BpelXmlUtil.setObjectValue(this.xmlValue.getDocumentElement(), value, keepSrcElementName);
    }

    public void updated(ActivityInstanceUUID activityInstanceUUID) {
        if ("ORCHESTRA_4_INBOUND_WSDL_MESSAGE".equals(this.name) || "ORCHESTRA_4_OUTBOUND_WSDL_MESSAGE".equals(this.name)) {
            return;
        }
        if (this.variableDefinition.getMessageType() == null) {
            EnvTool.getRecorder().recordVariableUpdated(new VariableUpdateData(this.scopeActivityInstanceUUID, activityInstanceUUID, this.name, this.xmlValue.getDocumentElement()));
        } else {
            EnvTool.getRecorder().recordVariableUpdated(new VariableUpdateData(this.scopeActivityInstanceUUID, activityInstanceUUID, this.name, this.messageValue));
        }
    }

    public long getDbid() {
        return this.dbid;
    }
}

