/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ow2.orchestra.env.BpelEnvironmentParser;
import org.ow2.orchestra.jmx.JMXAgent;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.services.itf.HttpPublisher;
import org.ow2.orchestra.util.Misc;

public class OrchestraServlet
implements Servlet {
    private static final long serialVersionUID = 2528286722832028480L;
    private final JMXAgent jmxAgent = new JMXAgent();
    private static final String DEFAULT_ENV_CONFIG_FILE = "conf/environment.xml";
    private static final String DEFAULT_ENV_CONFIG_RESOURCE = "environment.xml";
    private Servlet delegate;

    public ServletConfig getServletConfig() {
        return this.delegate.getServletConfig();
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.delegate.service(req, res);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        URL envUrl = null;
        File envFile = new File(DEFAULT_ENV_CONFIG_FILE);
        if (envFile.exists()) {
            try {
                envUrl = envFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Misc.unreachableStatement();
            }
        }
        if (envUrl == null) {
            envUrl = ReflectUtil.getResource(null, DEFAULT_ENV_CONFIG_RESOURCE);
        }
        Misc.log(Level.INFO, "Environment will be taken from: %s", envUrl);
        EnvironmentFactory envFactory = BpelEnvironmentParser.parseEnvironmentFactoryFromURL(envUrl);
        HttpPublisher publisher = envFactory.get(HttpPublisher.class);
        this.delegate = publisher.getPublisherServlet();
        this.delegate.init(servletConfig);
        this.jmxAgent.startOrchestra(envFactory);
    }

    public void destroy() {
        this.delegate.destroy();
        this.jmxAgent.stopOrchestra();
    }
}

