/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BpelUtil {
    private BpelUtil() {
    }

    public static boolean isCreateInstance(Element element) {
        String createInstance = XmlUtil.attribute(element, "createInstance");
        return createInstance != null && createInstance.equals("yes");
    }

    public static Map<String, String> getAllNameSpaces(Node n) {
        NamedNodeMap attributes;
        HashMap<String, String> result = new HashMap<String, String>();
        if (n == null) {
            return result;
        }
        if (n.getParentNode() != null) {
            Map<String, String> resultParent = BpelUtil.getAllNameSpaces(n.getParentNode());
            for (Map.Entry<String, String> ns : resultParent.entrySet()) {
                if (result.containsKey(ns.getKey())) continue;
                result.put(ns.getKey(), ns.getValue());
            }
        }
        if ((attributes = n.getAttributes()) != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.item(i).getNodeName().contains("xmlns:")) continue;
                String nodeName = attributes.item(i).getNodeName();
                String prefix = nodeName.split(":")[1];
                result.put(prefix, attributes.item(i).getTextContent());
            }
        }
        result.put("bpel_func", "http://docs.oasis-open.org/wsbpel/2.0/process/executable");
        return result;
    }

    public static Object findExtensibilityElement(List listOfExtensibilityElement, Class classToFind) {
        for (Object extElem : listOfExtensibilityElement) {
            if (!classToFind.isInstance(extElem)) continue;
            return extElem;
        }
        return null;
    }

    public static boolean isXmlSchemaNs(String ns) {
        return ns != null && (ns.equals("http://www.w3.org/2001/XMLSchema") || ns.equals("http://www.w3.org/2001/xml.xsd"));
    }

    public static Document getServiceRefDocument(SOAPAddress address, QName serviceQN) {
        DocumentBuilder documentBuilder = XmlUtil.getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        XmlUtil.returnDocumentBuilder(documentBuilder);
        Element serviceRef = document.createElementNS("http://docs.oasis-open.org/wsbpel/2.0/serviceref", "service-ref");
        document.appendChild(serviceRef);
        Element epr = document.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference");
        serviceRef.appendChild(epr);
        Element addressElement = document.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
        addressElement.setTextContent(address.getLocationURI());
        epr.appendChild(addressElement);
        Element serviceNameElement = document.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceName");
        serviceNameElement.setAttribute("xmlns:eprServicePrefix", serviceQN.getNamespaceURI());
        serviceNameElement.setTextContent("eprServicePrefix:" + serviceQN.getLocalPart());
        epr.appendChild(serviceNameElement);
        return document;
    }

    public static Element getPartElement(Element father, Part part) {
        String partName = part.getName();
        List<Element> childrenElements = XmlUtil.elements(father);
        for (Element child : childrenElements) {
            if (!child.getLocalName().equals(partName)) continue;
            return child;
        }
        return null;
    }

    public static boolean booleanValue(String text, boolean defaultValue) {
        Boolean result = BpelUtil.booleanValue(text);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static Boolean booleanValue(String text) {
        if (text == null) {
            return null;
        }
        if ("true".equalsIgnoreCase(text) || "enabled".equalsIgnoreCase(text) || "on".equalsIgnoreCase(text) || "yes".equalsIgnoreCase(text)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(text) || "disabled".equalsIgnoreCase(text) || "off".equalsIgnoreCase(text) || "no".equalsIgnoreCase(text)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static boolean areNodeEquals(Node n1, Node n2) {
        Node n2Temp;
        Node n1Temp;
        NamedNodeMap n2NamedNodeMap;
        Misc.checkArgsNotNull(n1, n2);
        int i = 0;
        if (n1.getNodeType() != n2.getNodeType()) {
            return false;
        }
        if (n1.getNodeType() == 10 && !BpelUtil.areDocumentTypeEquals((DocumentType)n1, (DocumentType)n2)) {
            return false;
        }
        if (!BpelUtil.areStringEquals(n1.getLocalName(), n2.getLocalName())) {
            return false;
        }
        if (!BpelUtil.areStringEquals(n1.getNamespaceURI(), n2.getNamespaceURI())) {
            return false;
        }
        if (!BpelUtil.areStringEquals(n1.getNodeValue(), n2.getNodeValue())) {
            return false;
        }
        NamedNodeMap n1NamedNodeMap = n1.getAttributes();
        if (!BpelUtil.areNamedNodeMapNullOrDiffLength(n1NamedNodeMap, n2NamedNodeMap = n2.getAttributes())) {
            return false;
        }
        boolean found = false;
        int j = 0;
        if (n1NamedNodeMap != null && n1NamedNodeMap.getLength() > 0) {
            for (i = 0; i < n1NamedNodeMap.getLength() && !"http://www.w3.org/2000/xmlns/".equals((n1Temp = n1NamedNodeMap.item(i)).getNamespaceURI()); ++i) {
                String n1Name = n1Temp.getNodeName().contains(":") ? n1Temp.getLocalName() : n1Temp.getNodeName();
                n1Temp.normalize();
                for (j = 0; !found && j < n2NamedNodeMap.getLength(); ++j) {
                    n2Temp = n2NamedNodeMap.item(j);
                    String n2Name = n2Temp.getNodeName().contains(":") ? n2Temp.getLocalName() : n2Temp.getNodeName();
                    n2Temp.normalize();
                    found = n1Temp.getNodeValue().equals(n2Temp.getNodeValue()) && BpelUtil.areStringEquals(n1Name, n2Name) && BpelUtil.areStringEquals(n1Temp.getNamespaceURI(), n2Temp.getNamespaceURI());
                }
                if (found) continue;
                return false;
            }
        }
        NodeList n1ChildNodes = n1.getChildNodes();
        NodeList n2ChildNodes = n2.getChildNodes();
        if (n1ChildNodes != null && n2ChildNodes == null || n1ChildNodes == null && n2ChildNodes != null) {
            return false;
        }
        if (n1ChildNodes != null && n2ChildNodes != null) {
            if (n1ChildNodes.getLength() != n2ChildNodes.getLength()) {
                return false;
            }
            for (i = 0; i < n1ChildNodes.getLength(); ++i) {
                n1Temp = n1ChildNodes.item(i);
                n2Temp = n2ChildNodes.item(i);
                if (n2Temp == null) {
                    return false;
                }
                n1Temp.normalize();
                n2Temp.normalize();
                if (BpelUtil.areNodeEquals(n1Temp, n2Temp)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean areDocumentTypeEquals(DocumentType documentType1, DocumentType documentType2) {
        NamedNodeMap n2NamedNodeMap;
        if (!BpelUtil.areStringEquals(documentType1.getPublicId(), documentType2.getPublicId())) {
            return false;
        }
        if (!BpelUtil.areStringEquals(documentType1.getSystemId(), documentType2.getSystemId())) {
            return false;
        }
        if (!BpelUtil.areStringEquals(documentType1.getInternalSubset(), documentType2.getInternalSubset())) {
            return false;
        }
        NamedNodeMap n1NamedNodeMap = documentType1.getEntities();
        if (!BpelUtil.areNamedNodeMapNullOrDiffLength(n1NamedNodeMap, n2NamedNodeMap = documentType2.getEntities())) {
            return false;
        }
        if (!BpelUtil.areNamedNodeMapEquals(n1NamedNodeMap, n2NamedNodeMap)) {
            return false;
        }
        n1NamedNodeMap = documentType1.getNotations();
        if (!BpelUtil.areNamedNodeMapNullOrDiffLength(n1NamedNodeMap, n2NamedNodeMap = documentType2.getNotations())) {
            return false;
        }
        return BpelUtil.areNamedNodeMapEquals(n1NamedNodeMap, n2NamedNodeMap);
    }

    private static boolean areStringEquals(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null) {
            return false;
        }
        if (str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    private static boolean areNamedNodeMapNullOrDiffLength(NamedNodeMap n1NamedNodeMap, NamedNodeMap n2NamedNodeMap) {
        if (n1NamedNodeMap != null && n2NamedNodeMap == null || n1NamedNodeMap == null && n2NamedNodeMap != null) {
            return false;
        }
        if (n1NamedNodeMap == null) {
            return true;
        }
        int n1size = 0;
        for (int i = 0; i < n1NamedNodeMap.getLength(); ++i) {
            if ("http://www.w3.org/2000/xmlns/".equals(n1NamedNodeMap.item(i).getNamespaceURI())) continue;
            ++n1size;
        }
        int n2size = 0;
        for (int i = 0; i < n2NamedNodeMap.getLength(); ++i) {
            if ("http://www.w3.org/2000/xmlns/".equals(n2NamedNodeMap.item(i).getNamespaceURI())) continue;
            ++n2size;
        }
        return n1size == n2size;
    }

    private static boolean areNamedNodeMapEquals(NamedNodeMap n1NamedNodeMap, NamedNodeMap n2NamedNodeMap) {
        if (n1NamedNodeMap != null && n1NamedNodeMap.getLength() > 0) {
            int i = 0;
            for (i = 0; i < n1NamedNodeMap.getLength(); ++i) {
                Node n1Temp = n1NamedNodeMap.item(i);
                Node n2Temp = n2NamedNodeMap.item(i);
                if (n2Temp == null) {
                    return false;
                }
                n1Temp.normalize();
                n2Temp.normalize();
                if (n1Temp.isEqualNode(n2Temp)) continue;
                return false;
            }
        }
        return true;
    }
}

