/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.ActivityWithSingleChild;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;

public class CompensationHandlerActivity
extends ActivityWithSingleChild {
    private static final long serialVersionUID = -1532327461542960780L;
    private static Logger log = Logger.getLogger(CompensationHandlerActivity.class.getName());

    protected CompensationHandlerActivity() {
        super(null, null, null);
    }

    public CompensationHandlerActivity(NodeImpl child, ActivityDefinitionUUID uuid, String name) {
        super(child, uuid, name);
    }

    public void beforeRunning(BpelExecution bpelExecution) {
        super.beforeRunning(bpelExecution);
        ScopeRuntime scopeRuntime = bpelExecution.getCurrentScopeRuntime();
        scopeRuntime.setState(ScopeState.COMPENSATING);
    }

    public void signal(BpelExecution execution) {
        execution.end("ended");
        BpelExecution chExecution = execution.getParent();
        chExecution.removeExecution(execution);
        chExecution.end("ended");
        BpelExecution parentExecution = chExecution.getParent();
        parentExecution.removeExecution(chExecution);
        ScopeRuntime scopeRuntime = chExecution.popScopeRuntime(false);
        scopeRuntime.setState(ScopeState.COMPENSATED);
        BpelExecution compensateExecution = scopeRuntime.getCompensateExecution();
        scopeRuntime.setCompensateExecution(null);
        compensateExecution.signal();
    }

    public ActivityType getType() {
        return ActivityType.COMPENSATION_HANDLER;
    }
}

