/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import java.util.HashSet;
import java.util.Set;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindActivityInstancesCommand
implements Command<Set<ActivityInstance>> {
    private final ProcessInstanceUUID processUUID;
    private final ActivityState activityState;

    public FindActivityInstancesCommand(ProcessInstanceUUID processUUID, ActivityState activityState) {
        this.processUUID = processUUID;
        this.activityState = activityState;
    }

    public FindActivityInstancesCommand(ProcessInstanceUUID processUUID) {
        this.processUUID = processUUID;
        this.activityState = null;
    }

    @Override
    public Set<ActivityInstance> execute(Environment environment) {
        HashSet<ActivityInstance> result = new HashSet<ActivityInstance>();
        Querier querier = EnvTool.getQuerier();
        if (querier.getProcessInstance(this.processUUID) == null) {
            throw new OrchestraWrapperException(new InstanceNotFoundException(this.processUUID));
        }
        Set<ActivityFullInstance> activityFullInstances = this.processUUID != null && this.activityState != null ? querier.findActivityInstances(this.processUUID, this.activityState) : querier.findActivityInstances(this.processUUID);
        for (ActivityFullInstance activityFullInstance : activityFullInstances) {
            result.add((ActivityInstance)activityFullInstance.copy());
        }
        return result;
    }
}

