/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import java.util.List;
import javax.xml.namespace.QName;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.deployment.ProcessDeploymentCounter;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.RuntimeDbSession;
import org.ow2.orchestra.persistence.db.hibernate.QNameUserType;
import org.ow2.orchestra.pvm.internal.hibernate.HibernatePvmDbSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeDbSessionImpl
extends HibernatePvmDbSession
implements RuntimeDbSession {
    public RuntimeDbSessionImpl(Session session) {
        this.setSession(session);
        session.setFlushMode(FlushMode.COMMIT);
    }

    @Override
    public BpelProcess findBpelProcess(String namespace, String name, int version) {
        Query query = this.getSession().getNamedQuery("findBpelProcess");
        query.setString("namespace", namespace);
        query.setString("name", name);
        query.setInteger("version", version);
        BpelProcess processDefinition = (BpelProcess)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public BpelProcess findBpelProcess(String namespace, String name) {
        Query query = this.getSession().getNamedQuery("findLatestBpelProcess");
        query.setString("namespace", namespace);
        query.setString("name", name);
        return (BpelProcess)query.uniqueResult();
    }

    @Override
    public BpelProcess findBpelProcess(ProcessDefinitionUUID pduuid, boolean lock) {
        if (lock) {
            Query query = this.getSession().getNamedQuery("findBpelProcessForLock");
            query.setString("uuid", pduuid.toString());
            query.setLockMode("instanceCounter", LockMode.UPGRADE);
            BpelProcess.InstanceCounter res = (BpelProcess.InstanceCounter)query.uniqueResult();
            if (res != null) {
                return res.getBpelProcess();
            }
            return null;
        }
        return this.getBpelProcess(pduuid);
    }

    @Override
    public BpelProcess getBpelProcess(ProcessDefinitionUUID pduuid) {
        Query query = this.getSession().getNamedQuery("getBpelProcessByUUID");
        query.setParameter("uuid", (Object)pduuid);
        BpelProcess processDefinition = (BpelProcess)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public List<BpelProcess> getBpelProcesses() {
        Query query = this.getSession().getNamedQuery("getBpelProcesses");
        return query.list();
    }

    public Receiver getReceiver(OperationKey operationKey) {
        Query query = this.getSession().getNamedQuery("getReceiver");
        query.setParameter("processQName", (Object)operationKey.getProcessUUID(), Hibernate.custom(QNameUserType.class));
        query.setParameter("portTypeQName", (Object)operationKey.getPortTypeQName(), Hibernate.custom(QNameUserType.class));
        query.setString("operationName", operationKey.getOperationName());
        return (Receiver)query.uniqueResult();
    }

    public List<Receiver> getReceivers(QName processQName) {
        Query query = this.getSession().getNamedQuery("getReceivers");
        query.setParameter("processQName", (Object)processQName, Hibernate.custom(QNameUserType.class));
        return query.list();
    }

    @Override
    public List<BpelExecution> getBpelInstances() {
        Query query = this.getSession().getNamedQuery("getBpelInstances");
        return query.list();
    }

    @Override
    public BpelExecution getBpelInstance(ProcessInstanceUUID processInstanceUUID) {
        Query query = this.getSession().getNamedQuery("getBpelInstance");
        query.setString("processInstanceUUID", processInstanceUUID.toString());
        BpelExecution bpelExecution = (BpelExecution)query.uniqueResult();
        return bpelExecution;
    }

    @Override
    public List<BpelExecution> getBpelInstances(QName processQName) {
        Query query = this.getSession().getNamedQuery("getBpelInstancesOfProcess");
        query.setString("namespace", processQName.getNamespaceURI());
        query.setString("name", processQName.getLocalPart());
        return query.list();
    }

    @Override
    public ProcessDeploymentCounter getProcessDeploymentCounter() {
        return (ProcessDeploymentCounter)this.getSession().createCriteria(ProcessDeploymentCounter.class).uniqueResult();
    }
}

