/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractBpelActivity;
import org.ow2.orchestra.definition.activity.Process;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.activity.Activity;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.ExecElementToSignal;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.MessageCarrierRepository;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.ReplierKey;
import org.ow2.orchestra.services.impl.ReplierImpl;
import org.ow2.orchestra.services.itf.Replier;
import org.ow2.orchestra.util.ReceivingElementUtil;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Receiver {
    private static Logger log = Logger.getLogger(Receiver.class.getName());
    protected long dbid;
    protected int dbversion;
    private final Set<BpelExecution> waitingExecutions = new HashSet<BpelExecution>();
    private final List<PendingMessage> storedMessages = new ArrayList<PendingMessage>();
    private OperationKey operationKey;

    protected Receiver() {
    }

    public Receiver(OperationKey operationKey) {
        this.operationKey = operationKey;
    }

    static ExecElementToSignal findExecutionToSignal(BpelProcess bpelProcess, BpelExecution instance) {
        if (instance == null || instance.isEnded()) {
            return null;
        }
        ExecElementToSignal execToSignal = null;
        HashSet<BpelExecution> waitingExec = new HashSet<BpelExecution>(instance.getWaitingExecutions());
        if (waitingExec != null) {
            for (BpelExecution child : waitingExec) {
                Activity activity = child.getNode().getBehaviour();
                if (!(activity instanceof InboundMessageElement)) continue;
                for (ReceivingElement receivingElement : ((InboundMessageElement)((Object)activity)).getReceivingElements()) {
                    PendingMessage pendingMessage;
                    OperationKey opKey = receivingElement.getOperationKey();
                    Receiver receiver = bpelProcess.getReceiver(opKey);
                    receiver.addWaitingExecution(child);
                    if (execToSignal != null || (pendingMessage = receiver.getMessageFromStoredMessage(child, receivingElement)) == null) continue;
                    receiver.removePendingMessage(pendingMessage);
                    execToSignal = new ExecElementToSignal(child, receivingElement, pendingMessage);
                    if (receiver.removeWaitingExecution(child)) continue;
                    throw new OrchestraRuntimeException("No such waiting execution : " + child);
                }
            }
        }
        return execToSignal;
    }

    ExecElementToSignal associatePendingMessage(PendingMessage pendingMessage, BpelProcess bpelProcess) {
        ExecElementToSignal execElementToSignal = null;
        execElementToSignal = this.getWaitingExecution(pendingMessage);
        if (execElementToSignal != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Matching execution found for incoming msg: " + execElementToSignal.getBpelExecution());
            }
            return execElementToSignal;
        }
        InboundMessageElement startActivity = bpelProcess.getStartElement(this.operationKey);
        if (startActivity != null) {
            BpelExecution bpelExecution;
            ExecElementToSignal receiveExecution;
            ReceivingElement startElement = null;
            for (ReceivingElement receivingElement : startActivity.getReceivingElements()) {
                if (!receivingElement.getOperationKey().equals(this.operationKey)) continue;
                startElement = receivingElement;
            }
            if (startElement == null) {
                throw new IllegalStateException("No start element found");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("found start node " + startElement + " for incoming msg");
            }
            if ((receiveExecution = Receiver.getWaitingExecution(bpelExecution = this.createNewInstance(pendingMessage, bpelProcess, startActivity, startElement), startElement, pendingMessage)) == null) {
                throw new OrchestraRuntimeException("No waiting execution found !, process = " + bpelExecution.getProcessDefinition().getQName());
            }
            return receiveExecution;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("no matching execution found for pending msg.");
        }
        return null;
    }

    private BpelExecution createNewInstance(PendingMessage pendingMessage, BpelProcess bpelProcess, InboundMessageElement startActivity, ReceivingElement startElement) {
        BpelExecution bpelExecution = (BpelExecution)bpelProcess.createProcessInstance();
        HashMap<String, Object> additionnalVariables = new HashMap<String, Object>();
        Process processActivity = (Process)bpelProcess.getInitial().getBehaviour();
        if (startElement.getVariable() != null) {
            Variable var = ((AbstractBpelActivity)((Object)startActivity)).getEnclosingScope().findVariable(startElement.getVariable());
            Variable var1 = processActivity.getVariable(startElement.getVariable());
            if (var1.equals(var)) {
                additionnalVariables.put(startElement.getVariable(), pendingMessage.getMessage().duplicate());
            }
        } else {
            for (Copy copy : startElement.getInCopies()) {
                Variable var = ((AbstractBpelActivity)((Object)startActivity)).getEnclosingScope().findVariable(copy.getTo().getVariable());
                Variable var1 = processActivity.getVariable(copy.getTo().getVariable());
                if (!var1.equals(var)) continue;
                additionnalVariables.put(copy.getTo().getVariable(), pendingMessage.getMessage().getPartValue(copy.getFrom().getPart()));
            }
        }
        if (!additionnalVariables.isEmpty()) {
            bpelExecution.createVariable("additionnalScopeVariables", additionnalVariables);
        }
        bpelExecution.begin();
        return bpelExecution;
    }

    public static void addReplier(BpelExecution bpelExecution, ReceivingElement receivingElement, MessageCarrier messageCarrier) {
        if (messageCarrier != null) {
            String messageExchange = receivingElement.getMessageExchange();
            ReplierKey replierKey = new ReplierKey(receivingElement.getOperationKey(), messageExchange, bpelExecution.getCurrentScopeRuntime());
            Replier replier = Receiver.createReplier(replierKey);
            MessageCarrierRepository.addMessageCarrier(replierKey, messageCarrier);
            bpelExecution.addReplier(replier);
        }
    }

    private ExecElementToSignal getWaitingExecution(PendingMessage pendingMessage) {
        MessageVariable incomingMessage = pendingMessage.getMessage();
        if (this.getWaitingExecutions().isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No waiting executions for Receiver: " + this.getOperationKey());
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Waiting executions for Receiver " + this.getOperationKey() + ": " + this.getWaitingExecutions());
        }
        for (BpelExecution bpelExecution : this.getWaitingExecutions()) {
            if (bpelExecution.isInstanceSuspended()) continue;
            InboundMessageElement inboundMessageElement = (InboundMessageElement)((Object)bpelExecution.getNode().getBehaviour());
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Receiving Element: " + receivingElement.getOperationKey() + " / OperationKey=" + this.operationKey);
                }
                if (!receivingElement.getOperationKey().equals(this.operationKey) || !Receiver.csMatch(incomingMessage, receivingElement, bpelExecution)) continue;
                ExecElementToSignal res = new ExecElementToSignal(bpelExecution, receivingElement, pendingMessage);
                if (!this.removeWaitingExecution(bpelExecution)) {
                    throw new OrchestraRuntimeException("No such waiting execution : " + bpelExecution);
                }
                return res;
            }
        }
        return null;
    }

    private static ExecElementToSignal getWaitingExecution(BpelExecution parent, ReceivingElement startElement, PendingMessage pendingMessage) {
        if (parent == null) {
            return null;
        }
        BpelExecution instance = parent.getProcessInstance();
        BpelProcess bpelProcess = instance.getProcessDefinition();
        HashSet<BpelExecution> waitingExec = new HashSet<BpelExecution>(instance.getWaitingExecutions());
        if (log.isLoggable(Level.FINE)) {
            log.fine(Receiver.class + ".addWaitingExecutions, execution = " + parent + " waiting=" + waitingExec);
        }
        ExecElementToSignal res = null;
        if (waitingExec != null) {
            for (BpelExecution child : waitingExec) {
                Activity activity = child.getNode().getBehaviour();
                if (!(activity instanceof InboundMessageElement)) continue;
                InboundMessageElement inboundMessageElement = (InboundMessageElement)((Object)activity);
                for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                    OperationKey opKey = receivingElement.getOperationKey();
                    Receiver receiver = bpelProcess.getReceiver(opKey);
                    receiver.addWaitingExecution(child);
                    if (res != null || !receivingElement.equals(startElement)) continue;
                    res = new ExecElementToSignal(child, startElement, pendingMessage, true);
                    if (!receiver.removeWaitingExecution(child)) {
                        throw new OrchestraRuntimeException("No such waiting execution : " + child);
                    }
                    if (bpelProcess.getCommonCorrelationSets() == null) continue;
                    for (CorrelationSet cs : bpelProcess.getCommonCorrelationSets()) {
                        ReceivingElementUtil.initiateCs(startElement, child, cs, pendingMessage.getMessage());
                    }
                }
            }
        }
        return res;
    }

    PendingMessage storeIncomingMessage(MessageVariable message, MessageCarrier messageCarrier) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Incoming msg: " + message);
        }
        PendingMessage pendingMessage = null;
        if (messageCarrier != null) {
            MessageCarrierRepository.addPendingMessageCarrier(messageCarrier);
            pendingMessage = new PendingMessage(message, messageCarrier.getUuid(), this);
        } else {
            pendingMessage = new PendingMessage(message, null, this);
        }
        return pendingMessage;
    }

    protected void storePendingMessage(PendingMessage pendingMessage) {
        this.storedMessages.add(pendingMessage);
    }

    static boolean csMatch(MessageVariable messageToAnalyse, ReceivingElement receivingElement, BpelExecution bpelExecution) {
        if (receivingElement.getCorrelations() == null) {
            return true;
        }
        for (Correlation correlation : receivingElement.getCorrelations()) {
            if (correlation.correlationOK(messageToAnalyse, receivingElement, bpelExecution)) continue;
            return false;
        }
        return true;
    }

    private PendingMessage getMessageFromStoredMessage(BpelExecution bpelExecution, ReceivingElement receivingElement) {
        if (this.storedMessages == null) {
            return null;
        }
        for (PendingMessage pendingMessage : this.storedMessages) {
            MessageVariable message = pendingMessage.getMessage();
            if (!Receiver.csMatch(message, receivingElement, bpelExecution)) continue;
            return pendingMessage;
        }
        return null;
    }

    protected void addWaitingExecution(BpelExecution bpelExecution) {
        this.getWaitingExecutions().add(bpelExecution);
        if (log.isLoggable(Level.FINE)) {
            log.fine("addWaitingExecution, operationKey=" + this.operationKey + ", execution = " + bpelExecution);
        }
    }

    public boolean removeWaitingExecution(BpelExecution bpelExecution) {
        boolean b1 = bpelExecution.getProcessInstance().getWaitingExecutions().remove(bpelExecution);
        boolean b2 = this.getWaitingExecutions().remove(bpelExecution);
        return b1 && b2;
    }

    public boolean removePendingMessage(PendingMessage pendingMessage) {
        return this.storedMessages.remove(pendingMessage);
    }

    public OperationKey getOperationKey() {
        return this.operationKey;
    }

    private static Replier createReplier(ReplierKey replierKey) {
        return new ReplierImpl(replierKey);
    }

    protected Set<BpelExecution> getWaitingExecutions() {
        return this.waitingExecutions;
    }
}

