/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.var.MessageVariable;

public final class ReceivingElementUtil {
    private static final Logger LOG = Logger.getLogger(ReceivingElementUtil.class.getName());

    private ReceivingElementUtil() {
    }

    public static void receive(ReceivingElement receivingElement, MessageVariable message, MessageCarrier messageCarrier, BpelExecution execution) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Receiving message : " + message);
        }
        ReceivingElementUtil.initiateCs(receivingElement, execution, message);
        if (receivingElement.getVariable() != null) {
            VariableRuntime variableRuntime = execution.getVariableByName(receivingElement.getVariable());
            variableRuntime.setValue(message);
            variableRuntime.updated(execution.getActivityInstanceUUID());
        } else if (receivingElement.getInCopies() != null && !receivingElement.getInCopies().isEmpty()) {
            ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
            VariableRuntime anonymousInboundMessageVariableRuntime = scopeRuntime.createVariable(execution, receivingElement.getAnonymousInboundMessageVariable());
            anonymousInboundMessageVariableRuntime.setValue(message);
            for (Copy copy : receivingElement.getInCopies()) {
                copy.execute(execution);
            }
            scopeRuntime.removeVariable(execution, receivingElement.getAnonymousInboundMessageVariable());
        }
        Receiver.addReplier(execution, receivingElement, messageCarrier);
    }

    private static void initiateCs(ReceivingElement receivingElement, BpelExecution bpelExecution, MessageVariable incomingMessage) {
        if (receivingElement.getCorrelations() != null) {
            for (Correlation correlation : receivingElement.getCorrelations()) {
                CorrelationSetRuntime correlationSetRuntime = bpelExecution.getCorrelationSetByName(correlation.getCorrelationSet().getName());
                QName messageType = bpelExecution.getPortType(receivingElement.getPortTypeQName()).getOperation(receivingElement.getOperation(), null, null).getInput().getMessage().getQName();
                correlationSetRuntime.checkCSValues(bpelExecution, incomingMessage, messageType, correlation.getInitiate());
            }
        }
    }

    public static void initiateCs(ReceivingElement receivingElement, BpelExecution bpelExecution, CorrelationSet cs, MessageVariable incomingMessage) {
        if (receivingElement.getCorrelations() != null) {
            for (Correlation correlation : receivingElement.getCorrelations()) {
                if (!correlation.getCorrelationSet().equals(cs)) continue;
                CorrelationSetRuntime correlationSetRuntime = bpelExecution.getCorrelationSetByName(correlation.getCorrelationSet().getName());
                QName messageType = bpelExecution.getPortType(receivingElement.getPortTypeQName()).getOperation(receivingElement.getOperation(), null, null).getInput().getMessage().getQName();
                correlationSetRuntime.checkCSValues(bpelExecution, incomingMessage, messageType, correlation.getInitiate());
            }
        }
    }
}

