/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.var.literal;

import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class LiteralTest
extends BpelTestCase {
    public LiteralTest() {
        super("http://example.com/literal", "literal");
    }

    public void testLiteral() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        URL baseProduct = ((Object)((Object)this)).getClass().getResource("baseProduct.xml");
        this.assertExists(baseProduct);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("p", XmlUtil.getDocumentFromURL((URL)baseProduct).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)8, (int)callResult.getVariables().size());
                LiteralTest.this.assertHelloWorld(LiteralTest.this.getVariableValue(callResult, "st1"));
                LiteralTest.this.assertHelloWorld(LiteralTest.this.getVariableValue(callResult, "st2"));
                LiteralTest.this.assertmyElement(LiteralTest.this.getVariableValue(callResult, "element1"));
                LiteralTest.this.assertmyElement(LiteralTest.this.getVariableValue(callResult, "element2"));
                LiteralTest.this.assertmyElement(LiteralTest.this.getVariableValue(callResult, "element3"));
                LiteralTest.this.assertmyElement(LiteralTest.this.getVariableValue(callResult, "element4"));
                LiteralTest.this.assertmyElement(LiteralTest.this.getVariableValue(callResult, "element5"));
                LiteralTest.this.assertmyElement(LiteralTest.this.getVariableValue(callResult, "element6"));
                LiteralTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertHelloWorld(Object o) {
        this.assertString(o, "Hello World!!");
    }

    private void assertmyElement(Object o) {
        Element root = this.assertTopElementNS(o, "myElement");
        this.assertElementNSContentAndNoChild(root, "element1.1.1", "HelloWorld");
        this.assertElementNSContentAndNoChild(root, "element1.2", "123");
    }
}

