/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.correlation.initiateCorrelation;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.correlation.CorrelationTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class InitiateCorrelationTest
extends CorrelationTestCase {
    public InitiateCorrelationTest() {
        super("http://example.com/initiateCorrelation", "initiateCorrelation", BpelTestCase.EnvironmentType.NO_JOURNAL);
    }

    public void testInitiateCorrelation() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void testInitiateBadCorrelation() {
        this.deploy();
        this.launchNotCorrelated();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        String auctionId = "1";
        String shippingCosts1 = "1";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)"1"));
        parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)"1"));
        String shippingCosts2 = "2";
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)"2"));
        parts2.put("auctionId", BpelXmlUtil.createElementWithContent((String)"1"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        this.call(parts, portTypeQName, "submit");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        final BpelTestCase.CallResult callResult = this.call(parts2, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                Assert.assertEquals((int)1, (int)callResult.getVariables().size());
                String expected1 = "1-1-1-2";
                String expected2 = "1-2-1-1";
                Object result = InitiateCorrelationTest.this.getVariableValue(callResult, "result");
                if (!InitiateCorrelationTest.this.assertResult(result, "1-1-1-2") && !InitiateCorrelationTest.this.assertResult(result, "1-2-1-1")) {
                    Assert.assertTrue((String)("wrong correlation, expected was either 1-1-1-2, either 1-2-1-1and the result is " + result), (boolean)false);
                }
                Assert.assertTrue((boolean)true);
                InitiateCorrelationTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    public long launchNotCorrelated() {
        String auctionId1 = "1";
        String auctionId2 = "2";
        String shippingCosts1 = "1";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)"1"));
        parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)"1"));
        String shippingCosts2 = "2";
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)"2"));
        parts2.put("auctionId", BpelXmlUtil.createElementWithContent((String)"2"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult1 = this.call(parts, portTypeQName, "submit");
        final BpelTestCase.CallResult callResult2 = this.call(parts2, portTypeQName, "submit");
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNull(callResult1.getVariables());
                Assert.assertNull(callResult2.getVariables());
                Assert.assertFalse((boolean)callResult1.getProcessInstanceUUID().equals((Object)callResult2.getProcessInstanceUUID()));
                return null;
            }
        });
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                InitiateCorrelationTest.this.deleteInstances(2);
                return null;
            }
        });
        return endTime;
    }

    private boolean assertResult(Object o, String expected) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"result is not an instance of Element", (boolean)(o instanceof Element));
        Element result = (Element)o;
        boolean b = expected.equals(result.getTextContent());
        return b;
    }
}

