/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.runtime;

import java.util.Date;
import java.util.Set;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.facade.data.def.ActivityDefinitionData;
import org.ow2.orchestra.facade.data.def.ProcessDefinitionData;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.UnknownActivityFullInstanceImpl;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.test.TestInvoker;
import org.ow2.orchestra.test.TestValidatorImpl;
import org.ow2.orchestra.test.services.runtime.AbstractQuerierTest;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

public class JournalTest
extends AbstractQuerierTest {
    public static DefaultEnvXMLGenerator getJournalEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = new DefaultEnvXMLGenerator(null, DefaultEnvXMLGenerator.InstallationType.INTERNAL_JOURNAL_NO_HISTORY);
        envGenerator.setInvokerType(TestInvoker.class);
        envGenerator.setApplicationEntry("testValidator", TestValidatorImpl.class);
        return envGenerator;
    }

    public DefaultEnvXMLGenerator getEnvGenerator() {
        return JournalTest.getJournalEnvGenerator();
    }

    public void saveNewProcessInstance(ProcessFullInstance processInstance) {
        ProcessDefinitionData processDefinitionData = new ProcessDefinitionData(processInstance.getProcessDefinitionUUID(), "queriertest1", "http://www.example.org/QuerierTest/");
        ProcessInstanceData processInstanceData = new ProcessInstanceData(processDefinitionData, processInstance.getProcessInstanceUUID(), ActivityState.RUNNING);
        this.recordInstanceStarted(processInstanceData);
    }

    public void saveNewActivityInstance(ActivityFullInstance activityInstance) {
        ProcessDefinitionData processDefinitionData = new ProcessDefinitionData(activityInstance.getProcessDefinitionUUID(), "queriertest1", "http://www.example.org/QuerierTest/");
        ProcessInstanceData processInstanceData = new ProcessInstanceData(processDefinitionData, activityInstance.getProcessInstanceUUID(), ActivityState.RUNNING);
        ActivityDefinitionUUID uuid = new ActivityDefinitionUUID(activityInstance.getProcessDefinitionUUID(), 3, ActivityType.UNKNOWN_ACTIVITY, "Name_Test");
        ActivityDefinitionUUID encloserUUID = new ActivityDefinitionUUID(activityInstance.getProcessDefinitionUUID(), 4, ActivityType.UNKNOWN_ACTIVITY, "Name_Encloser_Test");
        ActivityDefinitionData activityDefinitionData = new ActivityDefinitionData(processDefinitionData, uuid, encloserUUID, ActivityType.SEQUENCE, "name");
        ActivityInstanceData activityInstanceData = new ActivityInstanceData(activityDefinitionData, processInstanceData, activityInstance.getUUID(), (ActivityInstanceUUID)activityInstance.getProcessInstanceUUID());
        this.recordInstanceStarted(activityInstanceData);
    }

    public void saveNewActivityInstanceBadEncloser(ActivityInstance activityInstance) {
        ProcessDefinitionData processDefinitionData = new ProcessDefinitionData(activityInstance.getProcessDefinitionUUID(), "queriertest1", "http://www.example.org/QuerierTest/");
        ProcessInstanceData processInstanceData = new ProcessInstanceData(processDefinitionData, activityInstance.getProcessInstanceUUID(), ActivityState.RUNNING);
        ActivityDefinitionUUID uuid = new ActivityDefinitionUUID(activityInstance.getProcessDefinitionUUID(), 5, ActivityType.UNKNOWN_ACTIVITY, "Name_Test");
        ActivityDefinitionUUID encloserUUID = new ActivityDefinitionUUID(activityInstance.getProcessDefinitionUUID(), 6, ActivityType.UNKNOWN_ACTIVITY, "Name_Encloser_Test");
        ActivityDefinitionData activityDefinitionData = new ActivityDefinitionData(processDefinitionData, uuid, encloserUUID, ActivityType.SEQUENCE, "name");
        ActivityInstanceData activityInstanceData = new ActivityInstanceData(activityDefinitionData, processInstanceData, activityInstance.getUUID(), activityInstance.getUUID());
        this.recordInstanceStarted(activityInstanceData);
    }

    public void recordInstanceStarted(ActivityInstanceData aID) {
        final ActivityInstanceData activityInstanceData = aID;
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordActivityStarted(activityInstanceData);
                return null;
            }
        });
    }

    public void recordInstanceStarted(ProcessInstanceData pID) {
        final ProcessInstanceData processInstanceData = pID;
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordInstanceStarted(processInstanceData);
                return null;
            }
        });
    }

    public void recordInstanceUpdated(ProcessInstanceData pID) {
        final ProcessInstanceData processInstanceData = pID;
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Recorder recorder = EnvTool.getRecorder();
                recorder.recordInstanceUpdated(processInstanceData);
                return null;
            }
        });
    }

    public void removeProcessInstance(final ProcessFullInstance processInstance) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                EnvTool.getQuerier().removeProcessInstance(processInstance.getUUID());
                return null;
            }
        });
    }

    public Querier getQuerier() {
        return EnvTool.getJournalQueriers();
    }

    public void testBadEncloser() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1", (String)Misc.getHumanReadableId((String)""));
        ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$"));
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID, new Date());
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                JournalTest.this.setNbProcessInstances(processFullInstanceSet.size());
                return null;
            }
        });
        this.saveNewProcessInstance((ProcessFullInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(JournalTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                return null;
            }
        });
        ActivityInstanceUUID activityInstanceUUID = IdFactory.getNewActivityInstanceUUID((ProcessInstanceUUID)instanceUUID);
        ActivityDefinitionUUID activityDefinitionUUID = IdFactory.getNewActivityDefinitionUUID((ProcessDefinitionUUID)processUUID, (int)1);
        UnknownActivityFullInstanceImpl newActivityFullInstance = new UnknownActivityFullInstanceImpl(activityInstanceUUID, activityDefinitionUUID, processUUID, instanceUUID, new Date());
        try {
            this.saveNewActivityInstanceBadEncloser((ActivityInstance)newActivityFullInstance);
            Assert.fail((String)"Expected Exception");
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        this.removeProcessInstance((ProcessFullInstance)newProcessFullInstance);
    }

    public void testSuspendProcessInstance() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1", (String)Misc.getHumanReadableId((String)""));
        ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$"));
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID, new Date());
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                JournalTest.this.setNbProcessInstances(processFullInstanceSet.size());
                return null;
            }
        });
        ProcessDefinitionData processDefinitionData = new ProcessDefinitionData(newProcessFullInstance.getProcessDefinitionUUID(), "queriertest1", "http://www.example.org/QuerierTest/");
        ProcessInstanceData processInstanceData = new ProcessInstanceData(processDefinitionData, newProcessFullInstance.getProcessInstanceUUID(), ActivityState.RUNNING);
        this.recordInstanceStarted(processInstanceData);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(JournalTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                return null;
            }
        });
        processInstanceData = new ProcessInstanceData(processDefinitionData, newProcessFullInstance.getProcessInstanceUUID(), ActivityState.SUSPENDED);
        this.recordInstanceUpdated(processInstanceData);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = EnvTool.getQuerier().findProcessInstances(ActivityState.SUSPENDED);
                Assert.assertEquals((int)1, (int)processFullInstanceSet.size());
                return null;
            }
        });
        this.removeProcessInstance((ProcessFullInstance)newProcessFullInstance);
    }
}

