/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.itf.Invoker;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestInvoker
implements Invoker {
    public MessageVariable invoke(OperationKey operationKey, Element partnerEndPointReference, MessageVariable requestMessage, Set<Definition> wsdlDefinitions, Properties orchestraProperties) {
        QName portTypeQName = operationKey.getPortTypeQName();
        Object instance = WSRepository.getWS(portTypeQName);
        MessageVariable msg = null;
        if (instance == null) {
            throw new OrchestraRuntimeException("No WS was found for portType : " + portTypeQName);
        }
        String operationName = operationKey.getOperationName();
        try {
            Method methodToCall = instance.getClass().getMethod(operationName, MessageVariable.class);
            Object invokeReturn = methodToCall.invoke(instance, requestMessage);
            if (invokeReturn != null) {
                if (!(invokeReturn instanceof MessageVariable)) {
                    throw new OrchestraRuntimeException("invokeReturn is not a message");
                }
                msg = ((MessageVariable)invokeReturn).duplicate();
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OrchestraRuntimeException) {
                throw (OrchestraRuntimeException)cause;
            }
            throw new OrchestraRuntimeException("problem invoking method : " + operationName + " : " + cause.getMessage(), cause);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("problem invoking method : " + operationName + " : " + e.getMessage(), (Throwable)e);
        }
        return msg;
    }
}

