/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.hello2;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Text;

public class Hello2Test
extends RemoteTestCase {
    public void testAxisHello2() {
        try {
            String processName = "hello2";
            String processNamespace = "http://orchestra.ow2.org/demos/hello2";
            QName processQName = new QName("http://orchestra.ow2.org/demos/hello2", "hello2");
            this.deploy("hello2");
            Hello2CallHelloTextPT helloTextCall = new Hello2CallHelloTextPT();
            Hello2CallHelloPT helloCall = new Hello2CallHelloPT();
            Thread t1 = new Thread(helloTextCall);
            Thread t2 = new Thread(helloCall);
            t1.start();
            t2.start();
            while (t1.isAlive() || t2.isAlive()) {
                t1.join(100L);
                t2.join(100L);
                if (helloCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(helloCall.getTrowable());
                }
                if (helloTextCall.getTrowable() == null) continue;
                if (helloTextCall.getTrowable() instanceof AssertionFailedError) {
                    throw helloTextCall.getTrowable();
                }
                throw new AssertionFailedError("Error in thread").initCause(helloTextCall.getTrowable());
            }
            this.undeploy(processQName);
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    class Hello2CallHelloTextPT
    implements Runnable {
        private Throwable uncaughtException;

        Hello2CallHelloTextPT() {
        }

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public void run() {
            try {
                String part = "<setHelloText>coucou_</setHelloText>";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/hello2/setHelloText", (String)"<setHelloText>coucou_</setHelloText>");
                String endpoint = Hello2Test.this.getDefaultEndpoint("helloTextPT");
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertEquals((String)result.toString(), (String)"setHelloText", (String)result.getElementName().getLocalName());
                    Assert.assertNotNull((Object)result.getFirstChild());
                    Assert.assertTrue((boolean)(result.getFirstChild() instanceof Text));
                    Text text = (Text)result.getFirstChild();
                    Assert.assertEquals((String)"coucou_", (String)text.getNodeValue());
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
        }
    }

    class Hello2CallHelloPT
    implements Runnable {
        private Throwable uncaughtException;

        Hello2CallHelloPT() {
        }

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public void run() {
            try {
                String part = "<name>toto</name>";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/hello2/sayHello", (String)"<name>toto</name>");
                String endpoint = Hello2Test.this.getDefaultEndpoint("helloPT");
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertNotNull((Object)result.getFirstChild());
                    Assert.assertTrue((boolean)(result.getFirstChild() instanceof Text));
                    Text text = (Text)result.getFirstChild();
                    Assert.assertEquals((String)"coucou_toto", (String)text.getData());
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
        }
    }
}

