create table BPEL_ACTIVITY_INST (DBID_ bigint not null, CLASS_ varchar(255) not null, dbversion bigint not null, ACT_INST_UUID_ varchar(3999), ACT_DEF_UUID_ varchar(3999), PROCESS_UUID_ varchar(3999), INST_UUID_ varchar(3999), STARTED_DATE_ timestamp, ENDED_DATE_ timestamp, ACTIVITY_STATE_ varchar(255), LAST_EXCEPTION_ bigint, CHILD_ACT_INST_ID_ bigint, OPERATION_ varchar(255), VARIABLE_ varchar(255), MESSAGE_EXCHANGE_ varchar(255), FH_INST_ bigint, TH_INST_ bigint, CH_INST_ bigint, START_VALUE_ integer, STOP_VALUE_ integer, COMPLETION_CONDITION_VALUE_ integer, CHILD_WAIT_ACT_ bigint, PARENT_ACT_INST_ID_ bigint, INDEX_ integer, PARENT_SCOPE_ID_ bigint, primary key (DBID_));
create table BPEL_BASE_ACTIVITY_DEF (DBID_ bigint not null, CLASS_ varchar(255) not null, dbversion bigint not null, ACT_DEF_UUID_ varchar(3999), PROCESS_DEF_UUID_ varchar(3999), NAME_ varchar(255), SUPPR_JN_FL_ smallint, TGT_JN_CDT_EXP_LG_ varchar(255), TGT_JN_CDT_BLN_LG_ varchar(255), CHILD_ACT_DEF_ID_ bigint, FAULT_NAME_QNAME_ varchar(255), FAULT_MESSAGE_TYPE_QNAME_ varchar(255), FAULT_ELEMENT_QNAME_ varchar(255), faultVariable varchar(255), EX_ON_STA_FAULT_ smallint, TERMINATION_HANDLER_ bigint, COMPENSATION_HANDLER_ bigint, NAMESPACE_ varchar(255), EXPR_LANG_ varchar(255), QUERY_LANG_ varchar(255), DPLY_DATE_ timestamp, UNDPLY_DATE timestamp, STATE_ varchar(255), TARGET_ varchar(255), IVK_PRTLNK_ varchar(255), IVK_IN_VAR_ varchar(255), IVK_OUT_VAR_ varchar(255), IVK_OPERATION_ varchar(255), IVK_PRT_PT_QNAME_ varchar(255), PT_QNAME_ varchar(255), FAULT_VARIABLE_ varchar(255), WHL_EXP_LANG_ varchar(255), WHL_BOOL_EXP_ varchar(255), RPU_EXP_LANG_ varchar(255), RPU_BOOL_EXP_ varchar(255), REC_CRT_INST_ smallint, REC_VAR_ varchar(255), REC_PARTN_LNK_ varchar(255), REC_OPERATION_ varchar(255), REC_MSG_EXCHNG_ varchar(255), REC_PRT_PT_QNAME_ varchar(255), REP_VAR_ varchar(255), REP_PARTN_LNK_ varchar(255), REP_OPERATION_ varchar(255), REP_MSG_EXCHNG_ varchar(255), REP_PRT_PT_QNAME_ varchar(255), REP_FLT_NM_QNAME_ varchar(255), ASSIGN_VLDT_ smallint, FOR_EXPR_LANG_ varchar(255), FOR_DUR_LANG_ varchar(255), UNTIL_EXPR_LANG_ varchar(255), UNTIL_DEAD_LANG_ varchar(255), IF_EXPR_LANG_ varchar(255), IF_EXPR_ varchar(255), ELSE_ACT_DEF_ID_ bigint, ELSE_ACT_UUID_ varchar(3999), PK_DF_CR_INST_ smallint, FRCH_C_N_EXPR_ varchar(255), FRCH_PARLLL_EXPR_ smallint, FRCH_FINL_EXPR_ varchar(255), FRCH_FINL_EXPR_LG_ varchar(255), FRCH_STRT_EXPR_ varchar(255), FRCH_STRT_EXPR_LG_ varchar(255), FRCH_CD_EXPR_ varchar(255), FRCH_CD_EXPR_LG_ varchar(255), FRCH_CD_SUCC_ smallint, PARENT_ACT_DEF_ID_ bigint, INDEX_ integer, SCOPE_ID_ bigint, primary key (DBID_));
create table BPEL_FAULT_ (DBID_ bigint not null, CLASS_ varchar(255) not null, FAULT_QNAME_ varchar(255), MSG_PARTS_ clob(2147483647), ELT_ clob(2147483647), primary key (DBID_));
create table BPEL_PROC_COMMON_CS_ (PROCESS_ID_ bigint not null, CS_ID_ bigint not null);
create table BPEL_REC (DBID_ bigint not null, TYPE_ varchar(255), ACT_INST_UUID_ varchar(3999), PROCESS_UUID_ varchar(3999), INST_UUID_ varchar(3999), DATA_ blob(2147483647), primary key (DBID_));
create table COPY_FULL_IMPL (DBID_ bigint not null, KEEP_SRC_ELT_NAME smallint, COPY_LST_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table CORR_DEF_ (DBID_ bigint not null, SETVALUE_ varchar(255), INITIATE_ varchar(255), ON_MSG_CORR_ID_ bigint, INDEX_ integer, ON_EVT_CORR_ID_ bigint, IVK_CR_DEF_ID_ bigint, REC_CR_DEF_ID_ bigint, RP_CR_DEF_ID_ bigint, primary key (DBID_));
create table CS_INIT_FULL_IMPL (DBID_ bigint not null, ACT_INST_UUID_ varchar(3999), DATE_ timestamp, NAME_ varchar(255), SCOPE_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table CS_PROPERTIES_ (CS_ID_ bigint not null, elt bigint not null, NAME_QNAME_ varchar(255) not null, primary key (CS_ID_, NAME_QNAME_));
create table ELSEIF_DEF_ (DBID_ bigint not null, ELSEIF_EXPR_ varchar(255), ELSEIF_EXPR_LANG_ varchar(255), ELSEIF_ACT_DEF_ID_ bigint, ELSEIF_ACT_UUID_ varchar(3999), IF_ELSEIF_LST_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table FRM_PRT_DEF_ (DBID_ bigint not null, FP_PART_ varchar(255), FP_TO_VAR_ varchar(255), ON_MSG_FRM_PRT_ID_ bigint, INDEX_ integer, ON_EVT_FRM_PRT_ID_ bigint, IVK_FR_PT_ID_ bigint, REC_FR_PT_ID_ bigint, primary key (DBID_));
create table FROM_TO_FULL (DBID_ bigint not null, CLASS_ varchar(255) not null, FT_VARIANT_ varchar(255), FT_EXP_LANG_ varchar(255), FT_VARIABLE_ varchar(255), FT_PART_ varchar(255), FT_PARTNER_LINK_ varchar(255), FT_ENDPOINT_REF_ varchar(255), FT_PROP_QNAME_ varchar(255), FT_EXPRESSION_ varchar(255), FT_QUERY_ varchar(255), FT_QUERY_LANG_ varchar(255), LITRL_VALUE_ varchar(3999), FROM_LST_ID_ bigint, INDEX_ integer, TO_LST_ID_ bigint, primary key (DBID_));
create table INST_COUNT_ (DBID_ bigint not null, PROCESS_UUID_ varchar(3999), primary key (DBID_));
create table NOVA_ACTIVITY (DBID_ bigint not null, CLASS_ varchar(255) not null, NAME_ varchar(255), UUID_ varchar(3999), CHILD_NODE_ bigint, FAULT_QNAME_ varchar(255), catchVariableDefinition bigint, SCOPE_NODE_ bigint, DEL_JOIN_FAIL_ smallint, EXEC_SRC_ASYNC smallint, SCOPE_ bigint, TARG_JOIN_COND_ bigint, PARTNER_LINK_ varchar(255), OPERATION_NAME_ varchar(255), IN_VAR_NAME_ varchar(255), OUT_VAR_NAME_ varchar(255), ONE_WAY_ smallint, PT_QNAME_ varchar(255), ANON_OUT_MESS_ bigint, ANON_IN_MESS_ bigint, MSG_EXCHANGE_ varchar(255), CREATE_INST_ smallint, OP_KEY_ varchar(3999), INPUT_TYPE_ varchar(255), VALIDATE_ smallint, ISOLATED_ smallint, EXIT_ON_FAULT_ smallint, NODE_ bigint, COND_ bigint, ACTIVITY_ bigint, ELSE_ACTIVITY_ bigint, COUNTER_NAME_ varchar(255), PARALLEL_ smallint, SUC_BRANCHES_ smallint, START_COUNT_ bigint, FINAL_COUNT_ bigint, COMPL_COND_ bigint, DURATION_ bigint, DEADLINE_ bigint, FAULT_VAR_ varchar(255), TARGET_ varchar(255), BPEL_INBOUND_PROCESS_ bigint, primary key (DBID_));
create table NOVA_BPEL_TESTS (ACTIVITY_ID_ bigint not null, event varchar(255), varNames varchar(255) for bit data, plnkNames varchar(255) for bit data, primary key (ACTIVITY_ID_));
create table NOVA_BPEL_VARIABLE (DBID_ bigint not null, NAME_ varchar(255), MSGTYPE_QNAME_ varchar(255), TYPE_QNAME_ varchar(255), ELT_QNAME_ varchar(255), VIRTUAL_COPY_ bigint, DEFAULT_VAL_ clob(2147483647), SCOPE_ID_ bigint, VAR_NAME_ varchar(255), primary key (DBID_));
create table NOVA_COPY_ELT (DBID_ bigint not null, KEEP_SRC_ELT_ smallint, IGNORE_MISS_DATA_ smallint, FROM_ bigint, TO_ bigint, INVOKE_IN_ID_ bigint, INDEX_ integer, INVOKE_OUT_ID_ bigint, REPLY_ID_ bigint, RECEIVE_IN_ID_ bigint, ASSIGN_ID_ bigint, ASSIGN_INDEX_ integer, ON_MSG_IN_ID_ bigint, ON_EVT_IN_ID_ bigint, primary key (DBID_));
create table NOVA_CORREL (DBID_ bigint not null, INITIATE_ varchar(255), CS_ bigint, INVOKE_REQ_ID_ bigint, INVOKE_RES_ID_ bigint, REPLY_ID_ bigint, RECEIVE_ID_ bigint, ON_MSG_ID_ bigint, ON_EVT_ID_ bigint, primary key (DBID_));
create table NOVA_CS (DBID_ bigint not null, NAME_ varchar(255), SCOPE_ID_ bigint, CS_NAME_ varchar(255), primary key (DBID_));
create table NOVA_CS_INST_PROP (CS_ID_ bigint not null, VALUE_ clob(2147483647), QNAME_ varchar(255) not null, primary key (CS_ID_, QNAME_));
create table NOVA_CS_RUNTIME (DBID_ bigint not null, ACT_INST_UUID_ varchar(3999), NAME_ varchar(255), INITIALIZED_ smallint, CS_DEF_ bigint, SCOPE_ID_ bigint, primary key (DBID_));
create table NOVA_CS_RUN_PROP (CS_ID_ bigint not null, VALUE_ clob(2147483647), QNAME_ varchar(255) not null, primary key (CS_ID_, QNAME_));
create table NOVA_ELSE_IF (IF_ID_ bigint not null, CONDITION_ bigint, ACTIVITY_ bigint, INDEX_ integer not null, primary key (IF_ID_, INDEX_));
create table NOVA_EXCEPTHNDLR (DBID_ bigint not null, CLASS_ varchar(255) not null, DBVERSION_ integer not null, EXCEPT_CLASS_ varchar(255), TRANSACT_ smallint, RETHROW_MASKED_ smallint, TRANSITIONNAME_ varchar(255), NODENAME_ varchar(255), PROCESS_ bigint, PROCESS_IDX_ integer, NODE_ bigint, NODE_IDX_ integer, primary key (DBID_));
create table NOVA_EXECUTION (DBID_ bigint not null, CLASS_ varchar(255) not null, DBVERSION_ integer not null, NODE_ bigint, PREV_NODE_ bigint, NAME_ varchar(255), KEY_ varchar(255), ID_ varchar(255), STATE_ varchar(255), PRIORITY_ integer, NEXTLOGIDX_ integer, PROCESS_ bigint, PARENT_ bigint, INSTANCE_ bigint, STARTED_DATE_ timestamp, PARENT_INST_START_TIME_ timestamp, INSTANCE_UUID_ varchar(3999), ACTIVITY_UUID_ varchar(3999), INSTANCE_STATE_ varchar(255), RESUME_STATE_ varchar(255), FLOW_RT_ID_ bigint, FOREACH_ID_ bigint, SCOPE_RT_ID_ bigint, WAITING_EXEC_ID_ bigint, primary key (DBID_));
create table NOVA_EXEC_INVOKE_DATA (DBID_ bigint not null, OP_KEY_ varchar(3999), MSG_PARTS_ clob(2147483647), ENDPOINT_ clob(2147483647), primary key (DBID_));
create table NOVA_FLOW_RUNTIME (DBID_ bigint not null, primary key (DBID_));
create table NOVA_FOREACH_RUNTIME (DBID_ bigint not null, COUNTER_START_ integer, COUNTER_FINAL_ integer, COUNTER_CURRENT_ integer, COMPL_VALUE_ integer, ONLY_SUCCESS_ smallint, BRANCH_COUNT_ integer, primary key (DBID_));
create table NOVA_FROM_PART (DBID_ bigint not null, PART_ varchar(255), TO_VAR_ varchar(255), primary key (DBID_));
create table NOVA_FROM_TO_ELT (DBID_ bigint not null, CLASS_ varchar(255) not null, VARIANT_ varchar(255), EXP_LANG_ varchar(255), VARIABLE_ varchar(255), PART_ varchar(255), PARTNER_LINK_ varchar(255), ENDPOINT_REF_ varchar(255), PROP_QNAME_ varchar(255), VAR_QUERY_ bigint, EXPRESSION_ bigint, LITERAL_VAL_ clob(2147483647), primary key (DBID_));
create table NOVA_JOB (DBID_ bigint not null, CLASS_ varchar(255) not null, DBVERSION_ integer not null, DUEDATE_ timestamp, ISSUSPENDED_ smallint, ISEXCLUSIVE_ smallint, LOCKOWNER_ varchar(255), LOCKEXPTIME_ timestamp, PRIORITY_ integer, RETRIES_ integer, DELAY_ bigint, EXCEPTION_ bigint, PROCESSINSTANCE_ bigint, EXECUTION_ bigint, SIGNAL_ varchar(255), NODE_ bigint, EVENT_ varchar(255), REPEAT_ varchar(255), INST_UUID_ varchar(3999), INVOKE_DATA_ bigint, SIG_INVOKE_DATA_ bigint, primary key (DBID_));
create table NOVA_JOB_EXCEPTION_ (DBID_ bigint not null, EXCEPTION_ long varchar, primary key (DBID_));
create table NOVA_LINK (DBID_ bigint not null, NAME_ varchar(255), SOURCE_ACTIVITY_ bigint, TARGET_ACTIVITY_ bigint, FLOW_ID_ bigint, primary key (DBID_));
create table NOVA_LINK_RUNTIME (DBID_ bigint not null, STATUS_ smallint, WAITING_EXEC_ bigint, NAME_ varchar(255), ACT_INST_UUID_ varchar(3999), FLOW_RUNTIME_ID_ bigint, primary key (DBID_));
create table NOVA_NAMESPACE (DBID_ bigint not null, URI_ varchar(255), PREFIX_ varchar(255), SNIPPET_ID_ bigint, primary key (DBID_));
create table NOVA_NODE (DBID_ bigint not null, DBVERSION_ integer not null, PROCESS_ bigint, NAME_ varchar(255), DESCR_ varchar(255), LOCAL_SCOPE_ smallint, EXEC_ASYNC_ smallint, SIGNAL_ASYNC_ smallint, PREV_NEEDED_ smallint, PARENT_ bigint, BEHAV_OBJ_ bigint, NODESPROCESS_ bigint, NODESPROCESS_IDX_ integer, PARENT_IDX_ integer, primary key (DBID_));
create table NOVA_ON_ALARM (DBID_ bigint not null, UUID_ varchar(255), DURATION_ bigint, DEADLINE_ bigint, REPEAT_ bigint, ACTIVITY_ bigint, ACTIVITY_ID_ bigint, PICK_ID_ bigint, primary key (DBID_));
create table NOVA_ON_EVT (DBID_ bigint not null, PARTNER_LINK_ varchar(255), IN_VAR_NAME_ varchar(255), MSG_EXCHANGE_ varchar(255), ANON_IN_MESS_ bigint, OP_KEY_ varchar(3999), ACTIVITY_ bigint, INBOUND_ELT_ bigint, INPUT_TYPE_ varchar(255), ACTIVITY_ID_ bigint, primary key (DBID_));
create table NOVA_ON_MSG (DBID_ bigint not null, PARTNER_LINK_ varchar(255), IN_VAR_NAME_ varchar(255), MSG_EXCHANGE_ varchar(255), ANON_IN_MESS_ bigint, OP_KEY_ varchar(3999), ACTIVITY_ bigint, INBOUND_ELT_ bigint, INPUT_TYPE_ varchar(255), PICK_ID_ bigint, primary key (DBID_));
create table NOVA_PENDING_MESS (DBID_ bigint not null, MSG_PARTS_ clob(2147483647), MSG_CARRIER_ID_ varchar(255), OP_KEY_ varchar(3999), primary key (DBID_));
create table NOVA_PLNK (DBID_ bigint not null, NAME_ varchar(255), MYROLEPT_QNAME_ varchar(255), PARTROLEPT_QNAME_ varchar(255), P_END_REF clob(2147483647), MY_END_REF clob(2147483647), SCOPE_ID_ bigint, PLNK_NAME_ varchar(255), primary key (DBID_));
create table NOVA_PLNKTYPE (DBID_ bigint not null, NAME_QNAME_ varchar(255), WSDLINFOS_ID_ bigint, PLNK_QNAME_ varchar(255), primary key (DBID_));
create table NOVA_PLNKT_ROLES (PLNKTYPE_ID_ bigint not null, PT_QNAME_ varchar(255), ROLE_NAME_ varchar(255) not null, primary key (PLNKTYPE_ID_, ROLE_NAME_));
create table NOVA_PL_RUNTIME (DBID_ bigint not null, ACT_INST_UUID_ varchar(3999), NAME_ varchar(255), PL_DEF_ bigint, P_END_REF clob(2147483647), MY_END_REF clob(2147483647), SCOPE_RUN_ID_ bigint, primary key (DBID_));
create table NOVA_PROCESS (DBID_ bigint not null, DBVERSION_ integer not null, NAME_ varchar(255), DESCR_ varchar(255), VERSION_ integer, DEPLOYED_ timestamp, INITIAL_ bigint, PROCESS_UUID_ varchar(3999), QUERY_LANG_ varchar(255), EXPR_LANG_ varchar(255), DEL_JOIN_FAIL_ smallint, EXIT_ON_FAULT_ smallint, TARGET_NS_ varchar(255), WSDL_INFOS_ bigint, instanceCreationLock bigint, primary key (DBID_));
create table NOVA_PROCESS_START (BPEL_PROCESS_ bigint not null, elt bigint not null, OP_KEY_ varchar(255) not null, primary key (BPEL_PROCESS_, OP_KEY_));
create table NOVA_PROC_COUNT (DBID_ bigint not null, DBVERSION_ bigint not null, COUNTER_ bigint, primary key (DBID_));
create table NOVA_PROPALIAS (DBID_ bigint not null, PROP_PART_ varchar(255), PROP_QNAME_ varchar(255), MSGTYPE_QNAME_ varchar(255), TYPE_QNAME_ varchar(255), ELT_QNAME_ varchar(255), QUERY_ bigint, WSDLINFOS_ID_ bigint, primary key (DBID_));
create table NOVA_REPLIER (DBID_ bigint not null, MSG_EXCHG_ varchar(255), OP_KEY_ varchar(3999), SCOPE_RUNTIME_ varchar(255), BPEL_INSTANCE_ bigint, primary key (DBID_));
create table NOVA_RESOURCES (PROCESS_ID_ bigint not null, CONTENT_ blob(2147483647), NAME_ varchar(255) not null, primary key (PROCESS_ID_, NAME_));
create table NOVA_SCOPE_MESSEXS (SCOPE_ID_ bigint not null, MESSEX_NAME_ varchar(255));
create table NOVA_SCOPE_RUNTIME (DBID_ bigint not null, UUID_ varchar(255), ACTIVITY_UUID_ varchar(3999), SCOPE_DEF_ bigint, SCOPE_STATE_ varchar(255) for bit data, LAST_EXCEPTION_ bigint, COMPENSATE_EXEC_ bigint, PARENT_ bigint, PARENT_INDEX_ integer, primary key (DBID_));
create table NOVA_SCOPE_VARINIT (SCOPE_ID_ bigint not null, VAR_NAME_ varchar(255));
create table NOVA_SIG_INVOKE_DATA (DBID_ bigint not null, MSG_PARTS_ clob(2147483647), FAULT_QNAME_ varchar(255), INVOKE_EXCEPTION_ clob(2147483647), primary key (DBID_));
create table NOVA_SNIPPET (DBID_ bigint generated by default as identity, CLASS_ varchar(255) not null, TXT_ varchar(255), LANG_ varchar(255), primary key (DBID_));
create table NOVA_SOURCE (DBID_ bigint not null, LINK_NAME_ varchar(255), LINK_ bigint, TRANS_COND_ bigint, ACTIVITY_ID_ bigint, primary key (DBID_));
create table NOVA_TARGET (DBID_ bigint not null, LINK_NAME_ varchar(255), LINK_ bigint, ACTIVITY_ID_ bigint, primary key (DBID_));
create table NOVA_TO_PART (DBID_ bigint not null, PART_ varchar(255), FROM_VAR_ varchar(255), primary key (DBID_));
create table NOVA_VAR_RUNTIME (DBID_ bigint not null, NAME_ varchar(255), VALUE_ clob(2147483647), VAR_RUNT_VAR_DEF_ bigint, SCOPE_ID_ bigint, primary key (DBID_));
create table NOVA_WAIT_EXEC (DBID_ bigint not null, EXEC_ID_ bigint, IN_ELT_ bigint, primary key (DBID_));
create table NOVA_WAIT_EXEC_CS_ (WAIT_ID_ bigint not null, CS_ID_ bigint not null, primary key (WAIT_ID_, CS_ID_));
create table NOVA_WSDLINFOS (DBID_ bigint not null, primary key (DBID_));
create table NOVA_WSDL_PROPERTY (DBID_ bigint not null, ELT_QNAME_ varchar(255), NAME_QNAME_ varchar(255), TYPE_QNAME_ varchar(255), WSDLINFOS_ID_ bigint, primary key (DBID_));
create table ON_ALRM_DEF_ (DBID_ bigint not null, ON_ALRM_ACT_DEF_ID_ bigint, ON_ALRM_ACT_UUID_ varchar(3999), FOR_EXPR_LANG_ varchar(255), FOR_DUR_LANG_ varchar(255), UNTIL_EXPR_LANG_ varchar(255), UNTIL_DEAD_LANG_ varchar(255), REPETE_EXPR_LANG_ varchar(255), REPEAT_DEAD_LANG_ varchar(255), SCOPE_ID_ bigint, INDEX_ integer, PK_DF_ON_AL_ID_ bigint, primary key (DBID_));
create table ON_EVT_DEF_ (DBID_ bigint not null, PICK_VAR_ varchar(255), PICK_PART_LNK_ varchar(255), PICK_OPTN_ varchar(255), PICK_MSG_EXCHG_ varchar(255), PICK_PT_TP_QNAME_ varchar(255), ON_EVT_ACT_DEF_ID_ bigint, ON_EVT_ACT_UUID_ varchar(3999), SCOPE_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table ON_MSG_DEF_ (DBID_ bigint not null, PICK_VAR_ varchar(255), PICK_PART_LNK_ varchar(255), PICK_OPTN_ varchar(255), PICK_MSG_EXCHG_ varchar(255), PICK_PT_TP_QNAME_ varchar(255), ON_MSG_ACT_DEF_ID_ bigint, ON_MSG_ACT_UUID_ varchar(3999), PK_DF_ON_MSG_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table PART_LNK_DEF_ (DBID_ bigint not null, NAME_ varchar(255), MY_ROLE_ varchar(255), PARTNER_ROLE_ varchar(255), INIT_PRTN_ROLE_ smallint, PRT_LNK_QNAME_ varchar(255), SCOPE_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table PLNK_UPDATE_FULL_IMPL (DBID_ bigint not null, ACT_INST_UUID_ varchar(3999), DATE_ timestamp, NAME_ varchar(255), P_END_REF clob(2147483647), PLNK_UPD_TYPE_ varchar(255), SCOPE_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table PROCESS_INST_STATE_UPDATE_ (DBID_ bigint not null, DATE_ timestamp, STATE_ varchar(255), PROCESS_INST_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table SCOPE_STATE_UPDATE_ (DBID_ bigint not null, ACT_INST_UUID_ varchar(3999), DATE_ timestamp, STATE_ varchar(255), SCOPE_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table SRC_FULL_IMPL (DBID_ bigint not null, LNK_NAME varchar(255), TR_CND_EXP_LG varchar(255), TR_CND_BOL_EXP varchar(255), SRC_LST_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table TGT_FULL_IMPL (DBID_ bigint not null, LNK_NAME varchar(255), TRGT_LST_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table TO_PRT_DEF_ (DBID_ bigint not null, TP_PART_ varchar(255), TP_FRM_VAR_ varchar(255), IVK_TO_PT_ID_ bigint, INDEX_ integer, RP_TO_PT_ID_ bigint, primary key (DBID_));
create table TR_COND_UPD_ (DBID_ bigint not null, STATUS_ smallint, NAME_ varchar(255), DATE_ timestamp, FLOW_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table VAR_DEF_ (DBID_ bigint not null, MSGTYPE_QNAME_ varchar(255), TYPE_QNAME_ varchar(255), ELT_QNAME_ varchar(255), NAME_ varchar(255), SCOPE_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table VAR_DEF_CS_ (DBID_ bigint not null, NAME_ varchar(255), SCOPE_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table VAR_UPDATE_FULL_IMPL (DBID_ bigint not null, ACT_INST_UUID_ varchar(3999), DATE_ timestamp, NAME_ varchar(255), IS_MESSAGE_ smallint, VALUE_ clob(2147483647), INDEX_ integer, SCOPE_ID_ bigint, primary key (DBID_));
create table WAITING_FULL_IMPL (DBID_ bigint not null, EXPECTED_STARTED_DATE_ timestamp, PICK_ID_ bigint, INDEX_ integer, primary key (DBID_));
create table linkList (FLOW_LINKS_ID_ bigint not null, FLOW_LINKS_ varchar(255), INDEX_ integer not null, primary key (FLOW_LINKS_ID_, INDEX_));
create table messageExchanges (SCOPE_ID_ bigint not null, elt varchar(255), INDEX_ integer not null, primary key (SCOPE_ID_, INDEX_));
create table messageParts (VAR_ID_ bigint not null, TYPE_QNAME_ varchar(255), ELT_QNAME_ varchar(255), NAME_ varchar(255) not null, primary key (VAR_ID_, NAME_));
create table properties (CORR_ST_DEF_ID_ bigint not null, PROP_QNAME_ varchar(255), INDEX_ integer not null, primary key (CORR_ST_DEF_ID_, INDEX_));
create table wsdlDefinitions (WSDLINFOS_ID_ bigint not null, WSDLINFOS_DEF_ blob(2147483647));
create index ACT_INST_EXCEPTION_IDX on BPEL_ACTIVITY_INST (LAST_EXCEPTION_);
create index ACT_INST_PARENT_IDK on BPEL_ACTIVITY_INST (PARENT_ACT_INST_ID_);
create index SCOPE_INST_EVT_IDX on BPEL_ACTIVITY_INST (PARENT_SCOPE_ID_);
create index ACT_INST_CHILD_IDX on BPEL_ACTIVITY_INST (CHILD_ACT_INST_ID_);
create index ACT_PROC_INST_UUID_IDX on BPEL_ACTIVITY_INST (INST_UUID_);
create index ACT_INST_FH_IDX on BPEL_ACTIVITY_INST (FH_INST_);
create index ACT_INST_CH_IDX on BPEL_ACTIVITY_INST (CH_INST_);
create index ACT_INST_WAIT_IDX on BPEL_ACTIVITY_INST (CHILD_WAIT_ACT_);
create index ACT_INST_UUID_IDX on BPEL_ACTIVITY_INST (ACT_INST_UUID_);
create index ACT_INST_TH_IDX on BPEL_ACTIVITY_INST (TH_INST_);
alter table BPEL_ACTIVITY_INST add constraint ACT_INST_PARENT_FK foreign key (PARENT_ACT_INST_ID_) references BPEL_ACTIVITY_INST;
alter table BPEL_ACTIVITY_INST add constraint ACT_INST_CH_FK foreign key (CH_INST_) references BPEL_ACTIVITY_INST;
alter table BPEL_ACTIVITY_INST add constraint ACT_INST_TH_FK foreign key (TH_INST_) references BPEL_ACTIVITY_INST;
alter table BPEL_ACTIVITY_INST add constraint ACT_INST_FH_FK foreign key (FH_INST_) references BPEL_ACTIVITY_INST;
alter table BPEL_ACTIVITY_INST add constraint ACT_INST_EXCEPTION_FK foreign key (LAST_EXCEPTION_) references BPEL_FAULT_;
alter table BPEL_ACTIVITY_INST add constraint ACT_INST_WAIT_FK foreign key (CHILD_WAIT_ACT_) references WAITING_FULL_IMPL;
alter table BPEL_ACTIVITY_INST add constraint ACT_INST_CHILD_FK foreign key (CHILD_ACT_INST_ID_) references BPEL_ACTIVITY_INST;
alter table BPEL_ACTIVITY_INST add constraint SCOPE_INST_EVT_FK foreign key (PARENT_SCOPE_ID_) references BPEL_ACTIVITY_INST;
create index SCOPE_DEF_FAULT_HANDLERS_IDX on BPEL_BASE_ACTIVITY_DEF (SCOPE_ID_);
alter table BPEL_BASE_ACTIVITY_DEF add constraint FK90444D19F1C5FAB0 foreign key (PARENT_ACT_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table BPEL_BASE_ACTIVITY_DEF add constraint FK90444D1982112BDD foreign key (CHILD_ACT_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table BPEL_BASE_ACTIVITY_DEF add constraint FK90444D19614874B5 foreign key (TERMINATION_HANDLER_) references BPEL_BASE_ACTIVITY_DEF;
alter table BPEL_BASE_ACTIVITY_DEF add constraint FK90444D19DE3B31AF foreign key (COMPENSATION_HANDLER_) references BPEL_BASE_ACTIVITY_DEF;
alter table BPEL_BASE_ACTIVITY_DEF add constraint FK90444D19D4D0807A foreign key (ELSE_ACT_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table BPEL_BASE_ACTIVITY_DEF add constraint SCOPE_DEF_FAULT_HANDLERS_FK foreign key (SCOPE_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table BPEL_PROC_COMMON_CS_ add constraint FK4FD7CF5A1E706273 foreign key (CS_ID_) references NOVA_CS;
alter table BPEL_PROC_COMMON_CS_ add constraint FK4FD7CF5AF1DBFC22 foreign key (PROCESS_ID_) references NOVA_PROCESS;
create index IDX_REC_PROC_INST on BPEL_REC (INST_UUID_);
create index IDX_REC_ACT_INST on BPEL_REC (ACT_INST_UUID_);
create index IDX_REC_PROC_DEF on BPEL_REC (PROCESS_UUID_);
create index COPY_LST_IDX on COPY_FULL_IMPL (COPY_LST_ID_);
alter table COPY_FULL_IMPL add constraint COPY_LST_FK foreign key (COPY_LST_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index RP_CR_DEF_LST_IDX on CORR_DEF_ (RP_CR_DEF_ID_);
create index IVK_CR_DEF_LST_IDX on CORR_DEF_ (IVK_CR_DEF_ID_);
create index ON_MSG_CORR_IDX on CORR_DEF_ (ON_MSG_CORR_ID_);
create index REC_CR_DEF_LST_IDX on CORR_DEF_ (REC_CR_DEF_ID_);
create index ON_EVT_CORR_IDX on CORR_DEF_ (ON_EVT_CORR_ID_);
alter table CORR_DEF_ add constraint REC_CR_DEF_LST_FK foreign key (REC_CR_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table CORR_DEF_ add constraint IVK_CR_DEF_LST_FK foreign key (IVK_CR_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table CORR_DEF_ add constraint RP_CR_DEF_LST_FK foreign key (RP_CR_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table CORR_DEF_ add constraint ON_EVT_CORR_FK foreign key (ON_EVT_CORR_ID_) references ON_EVT_DEF_;
alter table CORR_DEF_ add constraint ON_MSG_CORR_FK foreign key (ON_MSG_CORR_ID_) references ON_MSG_DEF_;
create index SCOPE_INST_CS_IDX on CS_INIT_FULL_IMPL (SCOPE_ID_);
alter table CS_INIT_FULL_IMPL add constraint SCOPE_INST_CS_FK foreign key (SCOPE_ID_) references BPEL_ACTIVITY_INST;
alter table CS_PROPERTIES_ add constraint FK1DAAEC3D1E706273 foreign key (CS_ID_) references NOVA_CS;
alter table CS_PROPERTIES_ add constraint FK1DAAEC3D2B0757BD foreign key (elt) references NOVA_WSDL_PROPERTY;
create index IF_ELSEIF_LST_IDX on ELSEIF_DEF_ (IF_ELSEIF_LST_ID_);
alter table ELSEIF_DEF_ add constraint IF_ELSEIF_LST_FK foreign key (IF_ELSEIF_LST_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table ELSEIF_DEF_ add constraint FK4BC7A7A366DBBFD7 foreign key (ELSEIF_ACT_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index IVK_FR_PT_LST_IDX on FRM_PRT_DEF_ (IVK_FR_PT_ID_);
create index ON_MSG_FRM_PRT_IDX on FRM_PRT_DEF_ (ON_MSG_FRM_PRT_ID_);
create index ON_EVT_FRM_PRT_IDX on FRM_PRT_DEF_ (ON_EVT_FRM_PRT_ID_);
create index REC_FR_PT_LST_IDX on FRM_PRT_DEF_ (REC_FR_PT_ID_);
alter table FRM_PRT_DEF_ add constraint REC_FR_PT_LST_FK foreign key (REC_FR_PT_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table FRM_PRT_DEF_ add constraint IVK_FR_PT_LST_FK foreign key (IVK_FR_PT_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table FRM_PRT_DEF_ add constraint ON_MSG_FRM_PRT_FK foreign key (ON_MSG_FRM_PRT_ID_) references ON_MSG_DEF_;
alter table FRM_PRT_DEF_ add constraint ON_EVT_FRM_PRT_FK foreign key (ON_EVT_FRM_PRT_ID_) references ON_EVT_DEF_;
create index TO_LST_IDX on FROM_TO_FULL (TO_LST_ID_);
create index FROM_LST_IDX on FROM_TO_FULL (FROM_LST_ID_);
alter table FROM_TO_FULL add constraint FROM_LST_FK foreign key (FROM_LST_ID_) references COPY_FULL_IMPL;
alter table FROM_TO_FULL add constraint TO_LST_FK foreign key (TO_LST_ID_) references COPY_FULL_IMPL;
create index COUNT_PROCESS_UUID_IDX on INST_COUNT_ (PROCESS_UUID_);
create index IF_COND_IDX on NOVA_ACTIVITY (COND_);
create index IF_ACT_IDX on NOVA_ACTIVITY (ACTIVITY_);
create index ACT_SCOPE_IDX on NOVA_ACTIVITY (SCOPE_);
create index WAIT_DLINE_IDX on NOVA_ACTIVITY (DEADLINE_);
create index ACT_TH_SCOPE_IDX on NOVA_ACTIVITY (SCOPE_NODE_);
create index FOR_FINAL_IDX on NOVA_ACTIVITY (FINAL_COUNT_);
create index FOR_START_IDX on NOVA_ACTIVITY (START_COUNT_);
create index ELSE_ACT_IDX on NOVA_ACTIVITY (ELSE_ACTIVITY_);
create index RECV_IN_MSG_IDX on NOVA_ACTIVITY (ANON_IN_MESS_);
create index ACT_CHILD_IDX on NOVA_ACTIVITY (CHILD_NODE_);
create index FOR_COND_IDX on NOVA_ACTIVITY (COMPL_COND_);
create index ACT_JOIN_COND_IDX on NOVA_ACTIVITY (TARG_JOIN_COND_);
create index REPLY_OUT_IDX on NOVA_ACTIVITY (ANON_OUT_MESS_);
create index WAIT_DUR_IDX on NOVA_ACTIVITY (DURATION_);
alter table NOVA_ACTIVITY add constraint REPLY_OUT_FK foreign key (ANON_OUT_MESS_) references NOVA_BPEL_VARIABLE;
alter table NOVA_ACTIVITY add constraint ELSE_ACT_FK foreign key (ELSE_ACTIVITY_) references NOVA_NODE;
alter table NOVA_ACTIVITY add constraint FOR_START_FK foreign key (START_COUNT_) references NOVA_SNIPPET;
alter table NOVA_ACTIVITY add constraint ACT_SCOPE_FK foreign key (SCOPE_) references NOVA_ACTIVITY;
alter table NOVA_ACTIVITY add constraint IF_ACT_FK foreign key (ACTIVITY_) references NOVA_NODE;
alter table NOVA_ACTIVITY add constraint FOR_COND_FK foreign key (COMPL_COND_) references NOVA_SNIPPET;
alter table NOVA_ACTIVITY add constraint ACT_CHILD_FK foreign key (CHILD_NODE_) references NOVA_NODE;
alter table NOVA_ACTIVITY add constraint WAIT_DLINE_FK foreign key (DEADLINE_) references NOVA_SNIPPET;
alter table NOVA_ACTIVITY add constraint ACT_TH_SCOPE_FK foreign key (SCOPE_NODE_) references NOVA_NODE;
alter table NOVA_ACTIVITY add constraint IF_COND_FK foreign key (COND_) references NOVA_SNIPPET;
alter table NOVA_ACTIVITY add constraint WAIT_DUR_FK foreign key (DURATION_) references NOVA_SNIPPET;
alter table NOVA_ACTIVITY add constraint FKE88EDDC2C76222AE foreign key (BPEL_INBOUND_PROCESS_) references NOVA_PROCESS;
alter table NOVA_ACTIVITY add constraint FKE88EDDC25BE3B464 foreign key (catchVariableDefinition) references NOVA_BPEL_VARIABLE;
alter table NOVA_ACTIVITY add constraint ACT_JOIN_COND_FK foreign key (TARG_JOIN_COND_) references NOVA_SNIPPET;
alter table NOVA_ACTIVITY add constraint FKE88EDDC2220B15BF foreign key (NODE_) references NOVA_NODE;
alter table NOVA_ACTIVITY add constraint FOR_FINAL_FK foreign key (FINAL_COUNT_) references NOVA_SNIPPET;
alter table NOVA_ACTIVITY add constraint RECV_IN_MSG_FK foreign key (ANON_IN_MESS_) references NOVA_BPEL_VARIABLE;
alter table NOVA_BPEL_TESTS add constraint FK14825CAA8DCEEF2D foreign key (ACTIVITY_ID_) references NOVA_ACTIVITY;
create index SCOPE_VAR_IDX on NOVA_BPEL_VARIABLE (SCOPE_ID_);
alter table NOVA_BPEL_VARIABLE add constraint FKA82FCF3381EEAE9 foreign key (VIRTUAL_COPY_) references NOVA_COPY_ELT;
alter table NOVA_BPEL_VARIABLE add constraint SCOPE_VAR_FK foreign key (SCOPE_ID_) references NOVA_ACTIVITY;
create index ASSIGN_COPY_IDX on NOVA_COPY_ELT (ASSIGN_ID_);
create index INVOKE_OUT_IDX on NOVA_COPY_ELT (INVOKE_OUT_ID_);
create index RECEIVE_IN_IDX on NOVA_COPY_ELT (RECEIVE_IN_ID_);
create index INVOKE_IN_IDX on NOVA_COPY_ELT (INVOKE_IN_ID_);
create index REPLY_MSG_EX_IDX on NOVA_COPY_ELT (REPLY_ID_);
alter table NOVA_COPY_ELT add constraint RECEIVE_IN_FK foreign key (RECEIVE_IN_ID_) references NOVA_ACTIVITY;
alter table NOVA_COPY_ELT add constraint FK2D2E1B765C53F732 foreign key (ON_MSG_IN_ID_) references NOVA_ON_MSG;
alter table NOVA_COPY_ELT add constraint REPLY_MSG_EX_FK foreign key (REPLY_ID_) references NOVA_ACTIVITY;
alter table NOVA_COPY_ELT add constraint FK2D2E1B76DE1523BD foreign key (FROM_) references NOVA_FROM_TO_ELT;
alter table NOVA_COPY_ELT add constraint ASSIGN_COPY_FK foreign key (ASSIGN_ID_) references NOVA_ACTIVITY;
alter table NOVA_COPY_ELT add constraint INVOKE_IN_FK foreign key (INVOKE_IN_ID_) references NOVA_ACTIVITY;
alter table NOVA_COPY_ELT add constraint INVOKE_OUT_FK foreign key (INVOKE_OUT_ID_) references NOVA_ACTIVITY;
alter table NOVA_COPY_ELT add constraint FK2D2E1B766464ED5D foreign key (TO_) references NOVA_FROM_TO_ELT;
alter table NOVA_COPY_ELT add constraint FK2D2E1B763A9909E3 foreign key (ON_EVT_IN_ID_) references NOVA_ON_EVT;
create index REPLY_COR_IDX on NOVA_CORREL (REPLY_ID_);
create index INV_RES_IDX on NOVA_CORREL (INVOKE_RES_ID_);
create index INV_REQ_IDX on NOVA_CORREL (INVOKE_REQ_ID_);
create index RECV_COR_IDX on NOVA_CORREL (RECEIVE_ID_);
alter table NOVA_CORREL add constraint FK7C680C66F00CA0D foreign key (CS_) references NOVA_CS;
alter table NOVA_CORREL add constraint REPLY_COR_FK foreign key (REPLY_ID_) references NOVA_ACTIVITY;
alter table NOVA_CORREL add constraint FK7C680C61BC92050 foreign key (ON_MSG_ID_) references NOVA_ON_MSG;
alter table NOVA_CORREL add constraint INV_RES_FK foreign key (INVOKE_RES_ID_) references NOVA_ACTIVITY;
alter table NOVA_CORREL add constraint RECV_COR_FK foreign key (RECEIVE_ID_) references NOVA_ACTIVITY;
alter table NOVA_CORREL add constraint FK7C680C6F7C10905 foreign key (ON_EVT_ID_) references NOVA_ON_EVT;
alter table NOVA_CORREL add constraint INV_REQ_FK foreign key (INVOKE_REQ_ID_) references NOVA_ACTIVITY;
create index SCOPE_CS_IDX on NOVA_CS (SCOPE_ID_);
alter table NOVA_CS add constraint SCOPE_CS_FK foreign key (SCOPE_ID_) references NOVA_ACTIVITY;
create index CS_INST_PROP_IDX on NOVA_CS_INST_PROP (CS_ID_);
alter table NOVA_CS_INST_PROP add constraint CS_INST_PROP_FK foreign key (CS_ID_) references CS_INIT_FULL_IMPL;
create index BPEL_SCOPE_CS_IDX on NOVA_CS_RUNTIME (SCOPE_ID_);
alter table NOVA_CS_RUNTIME add constraint FK7E7EB4DCADAF3787 foreign key (CS_DEF_) references NOVA_CS;
alter table NOVA_CS_RUNTIME add constraint BPEL_SCOPE_CS_FK foreign key (SCOPE_ID_) references NOVA_SCOPE_RUNTIME;
create index IDX_CS_RUN_PROP_CS_ on NOVA_CS_RUN_PROP (CS_ID_);
create index IDX_CS_RUN_PROP_QNAME_ on NOVA_CS_RUN_PROP (QNAME_);
alter table NOVA_CS_RUN_PROP add constraint FK_CS_RUN_PROP_CS_ foreign key (CS_ID_) references NOVA_CS_RUNTIME;
create index ELSIF_IDX on NOVA_ELSE_IF (IF_ID_);
create index ELSIF_ACT_IDX on NOVA_ELSE_IF (ACTIVITY_);
create index ELSIF_COND_IDX on NOVA_ELSE_IF (CONDITION_);
alter table NOVA_ELSE_IF add constraint ELSIF_FK foreign key (IF_ID_) references NOVA_ACTIVITY;
alter table NOVA_ELSE_IF add constraint ELSIF_ACT_FK foreign key (ACTIVITY_) references NOVA_NODE;
alter table NOVA_ELSE_IF add constraint ELSIF_COND_FK foreign key (CONDITION_) references NOVA_SNIPPET;
create index IDX_EXHDLR_PROCESS on NOVA_EXCEPTHNDLR (PROCESS_);
create index IDX_EXHDLR_NODE on NOVA_EXCEPTHNDLR (NODE_);
alter table NOVA_EXCEPTHNDLR add constraint FK_EXHDLR_PROCESS foreign key (PROCESS_) references NOVA_PROCESS;
alter table NOVA_EXCEPTHNDLR add constraint FK_EXHDLR_NODE foreign key (NODE_) references NOVA_NODE;
create index IDX_EXEC_PARENT on NOVA_EXECUTION (PARENT_);
create index IDX_EXEC_NODE on NOVA_EXECUTION (NODE_);
create index BPEL_EXEC_FOREACH_IDX on NOVA_EXECUTION (FOREACH_ID_);
create index IDX_EXEC_PROCESS on NOVA_EXECUTION (PROCESS_);
create index BPEL_EXEC_SCOPE_IDX on NOVA_EXECUTION (SCOPE_RT_ID_);
create index BPEL_EXEC_FLOW_IDX on NOVA_EXECUTION (FLOW_RT_ID_);
create index IDX_EXEC_INSTANCE on NOVA_EXECUTION (INSTANCE_);
create index IDX_EXEC_PREV_NODE on NOVA_EXECUTION (PREV_NODE_);
alter table NOVA_EXECUTION add constraint BPEL_EXEC_FOREACH_FK foreign key (FOREACH_ID_) references NOVA_FOREACH_RUNTIME;
alter table NOVA_EXECUTION add constraint BPEL_EXEC_FLOW_FK foreign key (FLOW_RT_ID_) references NOVA_FLOW_RUNTIME;
alter table NOVA_EXECUTION add constraint FK_EXEC_PROCESS foreign key (PROCESS_) references NOVA_PROCESS;
alter table NOVA_EXECUTION add constraint BPEL_EXEC_SCOPE_FK foreign key (SCOPE_RT_ID_) references NOVA_SCOPE_RUNTIME;
alter table NOVA_EXECUTION add constraint BPEL_EXEC_WAIT_FK foreign key (WAITING_EXEC_ID_) references NOVA_WAIT_EXEC;
alter table NOVA_EXECUTION add constraint FK_EXEC_INSTANCE foreign key (INSTANCE_) references NOVA_EXECUTION;
alter table NOVA_EXECUTION add constraint FK_EXEC_PREV_NODE foreign key (PREV_NODE_) references NOVA_NODE;
alter table NOVA_EXECUTION add constraint FK_EXEC_NODE foreign key (NODE_) references NOVA_NODE;
alter table NOVA_EXECUTION add constraint FK_EXEC_PARENT foreign key (PARENT_) references NOVA_EXECUTION;
alter table NOVA_FROM_TO_ELT add constraint FKEB0E8F6BC4132A10 foreign key (EXPRESSION_) references NOVA_SNIPPET;
alter table NOVA_FROM_TO_ELT add constraint FKEB0E8F6B3ADD900A foreign key (VAR_QUERY_) references NOVA_SNIPPET;
create index IDX_INVOKE_JOB_DATA_ on NOVA_JOB (INVOKE_DATA_);
create index IDX_JOB_DUE_DATE_ on NOVA_JOB (DUEDATE_);
create index IDX_SIG_JOB_DATA_ on NOVA_JOB (SIG_INVOKE_DATA_);
create index IDX_JOB_EXECUTION on NOVA_JOB (EXECUTION_);
create index IDX_JOB_EXCEPT_ on NOVA_JOB (EXCEPTION_);
create index IDX_JOB_PRINST on NOVA_JOB (PROCESSINSTANCE_);
create index IDX_JOB_PRIORITY_ on NOVA_JOB (PRIORITY_);
alter table NOVA_JOB add constraint FK_INVOKE_JOB_DATA_ foreign key (INVOKE_DATA_) references NOVA_EXEC_INVOKE_DATA;
alter table NOVA_JOB add constraint FK_JOB_PRINST foreign key (PROCESSINSTANCE_) references NOVA_EXECUTION;
alter table NOVA_JOB add constraint FK_JOB_EXCEPT_ foreign key (EXCEPTION_) references NOVA_JOB_EXCEPTION_;
alter table NOVA_JOB add constraint FK_JOB_NODE foreign key (NODE_) references NOVA_NODE;
alter table NOVA_JOB add constraint FK_SIG_JOB_DATA_ foreign key (SIG_INVOKE_DATA_) references NOVA_SIG_INVOKE_DATA;
alter table NOVA_JOB add constraint FK_JOB_EXECUTION foreign key (EXECUTION_) references NOVA_EXECUTION;
create index FLOW_LINK_IDX on NOVA_LINK (FLOW_ID_);
alter table NOVA_LINK add constraint FLOW_LINK_FK foreign key (FLOW_ID_) references NOVA_ACTIVITY;
alter table NOVA_LINK add constraint FK74F7F42DC74809C5 foreign key (SOURCE_ACTIVITY_) references NOVA_ACTIVITY;
alter table NOVA_LINK add constraint FK74F7F42DA26937BB foreign key (TARGET_ACTIVITY_) references NOVA_ACTIVITY;
create index BPEL_LINK_EXEC_IDX on NOVA_LINK_RUNTIME (WAITING_EXEC_);
create index BPEL_FLOW_LINK_IDX on NOVA_LINK_RUNTIME (FLOW_RUNTIME_ID_);
alter table NOVA_LINK_RUNTIME add constraint BPEL_LINK_EXEC_FK foreign key (WAITING_EXEC_) references NOVA_EXECUTION;
alter table NOVA_LINK_RUNTIME add constraint BPEL_FLOW_LINK_FK foreign key (FLOW_RUNTIME_ID_) references NOVA_FLOW_RUNTIME;
alter table NOVA_NAMESPACE add constraint FK67BDC0E8329E08E foreign key (SNIPPET_ID_) references NOVA_SNIPPET;
create index IDX_NODE_PROCESS on NOVA_NODE (PROCESS_);
create index IDX_NODE_BEHAV_OBJ on NOVA_NODE (BEHAV_OBJ_);
create index IDX_NODES_PROCESS on NOVA_NODE (NODESPROCESS_);
create index IDX_NODE_PARENT on NOVA_NODE (PARENT_);
alter table NOVA_NODE add constraint FK_NODES_PROCESS foreign key (NODESPROCESS_) references NOVA_PROCESS;
alter table NOVA_NODE add constraint FK_NODE_PROCESS foreign key (PROCESS_) references NOVA_PROCESS;
alter table NOVA_NODE add constraint FK_NODE_BEHAV_OBJ foreign key (BEHAV_OBJ_) references NOVA_ACTIVITY;
alter table NOVA_NODE add constraint FK_NODE_PARENT foreign key (PARENT_) references NOVA_NODE;
create index PICK_ON_ALRM_IDX on NOVA_ON_ALARM (PICK_ID_);
create index ACT_ON_ALARM_IDX on NOVA_ON_ALARM (ACTIVITY_ID_);
alter table NOVA_ON_ALARM add constraint FKEF13C684FAD5EF6D foreign key (REPEAT_) references NOVA_SNIPPET;
alter table NOVA_ON_ALARM add constraint ACT_ON_ALARM_FK foreign key (ACTIVITY_ID_) references NOVA_ACTIVITY;
alter table NOVA_ON_ALARM add constraint FKEF13C68458E1CE94 foreign key (DURATION_) references NOVA_SNIPPET;
alter table NOVA_ON_ALARM add constraint FKEF13C68427FB7252 foreign key (ACTIVITY_) references NOVA_NODE;
alter table NOVA_ON_ALARM add constraint PICK_ON_ALRM_FK foreign key (PICK_ID_) references NOVA_ACTIVITY;
alter table NOVA_ON_ALARM add constraint FKEF13C6845C32DA50 foreign key (DEADLINE_) references NOVA_SNIPPET;
create index ACT_ON_EVT_IDX on NOVA_ON_EVT (ACTIVITY_ID_);
alter table NOVA_ON_EVT add constraint ACT_ON_EVT_FK foreign key (ACTIVITY_ID_) references NOVA_ACTIVITY;
alter table NOVA_ON_EVT add constraint FK1C384AD69F1241FC foreign key (INBOUND_ELT_) references NOVA_ACTIVITY;
alter table NOVA_ON_EVT add constraint FK1C384AD627FB7252 foreign key (ACTIVITY_) references NOVA_NODE;
alter table NOVA_ON_EVT add constraint FK1C384AD6F7237F7A foreign key (ANON_IN_MESS_) references NOVA_BPEL_VARIABLE;
create index PICK_ON_MSG_IDX on NOVA_ON_MSG (PICK_ID_);
alter table NOVA_ON_MSG add constraint FK1C3868749F1241FC foreign key (INBOUND_ELT_) references NOVA_ACTIVITY;
alter table NOVA_ON_MSG add constraint FK1C38687427FB7252 foreign key (ACTIVITY_) references NOVA_NODE;
alter table NOVA_ON_MSG add constraint PICK_ON_MSG_FK foreign key (PICK_ID_) references NOVA_ACTIVITY;
alter table NOVA_ON_MSG add constraint FK1C386874F7237F7A foreign key (ANON_IN_MESS_) references NOVA_BPEL_VARIABLE;
create index PENDING_MSG_OP_KEY_IDX on NOVA_PENDING_MESS (OP_KEY_);
create index SCOPE_PL_IDX on NOVA_PLNK (SCOPE_ID_);
alter table NOVA_PLNK add constraint SCOPE_PL_FK foreign key (SCOPE_ID_) references NOVA_ACTIVITY;
alter table NOVA_PLNKTYPE add constraint FKD0B7022664EEA1B7 foreign key (WSDLINFOS_ID_) references NOVA_WSDLINFOS;
alter table NOVA_PLNKT_ROLES add constraint FK6B41F886A4BE5179 foreign key (PLNKTYPE_ID_) references NOVA_PLNKTYPE;
create index BPEL_SCOPE_PLK_IDX on NOVA_PL_RUNTIME (SCOPE_RUN_ID_);
alter table NOVA_PL_RUNTIME add constraint FKD85A6A68EA5B661 foreign key (PL_DEF_) references NOVA_PLNK;
alter table NOVA_PL_RUNTIME add constraint BPEL_SCOPE_PLK_FK foreign key (SCOPE_RUN_ID_) references NOVA_SCOPE_RUNTIME;
create index PROCESS_INST_CNT_IDX on NOVA_PROCESS (instanceCreationLock);
create index IDX_PROCDEF_INIT on NOVA_PROCESS (INITIAL_);
create index PROCESS_UUID_IDX on NOVA_PROCESS (PROCESS_UUID_);
alter table NOVA_PROCESS add constraint FK_PROCDEF_INITIAL foreign key (INITIAL_) references NOVA_NODE;
alter table NOVA_PROCESS add constraint FKA5A80D3CE142EB34 foreign key (instanceCreationLock) references INST_COUNT_;
alter table NOVA_PROCESS add constraint FKA5A80D3C9A504866 foreign key (WSDL_INFOS_) references NOVA_WSDLINFOS;
alter table NOVA_PROCESS_START add constraint FK85755F7FA088E666 foreign key (elt) references NOVA_ACTIVITY;
alter table NOVA_PROCESS_START add constraint FK85755F7F2857DEA8 foreign key (BPEL_PROCESS_) references NOVA_PROCESS;
alter table NOVA_PROPALIAS add constraint FKF1CD045A64EEA1B7 foreign key (WSDLINFOS_ID_) references NOVA_WSDLINFOS;
alter table NOVA_PROPALIAS add constraint FKF1CD045A2E48839 foreign key (QUERY_) references NOVA_SNIPPET;
create index BPEL_EXEC_REPLIERS_IDX on NOVA_REPLIER (BPEL_INSTANCE_);
alter table NOVA_REPLIER add constraint BPEL_EXEC_REPLIERS_FK foreign key (BPEL_INSTANCE_) references NOVA_EXECUTION;
alter table NOVA_RESOURCES add constraint FKA6E729B2F1DBFC22 foreign key (PROCESS_ID_) references NOVA_PROCESS;
create index SCOPE_MSG_EX_IDX on NOVA_SCOPE_MESSEXS (SCOPE_ID_);
alter table NOVA_SCOPE_MESSEXS add constraint SCOPE_MSG_EX_FK foreign key (SCOPE_ID_) references NOVA_ACTIVITY;
create index SR_EXCEPTION_IDX on NOVA_SCOPE_RUNTIME (LAST_EXCEPTION_);
create index BPEL_SR_PARENT_IDX on NOVA_SCOPE_RUNTIME (PARENT_);
create index SR_COMP_EXEC_IDX on NOVA_SCOPE_RUNTIME (COMPENSATE_EXEC_);
alter table NOVA_SCOPE_RUNTIME add constraint SR_EXCEPTION_FK foreign key (LAST_EXCEPTION_) references BPEL_FAULT_;
alter table NOVA_SCOPE_RUNTIME add constraint SR_COMP_EXEC_FK foreign key (COMPENSATE_EXEC_) references NOVA_EXECUTION;
alter table NOVA_SCOPE_RUNTIME add constraint FKDDA191DAA36EF1E6 foreign key (SCOPE_DEF_) references NOVA_ACTIVITY;
alter table NOVA_SCOPE_RUNTIME add constraint BPEL_SR_PARENT_FK foreign key (PARENT_) references NOVA_SCOPE_RUNTIME;
create index SCOPE_INIT_VAR_IDX on NOVA_SCOPE_VARINIT (SCOPE_ID_);
alter table NOVA_SCOPE_VARINIT add constraint SCOPE_INIT_VAR_FK foreign key (SCOPE_ID_) references NOVA_ACTIVITY;
create index ACT_SRC_LNK_IDX on NOVA_SOURCE (ACTIVITY_ID_);
alter table NOVA_SOURCE add constraint FK2315678EDE682DBD foreign key (LINK_) references NOVA_LINK;
alter table NOVA_SOURCE add constraint ACT_SRC_LNK_FK foreign key (ACTIVITY_ID_) references NOVA_ACTIVITY;
alter table NOVA_SOURCE add constraint FK2315678E35D1566F foreign key (TRANS_COND_) references NOVA_SNIPPET;
create index ACT_TGT_LNK_IDX on NOVA_TARGET (ACTIVITY_ID_);
alter table NOVA_TARGET add constraint FK24037104DE682DBD foreign key (LINK_) references NOVA_LINK;
alter table NOVA_TARGET add constraint ACT_TGT_LNK_FK foreign key (ACTIVITY_ID_) references NOVA_ACTIVITY;
create index BPEL_SCOPE_VAR_IDX on NOVA_VAR_RUNTIME (SCOPE_ID_);
alter table NOVA_VAR_RUNTIME add constraint FK5D0C7AED5A7F55CA foreign key (VAR_RUNT_VAR_DEF_) references NOVA_BPEL_VARIABLE;
alter table NOVA_VAR_RUNTIME add constraint BPEL_SCOPE_VAR_FK foreign key (SCOPE_ID_) references NOVA_SCOPE_RUNTIME;
create index WAIT_EXEC_EXEC_IDX on NOVA_WAIT_EXEC (EXEC_ID_);
alter table NOVA_WAIT_EXEC add constraint WAIT_EXEC_EXEC_FK foreign key (EXEC_ID_) references NOVA_EXECUTION;
alter table NOVA_WAIT_EXEC add constraint FKE4C9DCC83DCEFBD0 foreign key (IN_ELT_) references NOVA_ACTIVITY;
create index WAIT_EXEC_CS_IDX on NOVA_WAIT_EXEC_CS_ (CS_ID_);
create index IDX_WAIT_CS on NOVA_WAIT_EXEC_CS_ (WAIT_ID_);
alter table NOVA_WAIT_EXEC_CS_ add constraint FK_WAIT_CS foreign key (WAIT_ID_) references NOVA_WAIT_EXEC;
alter table NOVA_WAIT_EXEC_CS_ add constraint WAIT_EXEC_CS_FK foreign key (CS_ID_) references NOVA_CS_RUNTIME;
alter table NOVA_WSDL_PROPERTY add constraint FKCA68A07D64EEA1B7 foreign key (WSDLINFOS_ID_) references NOVA_WSDLINFOS;
create index SCOPE_DEF_ALARMS_IDX on ON_ALRM_DEF_ (SCOPE_ID_);
create index PK_DF_ON_AL_IDX on ON_ALRM_DEF_ (PK_DF_ON_AL_ID_);
alter table ON_ALRM_DEF_ add constraint PK_DF_ON_AL_FK foreign key (PK_DF_ON_AL_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table ON_ALRM_DEF_ add constraint FK5B79CBB3735C61C7 foreign key (ON_ALRM_ACT_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table ON_ALRM_DEF_ add constraint SCOPE_DEF_ALARMS_FK foreign key (SCOPE_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index SCOPE_DEF_EVTS_IDX on ON_EVT_DEF_ (SCOPE_ID_);
alter table ON_EVT_DEF_ add constraint FKC013947699EA93C4 foreign key (ON_EVT_ACT_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table ON_EVT_DEF_ add constraint SCOPE_DEF_EVTS_FK foreign key (SCOPE_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index PK_DF_ON_MSG_IDX on ON_MSG_DEF_ (PK_DF_ON_MSG_ID_);
alter table ON_MSG_DEF_ add constraint PK_DF_ON_MSG_FK foreign key (PK_DF_ON_MSG_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table ON_MSG_DEF_ add constraint FK4A3B4998A6853462 foreign key (ON_MSG_ACT_DEF_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index SCOPE_DEF_PL_IDX on PART_LNK_DEF_ (SCOPE_ID_);
alter table PART_LNK_DEF_ add constraint SCOPE_DEF_PL_FK foreign key (SCOPE_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index SCOPE_INST_PLNK_IDX on PLNK_UPDATE_FULL_IMPL (SCOPE_ID_);
alter table PLNK_UPDATE_FULL_IMPL add constraint SCOPE_INST_PLNK_FK foreign key (SCOPE_ID_) references BPEL_ACTIVITY_INST;
create index PROCESS_INST_STATE_IDX on PROCESS_INST_STATE_UPDATE_ (PROCESS_INST_ID_);
alter table PROCESS_INST_STATE_UPDATE_ add constraint PROCESS_INST_STATE_FK foreign key (PROCESS_INST_ID_) references BPEL_ACTIVITY_INST;
create index SCOPE_INST_STATE_IDX on SCOPE_STATE_UPDATE_ (SCOPE_ID_);
alter table SCOPE_STATE_UPDATE_ add constraint SCOPE_INST_STATE_FK foreign key (SCOPE_ID_) references BPEL_ACTIVITY_INST;
create index SRC_LST_IDX on SRC_FULL_IMPL (SRC_LST_ID_);
alter table SRC_FULL_IMPL add constraint SRC_LST_FK foreign key (SRC_LST_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index TRGT_LST_IDX on TGT_FULL_IMPL (TRGT_LST_ID_);
alter table TGT_FULL_IMPL add constraint TRGT_LST_FK foreign key (TRGT_LST_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index IVK_TO_PT_LST_IDX on TO_PRT_DEF_ (IVK_TO_PT_ID_);
create index RP_TO_PT_LST_IDX on TO_PRT_DEF_ (RP_TO_PT_ID_);
alter table TO_PRT_DEF_ add constraint RP_TO_PT_LST_FK foreign key (RP_TO_PT_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table TO_PRT_DEF_ add constraint IVK_TO_PT_LST_FK foreign key (IVK_TO_PT_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index FLOW_INST_TR_COND_IDX on TR_COND_UPD_ (FLOW_ID_);
alter table TR_COND_UPD_ add constraint FLOW_INST_TR_COND_FK foreign key (FLOW_ID_) references BPEL_ACTIVITY_INST;
create index SCOPE_DEF_VAR_IDX on VAR_DEF_ (SCOPE_ID_);
alter table VAR_DEF_ add constraint SCOPE_DEF_VAR_FK foreign key (SCOPE_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index SCOPE_DEF_CS_IDX on VAR_DEF_CS_ (SCOPE_ID_);
alter table VAR_DEF_CS_ add constraint SCOPE_DEF_CS_FK foreign key (SCOPE_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index SCOPE_INST_VAR_IDX on VAR_UPDATE_FULL_IMPL (SCOPE_ID_);
alter table VAR_UPDATE_FULL_IMPL add constraint SCOPE_INST_VAR_FK foreign key (SCOPE_ID_) references BPEL_ACTIVITY_INST;
create index PICK_WAIT_IDX on WAITING_FULL_IMPL (PICK_ID_);
alter table WAITING_FULL_IMPL add constraint PICK_WAIT_FK foreign key (PICK_ID_) references BPEL_ACTIVITY_INST;
create index FLOW_LINKS_IDX on linkList (FLOW_LINKS_ID_);
alter table linkList add constraint FLOW_LINKS_FK foreign key (FLOW_LINKS_ID_) references BPEL_BASE_ACTIVITY_DEF;
create index SCOPE_DEF_M_E_IDX on messageExchanges (SCOPE_ID_);
alter table messageExchanges add constraint SCOPE_DEF_M_E_FK foreign key (SCOPE_ID_) references BPEL_BASE_ACTIVITY_DEF;
alter table messageParts add constraint FKB27C1719CC8F6326 foreign key (VAR_ID_) references NOVA_BPEL_VARIABLE;
create index CORR_ST_DEF_IDX on properties (CORR_ST_DEF_ID_);
alter table properties add constraint CORR_ST_DEF_FK foreign key (CORR_ST_DEF_ID_) references VAR_DEF_CS_;
alter table wsdlDefinitions add constraint FKB6C7627C64EEA1B7 foreign key (WSDLINFOS_ID_) references NOVA_WSDLINFOS;
create table orchestra_sequences ( sequence_name varchar(255) not null ,  next_val bigint, primary key ( sequence_name ) ) ;
