/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.faultManagement.terminationHandler;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.FailWS;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.test.wsutils.WaitWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class TerminationHandlerWithFaultTest
extends BpelTestCase {
    public TerminationHandlerWithFaultTest() {
        super("http://orchestra.ow2.org/terminationHandler", "terminationHandler", BpelTestCase.EnvironmentType.JOURNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTerminationHandlerWithFault() throws Exception {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "WithFault.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        FailWS failWS = new FailWS();
        WSRepository.addWS(FailWS.PORTTYPE_QNAME, failWS);
        WaitWS waitWS = new WaitWS();
        WSRepository.addWS(WaitWS.PORTTYPE_QNAME, waitWS);
        try {
            String message = UUID.randomUUID().toString();
            String saveStateAfterFirstBranch = message + message;
            String expectedResponse = saveStateAfterFirstBranch + "terminationHandlerForWait" + "terminationHandlerForFail" + "outerTerminationHandler";
            String expectedResponse2 = saveStateAfterFirstBranch + "terminationHandlerForFail" + "terminationHandlerForWait" + "outerTerminationHandler";
            HashMap<String, Element> parts = new HashMap<String, Element>();
            parts.put("input", BpelXmlUtil.createElementWithContent((String)message));
            QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
            BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(1000L);
                if (saveWS.getBuffer().equals(saveStateAfterFirstBranch) && waitWS.getQueueLength() == 1) break;
            }
            Assert.assertEquals((String)saveStateAfterFirstBranch, (String)saveWS.getBuffer());
            Assert.assertEquals((int)1, (int)waitWS.getQueueLength());
            this.call(parts, portTypeQName, "resume");
            this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), Exception.class);
            this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
            this.deleteInstances(1);
            WSRepository.removeWS(FailWS.PORTTYPE_QNAME);
            WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
            WSRepository.removeWS(WaitWS.PORTTYPE_QNAME);
            this.undeploy();
            Assert.assertTrue((String)("expecting " + expectedResponse + " or " + expectedResponse2 + " but got " + saveWS.getBuffer()), (expectedResponse.equals(saveWS.getBuffer()) || expectedResponse2.equals(saveWS.getBuffer()) ? 1 : 0) != 0);
        }
        finally {
            waitWS.releaseAll();
        }
    }
}

