/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class OnEventSuspendTest
extends BpelTestCase {
    public OnEventSuspendTest() {
        super("http://example.com/onEvent", "onEvent");
    }

    public void testOnEventSuspendResume() throws InstanceNotFoundException {
        this.deploy(((Object)((Object)this)).getClass().getResource("onEvent.bpel"), ((Object)((Object)this)).getClass().getResource("onEvent.wsdl"));
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + message + message;
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        HashMap<String, Element> parts1 = new HashMap<String, Element>();
        parts1.put("id", BpelXmlUtil.createElementWithContent((String)"0"));
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("id", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult result = this.call(parts1, portTypeQName, "init");
        this.call(parts2, portTypeQName, "incrInt").getMessageCarrier().getMessage();
        Assert.assertEquals((String)message, (String)saveWS.getBuffer());
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Boolean>(){

            public Boolean execute(Environment environment) {
                BpelExecution instance = result.getInstance();
                Assert.assertFalse((boolean)instance.isInstanceSuspended());
                return instance.isInstanceSuspended();
            }
        });
        BpelTestCase.CallResult result2 = this.call(parts2, portTypeQName, "incrInt");
        try {
            result2.getMessageCarrier().getMessage(100L);
            Assert.fail((String)"No response expected");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        RemoteDeployerImpl remoteDeployerImpl = new RemoteDeployerImpl(this.getEnvironmentFactory());
        remoteDeployerImpl.suspend(result.getProcessInstanceUUID());
        commandService.execute((Command)new Command<Boolean>(){

            public Boolean execute(Environment environment) {
                BpelExecution instance = result.getInstance();
                Assert.assertTrue((boolean)instance.isInstanceSuspended());
                return instance.isInstanceSuspended();
            }
        });
        Assert.assertEquals((String)message, (String)saveWS.getBuffer());
        BpelTestCase.CallResult result3 = this.call(parts2, portTypeQName, "incrInt");
        try {
            result3.getMessageCarrier().getMessage(1000L);
            Assert.fail((String)"No response expected");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        Assert.assertEquals((String)message, (String)saveWS.getBuffer());
        remoteDeployerImpl.resume(result.getProcessInstanceUUID());
        result2.getMessageCarrier().getMessage();
        result3.getMessageCarrier().getMessage();
        this.call(parts1, portTypeQName, "validate");
        this.waitForInstanceEnd(result.getProcessInstanceUUID());
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                OnEventSuspendTest.this.deleteInstance(result);
                return null;
            }
        });
        this.undeploy();
    }
}

