/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.reply;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.PersonWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ReplyTest
extends BpelTestCase {
    public ReplyTest() {
        super("http://example.com/reply", "replyToParts");
    }

    public void testReplyToParts() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        URL personsList = ((Object)((Object)this)).getClass().getResource("personsList.xml");
        this.assertExists(personsList);
        URL person = ((Object)((Object)this)).getClass().getResource("person.xml");
        this.assertExists(person);
        final String personNS = PersonWS.PORTTYPE_QNAME.getNamespaceURI();
        Document personFileDoc = XmlUtil.getDocumentFromURL((URL)person);
        String firstName = "myFirstName";
        Element firstnameInputRootElement = XmlUtil.getDocumentWithOneElement((QName)new QName(personNS, "firstName"));
        Text textContent = firstnameInputRootElement.getOwnerDocument().createTextNode("myFirstName");
        firstnameInputRootElement.appendChild(textContent);
        String lastName = "myLastName";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("personsList", XmlUtil.getDocumentFromURL((URL)personsList).getDocumentElement());
        parts.put("person", personFileDoc.getDocumentElement());
        parts.put("firstName", firstnameInputRootElement);
        parts.put("lastName", BpelXmlUtil.createElementWithContent((String)"myLastName"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "replyToParts";
        WSRepository.addWS(PersonWS.PORTTYPE_QNAME, new PersonWS());
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "replyToParts");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                MessageVariable reply = result.getMessageCarrier().getMessage();
                String ns = PersonWS.PORTTYPE_QNAME.getNamespaceURI();
                Assert.assertNotNull((Object)reply);
                Element listElement = reply.getPartValue("personsList");
                Assert.assertEquals((String)ns, (String)listElement.getNamespaceURI());
                Assert.assertEquals((String)"list", (String)listElement.getLocalName());
                List children = XmlUtil.elements((Element)listElement);
                Assert.assertEquals((int)2, (int)children.size());
                ReplyTest.this.assertPerson((Node)children.get(0), "Paul", "Glood", "21", "Jules Vernes", "75000", "Paris");
                ReplyTest.this.assertPerson((Node)children.get(1), "Roger", "Badin", "58", "Jean-Jacques ROUSSEAU", "13000", "Marseille");
                Element personElement = reply.getPartValue("person");
                ReplyTest.this.assertPerson(personElement, "Arthur", "Monulo", "5", "5 Avenue", "4444", "Los Angeles");
                Element firstNameEl = reply.getPartValue("firstName");
                Assert.assertEquals((String)personNS, (String)firstNameEl.getNamespaceURI());
                Assert.assertEquals((String)"firstName", (String)firstNameEl.getLocalName());
                Assert.assertEquals((int)0, (int)XmlUtil.elements((Element)firstNameEl).size());
                List<Text> firstNameChildren = BpelTestCase.getTexts(firstNameEl);
                Assert.assertEquals((int)1, (int)firstNameChildren.size());
                Text text = firstNameChildren.get(0);
                Assert.assertEquals((String)"myFirstName", (String)text.getTextContent());
                Element lastNameElement = reply.getPartValue("lastName");
                Assert.assertNotNull((Object)lastNameElement);
                Assert.assertEquals((String)"myLastName", (String)lastNameElement.getTextContent());
                ReplyTest.this.deleteInstance(result);
                return null;
            }
        });
        WSRepository.removeWS(PersonWS.PORTTYPE_QNAME);
        this.undeploy();
    }

    private void assertElement(Node n, String ns, String localName, String textContent) {
        Assert.assertNotNull((Object)n);
        Assert.assertTrue((boolean)(n instanceof Element));
        Element el = (Element)n;
        Assert.assertEquals((String)ns, (String)el.getNamespaceURI());
        Assert.assertEquals((String)localName, (String)el.getLocalName());
        Assert.assertEquals((int)1, (int)el.getChildNodes().getLength());
        Node child = el.getChildNodes().item(0);
        Assert.assertTrue((boolean)(child instanceof Text));
        Text text = (Text)child;
        Assert.assertEquals((String)textContent, (String)text.getTextContent());
    }

    private void assertPerson(Node n, String firstName, String lastName, String age, String street, String zip, String city) {
        Assert.assertNotNull((Object)n);
        Assert.assertTrue((boolean)(n instanceof Element));
        Element el = (Element)n;
        String ns = PersonWS.PORTTYPE_QNAME.getNamespaceURI();
        Assert.assertEquals((String)ns, (String)el.getNamespaceURI());
        Assert.assertEquals((String)"person", (String)el.getLocalName());
        List children = XmlUtil.elements((Element)el);
        Assert.assertEquals((int)4, (int)children.size());
        this.assertElement((Node)children.get(0), ns, "firstName", firstName);
        this.assertElement((Node)children.get(1), ns, "lastName", lastName);
        this.assertElement((Node)children.get(2), ns, "age", age);
        Assert.assertTrue((boolean)(children.get(3) instanceof Element));
        Element addressEl = (Element)children.get(3);
        List addressChildren = XmlUtil.elements((Element)addressEl);
        Assert.assertEquals((int)3, (int)addressChildren.size());
        this.assertElement((Node)addressChildren.get(0), ns, "street", street);
        this.assertElement((Node)addressChildren.get(1), ns, "zip", zip);
        this.assertElement((Node)addressChildren.get(2), ns, "city", city);
    }
}

