/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.wait;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.activities.wait.WaitTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class WaitUntilTest
extends WaitTestCase {
    public WaitUntilTest() {
        super("http://example.com/waitUntil", "waitUntil");
    }

    public void testWait() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void launch() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        final long startTimeSecond = System.currentTimeMillis() / 1000L * 1000L;
        Date date = new Date(startTimeSecond + 3000L);
        String deadline = null;
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlCalendar = datatypeFactory.newXMLGregorianCalendar();
            GregorianCalendar calendar = xmlCalendar.toGregorianCalendar();
            calendar.setTime(date);
            xmlCalendar = datatypeFactory.newXMLGregorianCalendar(calendar);
            deadline = xmlCalendar.toString();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Assert.fail();
        }
        Assert.assertNotNull(deadline);
        parts.put("deadline", BpelXmlUtil.createElementWithContent(deadline));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                callResult.getMessageCarrier().getMessage();
                long endTimeSecond = System.currentTimeMillis();
                Assert.assertTrue((String)(endTimeSecond - startTimeSecond + " < 3000"), (endTimeSecond - startTimeSecond >= 3000L ? 1 : 0) != 0);
                WaitUntilTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }
}

