/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.integration.correlation.sales;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.integration.correlation.sales.Stock;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class SalesTest
extends BpelTestCase {
    private static final String NS = "http://petals.ow2.org/sales";
    private static final String SALES_PT_NAME = "sales";
    private static final String STOCK_PT_NAME = "stock";

    public SalesTest() {
        super(NS, "salesAsync");
    }

    public void testInititiate1Process() {
        this.process(4, true);
    }

    public void testInititiate2Process() {
        this.process(5, false);
    }

    public void process(int refId, boolean res) {
        this.deploy(((Object)((Object)this)).getClass().getResource("sales.bpel"), ((Object)((Object)this)).getClass().getResource("sales.wsdl"));
        Element processElement = XmlUtil.getDocumentWithOneElement((QName)new QName(this.getProcessNamespace(), "salesRequest"));
        Element itemElement = processElement.getOwnerDocument().createElementNS(this.getProcessNamespace(), "article");
        Element refElement = processElement.getOwnerDocument().createElementNS(this.getProcessNamespace(), "refId");
        refElement.setTextContent(String.valueOf(refId));
        Element nameElement = processElement.getOwnerDocument().createElementNS(this.getProcessNamespace(), "name");
        nameElement.setTextContent("shirt");
        Element quantityElement = processElement.getOwnerDocument().createElementNS(this.getProcessNamespace(), "quantity");
        quantityElement.setTextContent("4");
        itemElement.appendChild(refElement);
        itemElement.appendChild(nameElement);
        itemElement.appendChild(quantityElement);
        processElement.appendChild(itemElement);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("payload", processElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), SALES_PT_NAME);
        String operationName = "initiate";
        QName stockQN = new QName(NS, STOCK_PT_NAME);
        WSRepository.addWS(stockQN, new Stock());
        final BpelTestCase.CallResult result = this.call(parts, portTypeQName, "initiate");
        MessageVariable reply = result.getMessageCarrier().getMessage();
        Assert.assertNotNull((Object)reply);
        Element responseElement = reply.getPartValue("payload");
        Assert.assertNotNull((Object)responseElement.getFirstChild());
        if (res) {
            Assert.assertEquals((String)responseElement.getFirstChild().getTextContent(), (String)"OK: The command is registered");
        } else {
            Assert.assertEquals((String)responseElement.getFirstChild().getTextContent(), (String)"Error: The quantity is too important");
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                SalesTest.this.deleteInstance(result);
                return null;
            }
        });
        WSRepository.removeWS(stockQN);
        this.undeploy();
    }
}

