/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.perf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.Semaphore;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.perf.RemotePerfTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;

public class AdditionAsyncTest
extends RemotePerfTestCase {
    private static final Semaphore SEMAPHORE = new Semaphore(0, true);
    private static BasicHttpServer basicHttpServer;

    protected String getProcessName() {
        return "additionAsync";
    }

    protected String getProcessNamespace() {
        return "http://orchestra.ow2.org/addition";
    }

    public void deploy() {
        basicHttpServer = new BasicHttpServer();
        Thread t = new Thread(basicHttpServer);
        t.start();
        int port = basicHttpServer.getLocalPort();
        String ipAddress = "localhost";
        if (this.orchestraProperties.containsKey("clustersUrls")) {
            try {
                ipAddress = basicHttpServer.getIpAddress();
            }
            catch (UnknownHostException e1) {
                ipAddress = "localhost";
            }
        }
        try {
            byte[] originalWsdl = Misc.getAllContentFrom((URL)AdditionAsyncTest.class.getResource(this.getProcessName() + ".wsdl"));
            byte[] newWsdl = new String(originalWsdl).replace("localhost:12345", ipAddress + ":" + port).getBytes();
            File f = Misc.createTempFile((String)"tmp", null, null);
            f.deleteOnExit();
            Misc.write((byte[])newWsdl, (File)f);
            this.deploy(AdditionAsyncTest.class.getResource(this.getProcessName() + ".bpel"), f.toURI().toURL());
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    public long launch() {
        long endTime = -1L;
        int base = Misc.random((int)0, (int)100000);
        int toAdd = Misc.random((int)-555, (int)100000);
        Document doc = XmlUtil.getDocumentFromString((String)("<add><base>" + base + "</base><toAdd>" + toAdd + "</toAdd></add>"));
        SOAPMessage request = SOAPUtil.buildSOAPMessage((Document)doc, (String)"http://orchestra.ow2.org/addition/add");
        String[] endpoints = this.getStaticClusterEndpoint("additionAsyncPort");
        try {
            int nbClusterNode = endpoints.length;
            if (endpoints != null && nbClusterNode > 0) {
                SOAPMessage[] responses = new SOAPMessage[nbClusterNode];
                for (int i = 0; i < nbClusterNode; ++i) {
                    responses[i] = SOAPUtil.call((SOAPMessage)request, (String)endpoints[i]);
                }
                endTime = System.currentTimeMillis();
                boolean allResponseIsUnavailable = true;
                for (int j = 0; j < nbClusterNode; ++j) {
                    if (responses[j] == null) continue;
                    allResponseIsUnavailable = false;
                }
                if (!allResponseIsUnavailable) {
                    Assert.assertTrue((String)"Return available", (boolean)false);
                }
                SEMAPHORE.acquire(nbClusterNode);
            } else {
                String endpoint = this.getDefaultEndpoint("additionAsyncPort");
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                endTime = System.currentTimeMillis();
                if (response != null) {
                    Assert.assertTrue((String)"Return available", (boolean)false);
                }
                SEMAPHORE.acquire();
            }
            return endTime;
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while performing test", (Throwable)e);
        }
    }

    public void testAddition() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void undeploy() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals((int)0, (int)SEMAPHORE.availablePermits());
        basicHttpServer.stop();
        super.undeploy();
    }

    public String getAlias() {
        return "axis.addAsync";
    }

    private static class BasicHttpServer
    implements Runnable {
        private boolean stop = false;
        private final ServerSocket serverSocket;

        public BasicHttpServer() {
            try {
                this.serverSocket = new ServerSocket(0);
                this.serverSocket.setReuseAddress(true);
                this.serverSocket.setSoTimeout(5000);
            }
            catch (IOException e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
        }

        public void run() {
            while (!this.stop) {
                try {
                    Socket socket = this.serverSocket.accept();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String s = bufferedReader.readLine();
                    int contentLength = 0;
                    while (s != null && !s.equals("")) {
                        if (s.startsWith("Content-Length: ")) {
                            contentLength = Integer.parseInt(s.substring("Content-Length: ".length()));
                        }
                        s = bufferedReader.readLine();
                    }
                    char[] msgChars = new char[contentLength];
                    bufferedReader.read(msgChars);
                    String msg = new String(msgChars);
                    socket.getOutputStream().write("HTTP/1.0 200 OK\r\n".getBytes());
                    socket.getOutputStream().close();
                    socket.close();
                    if (msg.contains("<total>")) {
                        SEMAPHORE.release();
                        continue;
                    }
                    throw new OrchestraRuntimeException("exception in server");
                }
                catch (SocketTimeoutException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void stop() {
            this.stop = true;
        }

        public int getLocalPort() {
            return this.serverSocket.getLocalPort();
        }

        public String getIpAddress() throws UnknownHostException {
            return InetAddress.getLocalHost().getHostAddress();
        }
    }
}

