/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.perf;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.perf.RemotePerfTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MarketplaceTest
extends RemotePerfTestCase {
    protected String getProcessName() {
        return "marketplace";
    }

    protected String getProcessNamespace() {
        return "http://orchestra.ow2.org/marketplace";
    }

    public void deploy() {
        this.deploy(org.ow2.orchestra.test.perf.marketplace.MarketplaceTest.class.getResource(this.getProcessName() + ".bpel"), org.ow2.orchestra.test.perf.marketplace.MarketplaceTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        return this.launch(System.currentTimeMillis() % 2L == 0L);
    }

    public long launch(boolean successful) {
        int sellerPrice;
        int buyerPrice;
        String item = "item" + Thread.currentThread().getName();
        if (successful) {
            buyerPrice = Misc.random((int)500, (int)1000);
            sellerPrice = Misc.random((int)0, (int)499);
        } else {
            sellerPrice = Misc.random((int)500, (int)1000);
            buyerPrice = Misc.random((int)0, (int)499);
        }
        BuyerThread buyerThread = new BuyerThread(item, buyerPrice);
        SellerThread sellerThread = new SellerThread(item, sellerPrice);
        buyerThread.start();
        sellerThread.start();
        try {
            while (!buyerThread.ended || !sellerThread.ended) {
                buyerThread.join(1000L);
                sellerThread.join(1000L);
                if (buyerThread.exception != null) {
                    throw new OrchestraRuntimeException("Exception in buyer thread", buyerThread.exception);
                }
                if (sellerThread.exception == null) continue;
                throw new OrchestraRuntimeException("Exception in seller thread", sellerThread.exception);
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while joining buyer and seller threads : " + e.getMessage(), (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        SOAPMessage buyerResponse = buyerThread.getReply();
        SOAPMessage sellerResponse = sellerThread.getReply();
        String buyerOutcome = this.getOutcome(buyerResponse, "buyer");
        String sellerOutcome = this.getOutcome(sellerResponse, "seller");
        MarketplaceTest.chekOutcomes(buyerPrice, buyerOutcome, sellerPrice, sellerOutcome);
        return endTime;
    }

    public static void chekOutcomes(int buyerPrice, String buyerOutcome, int sellerPrice, String sellerOutcome) {
        String success = "Deal Successful";
        String fail = "Deal Failed";
        if (buyerPrice >= sellerPrice) {
            if (!buyerOutcome.equals("Deal Successful")) {
                throw new OrchestraRuntimeException("Buyer price > Seller price and buyer outcome is not 'Deal Successful', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
            if (!sellerOutcome.equals("Deal Successful")) {
                throw new OrchestraRuntimeException("Buyer price > Seller price and seller outcome is not 'Deal Successful', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
        } else {
            if (!buyerOutcome.equals("Deal Failed")) {
                throw new OrchestraRuntimeException("Buyer price < Seller price and buyer outcome is not 'Deal Failed', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
            if (!sellerOutcome.equals("Deal Failed")) {
                throw new OrchestraRuntimeException("Buyer price < Seller price and seller outcome is not 'Deal Failed', buyerOutcome='" + buyerOutcome + "', sellerOutCome='" + sellerOutcome + "'" + ", buyerPrice=" + buyerPrice + ", sellerPrice=" + sellerPrice);
            }
        }
    }

    private String getOutcome(SOAPMessage response, String operationName) {
        SOAPBodyElement result = this.getSOAPBodyElement(response);
        try {
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)result.getFirstChild());
            Assert.assertTrue((boolean)(result.getFirstChild() instanceof Element));
            Element st = (Element)result.getFirstChild();
            Assert.assertEquals((String)"outcome", (String)st.getLocalName());
            Assert.assertNotNull((Object)st.getFirstChild());
            Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
            Text text = (Text)st.getFirstChild();
            return text.getData();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while getting outcome", (Throwable)e);
        }
        catch (AssertionFailedError e) {
            System.err.println("result = " + XmlUtil.toString((Node)result));
            throw e;
        }
    }

    public void testMarketplace() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public String getAlias() {
        return "axis.market";
    }

    public class SellerThread
    extends MPThread {
        public SellerThread(String item, int price) {
            super(item, price);
        }

        public Document getDocument() {
            return XmlUtil.getDocumentFromString((String)("<" + this.getOperationName() + "><inventoryItem>" + this.item + "</inventoryItem><askingPrice>" + this.price + "</askingPrice></" + this.getOperationName() + ">"));
        }

        public String getOperationName() {
            return "seller";
        }

        public String getPort() {
            return "sellerPort";
        }

        public String getSOAPAction() {
            return "http://orchestra.ow2.org/marketplace/seller";
        }
    }

    public class BuyerThread
    extends MPThread {
        public BuyerThread(String item, int price) {
            super(item, price);
        }

        public Document getDocument() {
            return XmlUtil.getDocumentFromString((String)("<" + this.getOperationName() + "><item>" + this.item + "</item><offer>" + this.price + "</offer></" + this.getOperationName() + ">"));
        }

        public String getOperationName() {
            return "buyer";
        }

        public String getPort() {
            return "buyerPort";
        }

        public String getSOAPAction() {
            return "http://orchestra.ow2.org/marketplace/buyer";
        }
    }

    public abstract class MPThread
    extends Thread {
        protected String item;
        protected int price;
        protected SOAPMessage response;
        protected Throwable exception = null;
        protected boolean ended = false;

        public MPThread(String item, int price) {
            this.item = item;
            this.price = price;
        }

        public SOAPMessage getReply() {
            return this.response;
        }

        public abstract Document getDocument();

        public abstract String getOperationName();

        public abstract String getSOAPAction();

        public abstract String getPort();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SOAPMessage request = SOAPUtil.buildSOAPMessage((Document)this.getDocument(), (String)this.getSOAPAction());
                String endpoint = MarketplaceTest.this.getDefaultEndpoint(this.getPort());
                this.response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (this.response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)this.response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertFalse((String)XmlUtil.toString((Node)result), (boolean)"Fault".equals(result.getElementName().getLocalName()));
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.exception = e;
                e.printStackTrace();
            }
            finally {
                this.ended = true;
            }
        }
    }
}

