/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.receiveSeq;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ReceiveSeqTest
extends RemoteTestCase {
    private static final String SOAPACTION1 = "http://orchestra.ow2.org/tests/receiveSeq/receive";
    private static final String SOAPACTION2 = "http://orchestra.ow2.org/tests/receiveSeq/receive2";

    public void testAxisReceiveSeq() {
        try {
            String processName = "receiveSeq";
            String processNamespace = "http://orchestra.ow2.org/tests/receiveSeq";
            QName processQName = new QName("http://orchestra.ow2.org/tests/receiveSeq", "receiveSeq");
            this.deploy("receiveSeq");
            String part = "<request>create</request>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/receiveSeq/createInstance", (String)"<request>create</request>");
            String endpoint = this.getDefaultEndpoint("createSeqPort");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            Assert.assertNull((Object)response);
            ReceiveSeqThread firstCall = new ReceiveSeqThread("first", SOAPACTION1, "receive");
            ReceiveSeqThread secondCall = new ReceiveSeqThread("second", SOAPACTION1, "receive");
            ReceiveSeqThread thirdCall = new ReceiveSeqThread("third", SOAPACTION1, "receive");
            ReceiveSeqThread fourthCall = new ReceiveSeqThread("fourth", SOAPACTION2, "receive2");
            Thread t1 = new Thread(firstCall);
            Thread t2 = new Thread(secondCall);
            Thread t3 = new Thread(thirdCall);
            Thread t4 = new Thread(fourthCall);
            t1.start();
            t2.start();
            t3.start();
            t4.start();
            while (!(firstCall.isFinished() && secondCall.isFinished() && thirdCall.isFinished() && fourthCall.isFinished())) {
                t1.join(100L);
                t2.join(100L);
                t3.join(100L);
                t4.join(100L);
                if (firstCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(firstCall.getTrowable());
                }
                if (secondCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(secondCall.getTrowable());
                }
                if (thirdCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread").initCause(thirdCall.getTrowable());
                }
                if (fourthCall.getTrowable() == null) continue;
                throw new AssertionFailedError("Error in thread").initCause(fourthCall.getTrowable());
            }
            this.undeploy(processQName);
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    public void testAxisReceiveSeqWrongOrder() {
        String processName = "receiveSeq";
        String processNamespace = "http://orchestra.ow2.org/tests/receiveSeq";
        QName processQName = new QName("http://orchestra.ow2.org/tests/receiveSeq", "receiveSeq");
        this.deploy("receiveSeq");
        String part = "<request>create</request>";
        SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/receiveSeq/createInstance", (String)"<request>create</request>");
        String endpoint = this.getDefaultEndpoint("createSeqPort");
        ReceiveSeqThread firstCall = new ReceiveSeqThread("first", SOAPACTION1, "receive");
        ReceiveSeqThread secondCall = new ReceiveSeqThread("second", SOAPACTION1, "receive");
        ReceiveSeqThread thirdCall = new ReceiveSeqThread("third", SOAPACTION1, "receive");
        ReceiveSeqThread fourthCall = new ReceiveSeqThread("fourth", SOAPACTION2, "receive2");
        Thread t1 = new Thread(firstCall);
        Thread t2 = new Thread(secondCall);
        Thread t3 = new Thread(thirdCall);
        Thread t4 = new Thread(fourthCall);
        t1.start();
        t2.start();
        t3.start();
        t4.start();
        try {
            Thread.sleep(1000L);
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            Assert.assertNull((Object)response);
            while (!(firstCall.isFinished() && secondCall.isFinished() && thirdCall.isFinished() && fourthCall.isFinished())) {
                t1.join(100L);
                t2.join(100L);
                t3.join(100L);
                t4.join(100L);
                if (firstCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread 1").initCause(firstCall.getTrowable());
                }
                if (secondCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread 2").initCause(secondCall.getTrowable());
                }
                if (thirdCall.getTrowable() != null) {
                    throw new AssertionFailedError("Error in thread 3").initCause(thirdCall.getTrowable());
                }
                if (fourthCall.getTrowable() == null) continue;
                throw new AssertionFailedError("Error in thread 4").initCause(fourthCall.getTrowable());
            }
        }
        catch (Throwable e) {
            if (e instanceof AssertionFailedError) {
                throw (AssertionFailedError)e;
            }
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        this.undeploy(processQName);
    }

    class ReceiveSeqThread
    implements Runnable {
        private Throwable uncaughtException;
        private final String id;
        private final String soapAction;
        private final String operation;
        private boolean finished = false;

        public Throwable getTrowable() {
            return this.uncaughtException;
        }

        public ReceiveSeqThread(String text, String soapAction, String operation) {
            this.id = text;
            this.soapAction = soapAction;
            this.operation = operation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String part = "<" + this.operation + ">" + this.id + "</" + this.operation + ">";
                SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)this.soapAction, (String)part);
                String endpoint = ReceiveSeqTest.this.getDefaultEndpoint("receiveSeqPort");
                SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
                if (response != null) {
                    SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                    Assert.assertNotNull((Object)result);
                    Assert.assertNotNull((Object)result.getFirstChild());
                    Assert.assertTrue((String)XmlUtil.toString((Node)result), (boolean)(result.getFirstChild() instanceof Text));
                    Text text = (Text)result.getFirstChild();
                    Assert.assertEquals((String)this.id, (String)text.getData());
                } else {
                    Assert.assertTrue((String)"No return available", (boolean)false);
                }
            }
            catch (Throwable e) {
                this.uncaughtException = e;
            }
            finally {
                this.finished = true;
            }
        }

        protected boolean isFinished() {
            return this.finished;
        }
    }
}

