/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.runtime;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class TestInstanceSuspendPickUntil
extends BpelTestCase {
    public TestInstanceSuspendPickUntil() {
        super("http://orchestra.ow2.org/SuspendTimerPickUntil", "SuspendTimerPickUntil");
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void testInstanceSuspend() {
        this.deploy();
        this.launch(1);
        this.undeploy();
    }

    public void testInstanceSuspendSuspended() {
        this.deploy();
        this.launch(2);
        this.undeploy();
    }

    private void deleteInstanceMethod(BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                TestInstanceSuspendPickUntil.this.deleteInstances(1);
                return null;
            }
        });
    }

    private void suspendInstanceMethod(final BpelTestCase.CallResult callResult) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                callResult.getInstance().suspendInstance();
                return null;
            }
        });
    }

    public void launch(int suspendNumber) {
        long startTimeSecond = System.currentTimeMillis() / 1000L * 1000L;
        Date date = new Date(startTimeSecond + 3000L);
        String deadline = null;
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar xmlCalendar = datatypeFactory.newXMLGregorianCalendar();
            GregorianCalendar calendar = xmlCalendar.toGregorianCalendar();
            calendar.setTime(date);
            xmlCalendar = datatypeFactory.newXMLGregorianCalendar(calendar);
            deadline = xmlCalendar.toString();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            TestInstanceSuspendPickUntil.fail();
        }
        TestInstanceSuspendPickUntil.assertNotNull(deadline);
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("deadline", BpelXmlUtil.createElementWithContent((String)deadline));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "SuspendTimerPickUntilOperation");
        for (int i = 0; i < suspendNumber; ++i) {
            this.suspendInstanceMethod(callResult);
        }
        Assert.assertEquals((String)"", (String)saveWS.getBuffer());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((String)"", (String)saveWS.getBuffer());
        this.deleteInstanceMethod(callResult);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
    }
}

