/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.CorrelationSetInitialization;
import org.ow2.orchestra.facade.runtime.PartnerLinkUpdate;
import org.ow2.orchestra.facade.runtime.VariableUpdate;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ForeachActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.IfActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.RepeatUntilActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ScopeActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.SequenceActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.WaitActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.WhileActivityFullInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.activities.wait.WaitTestCase;
import org.ow2.orchestra.test.wsutils.StringWS;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubTypesTest
extends WaitTestCase {
    private ProcessInstanceUUID processFullInstanceUUID;

    public abstract Querier getQuerier();

    public AbstractSubTypesTest(BpelTestCase.EnvironmentType environmentType) {
        super("http://orchestra.ow2.org/subtypestest", "subtypestest", environmentType);
    }

    public void testSubTypes() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    @Override
    public void deploy() {
        String suffix = "-response";
        this.deploy(((Object)((Object)this)).getClass().getResource("subtypestest.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        WSRepository.addWS(StringWS.PORTTYPE_QNAME, new StringWS("-response"));
    }

    @Override
    public void undeploy() {
        WSRepository.removeWS(StringWS.PORTTYPE_QNAME);
        super.undeploy();
    }

    public void launch() {
        String content = "5";
        Element inputElement = XmlUtil.getDocumentWithOneElement((QName)new QName("http://orchestra.ow2.org/subtypestest", "subtypestest"));
        Text textContent = inputElement.getOwnerDocument().createTextNode("5");
        inputElement.appendChild(textContent);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", inputElement);
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = EnvTool.getJournalQueriers();
                Set processFullInstanceSet = querier.findProcessInstances(ActivityState.RUNNING);
                AbstractSubTypesTest.this.processFullInstanceUUID = ((ProcessFullInstance)processFullInstanceSet.iterator().next()).getUUID();
                return null;
            }
        });
        this.call(parts, portTypeQName, "receiveTest");
        this.call(parts, portTypeQName, "continue").getMessageCarrier().getMessage();
        callResult.getMessageCarrier().getMessage();
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Querier querier = AbstractSubTypesTest.this.getQuerier();
                ProcessFullInstance processFullInstance = querier.getProcessInstance(AbstractSubTypesTest.this.processFullInstanceUUID);
                Assert.assertNotNull((Object)processFullInstance);
                Assert.assertEquals((Object)ActivityType.PROCESS, (Object)processFullInstance.getType());
                AbstractSubTypesTest.this.checkProcess((ActivityFullInstance)processFullInstance);
                ActivityFullInstance enclosedActivityInstance = (ActivityFullInstance)processFullInstance.getEnclosedActivity().fullCopy();
                Assert.assertEquals((Object)ActivityType.SEQUENCE, (Object)enclosedActivityInstance.getType());
                SequenceActivityFullInstance sequenceActivityFullInstance = (SequenceActivityFullInstance)enclosedActivityInstance;
                List sequenceEnclosedActivities = sequenceActivityFullInstance.getEnclosedActivities();
                Iterator activityFullInstanceIterator = sequenceEnclosedActivities.iterator();
                int checkedDefinitions = 0;
                block15: while (activityFullInstanceIterator.hasNext()) {
                    ActivityFullInstance activityFullInstance = (ActivityFullInstance)activityFullInstanceIterator.next();
                    switch (activityFullInstance.getType()) {
                        case ASSIGN: {
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case REPLY: {
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case RECEIVE: {
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case EXIT: {
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case COMPENSATE: {
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case COMPENSATE_SCOPE: {
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case IF: {
                            AbstractSubTypesTest.this.checkIf(activityFullInstance);
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case SCOPE: {
                            AbstractSubTypesTest.this.checkScope(activityFullInstance);
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case SEQUENCE: {
                            AbstractSubTypesTest.this.checkSequence(activityFullInstance);
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case REPEAT_UNTIL: {
                            AbstractSubTypesTest.this.checkRepeatUntil(activityFullInstance);
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case WHILE: {
                            AbstractSubTypesTest.this.checkWhile(activityFullInstance);
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case WAIT: {
                            AbstractSubTypesTest.this.checkWait(activityFullInstance);
                            ++checkedDefinitions;
                            continue block15;
                        }
                        case FOR_EACH: {
                            AbstractSubTypesTest.this.checkForeach(activityFullInstance);
                            ++checkedDefinitions;
                            continue block15;
                        }
                    }
                    System.out.println("Type not found: " + activityFullInstance.getType());
                }
                Assert.assertEquals((int)sequenceEnclosedActivities.size(), (int)checkedDefinitions);
                AbstractSubTypesTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    private String removeIndentation(String text) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(text));
        StringBuilder noIdentString = new StringBuilder();
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                noIdentString.append(line.trim());
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return noIdentString.toString();
    }

    public void checkIf(ActivityFullInstance activityFullInstance) {
        Assert.assertEquals((Object)ActivityType.EMPTY, (Object)((IfActivityFullInstance)activityFullInstance).getEnclosedActivity().getType());
    }

    private void checkProcess(ActivityFullInstance activityFullInstance) {
        ProcessFullInstance processFullInstance = (ProcessFullInstance)activityFullInstance;
        List correlationSet = processFullInstance.getCorrelationSet();
        Assert.assertEquals((int)2, (int)correlationSet.size());
        CorrelationSetInitialization correlationSetInitialization = (CorrelationSetInitialization)correlationSet.get(0);
        Assert.assertEquals((String)"auctionCS", (String)correlationSetInitialization.getName());
        Map map = correlationSetInitialization.getPropertyValues();
        Assert.assertEquals((int)1, (int)map.size());
        Map.Entry entry = map.entrySet().iterator().next();
        Assert.assertEquals((String)"{http://orchestra.ow2.org/subtypestest}auctionId", (String)((QName)entry.getKey()).toString());
        Assert.assertEquals((String)"<subtypestest xmlns=\"http://orchestra.ow2.org/subtypestest\">5</subtypestest>", (String)this.removeIndentation(XmlUtil.toString((Node)((Node)entry.getValue()))));
        correlationSetInitialization = (CorrelationSetInitialization)correlationSet.get(1);
        Assert.assertEquals((String)"auctionCS2", (String)correlationSetInitialization.getName());
        map = correlationSetInitialization.getPropertyValues();
        Assert.assertEquals((int)1, (int)map.size());
        entry = map.entrySet().iterator().next();
        Assert.assertEquals((String)"{http://orchestra.ow2.org/subtypestest}auctionId2", (String)((QName)entry.getKey()).toString());
        Assert.assertEquals((String)"<suffix xmlns=\"http://orchestra.ow2.org/stringWS\">5</suffix>", (String)this.removeIndentation(XmlUtil.toString((Node)((Node)entry.getValue()))));
        Assert.assertEquals((int)4, (int)processFullInstance.getPartnerLink().size());
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.addAll(Arrays.asList("stringWSPL", "stringWSPLCopy"));
        Iterator it = processFullInstance.getPartnerLink().iterator();
        PartnerLinkUpdate partnerLinkUpdate = (PartnerLinkUpdate)it.next();
        Assert.assertNotNull((Object)nameList.remove(partnerLinkUpdate.getName()));
        Assert.assertNotNull((Object)partnerLinkUpdate.getPartnerLinkReference());
        partnerLinkUpdate = (PartnerLinkUpdate)it.next();
        Assert.assertNotNull((Object)nameList.remove(partnerLinkUpdate.getName()));
        Assert.assertNotNull((Object)partnerLinkUpdate.getPartnerLinkReference());
        Assert.assertEquals((int)0, (int)nameList.size());
        partnerLinkUpdate = (PartnerLinkUpdate)it.next();
        Assert.assertEquals((String)"stringWSPL", (String)partnerLinkUpdate.getName());
        String partnerLinkValue = "<sref:service-ref xmlns:sref=\"http://docs.oasis-open.org/wsbpel/2.0/serviceref\" xmlns:ns42=\"http://example.com/partnerLink\"><addr:EndpointReference xmlns:addr=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"><addr:Address>http://localhost:8080/partnerLinkService</addr:Address><addr:ServiceName>ns42:partnerLinkService</addr:ServiceName></addr:EndpointReference></sref:service-ref>";
        Assert.assertEquals((String)"<sref:service-ref xmlns:sref=\"http://docs.oasis-open.org/wsbpel/2.0/serviceref\" xmlns:ns42=\"http://example.com/partnerLink\"><addr:EndpointReference xmlns:addr=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"><addr:Address>http://localhost:8080/partnerLinkService</addr:Address><addr:ServiceName>ns42:partnerLinkService</addr:ServiceName></addr:EndpointReference></sref:service-ref>", (String)this.removeIndentation(XmlUtil.toString((Node)partnerLinkUpdate.getPartnerLinkReference())));
        partnerLinkUpdate = (PartnerLinkUpdate)it.next();
        Assert.assertEquals((String)"stringWSPLCopy", (String)partnerLinkUpdate.getName());
        Assert.assertEquals((String)"<sref:service-ref xmlns:sref=\"http://docs.oasis-open.org/wsbpel/2.0/serviceref\" xmlns:ns42=\"http://example.com/partnerLink\"><addr:EndpointReference xmlns:addr=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"><addr:Address>http://localhost:8080/partnerLinkService</addr:Address><addr:ServiceName>ns42:partnerLinkService</addr:ServiceName></addr:EndpointReference></sref:service-ref>", (String)this.removeIndentation(XmlUtil.toString((Node)partnerLinkUpdate.getPartnerLinkReference())));
    }

    public void checkScope(ActivityFullInstance activityFullInstance) {
        ScopeActivityFullInstance scopeActivityFullInstance = (ScopeActivityFullInstance)activityFullInstance;
        if (scopeActivityFullInstance.getEnclosedActivity().getType().equals((Object)ActivityType.SEQUENCE)) {
            List variables = scopeActivityFullInstance.getVariables();
            Assert.assertEquals((int)2, (int)variables.size());
            Iterator activityFullInstanceIterator = ((SequenceActivityFullInstance)scopeActivityFullInstance.getEnclosedActivity()).getEnclosedActivities().iterator();
            ActivityFullInstance enclosedActivityFullInstance = (ActivityFullInstance)activityFullInstanceIterator.next();
            while (activityFullInstanceIterator.hasNext()) {
                Iterator<VariableUpdate> variableUpdateIterator = variables.iterator();
                if (ActivityType.SCOPE.equals((Object)enclosedActivityFullInstance.getType())) {
                    this.checkScopeInvoke(enclosedActivityFullInstance, variableUpdateIterator);
                }
                if (ActivityType.RECEIVE.equals((Object)enclosedActivityFullInstance.getType())) {
                    this.checkScopeReceive(enclosedActivityFullInstance, variableUpdateIterator);
                }
                enclosedActivityFullInstance = (ActivityFullInstance)activityFullInstanceIterator.next();
            }
        } else if (!scopeActivityFullInstance.getEnclosedActivity().getType().equals((Object)ActivityType.INVOKE)) {
            Assert.assertEquals((Object)ActivityType.ASSIGN, (Object)scopeActivityFullInstance.getEnclosedActivity().getType());
            List variables = scopeActivityFullInstance.getVariables();
            Assert.assertEquals((int)4, (int)variables.size());
            Iterator it = variables.iterator();
            VariableUpdate assignVariableUpdate = (VariableUpdate)it.next();
            Assert.assertTrue((boolean)assignVariableUpdate.getActivityUUID().equals((Object)scopeActivityFullInstance.getEnclosedActivity().getUUID()));
            Assert.assertEquals((String)"var1", (String)assignVariableUpdate.getName());
            Assert.assertEquals((String)"<Orchestra_BPEL_Prefix:ORCHESTRA_anonymous_element xmlns:Orchestra_BPEL_Prefix=\"http://orchestra.ow2.org\">10</Orchestra_BPEL_Prefix:ORCHESTRA_anonymous_element>", (String)this.removeIndentation(XmlUtil.toString((Node)((Element)assignVariableUpdate.getValue()))));
            assignVariableUpdate = (VariableUpdate)it.next();
            Assert.assertTrue((boolean)assignVariableUpdate.getActivityUUID().equals((Object)scopeActivityFullInstance.getEnclosedActivity().getUUID()));
            Assert.assertEquals((String)"var0", (String)assignVariableUpdate.getName());
            Assert.assertEquals((String)"<Orchestra_BPEL_Prefix:ORCHESTRA_anonymous_element xmlns:Orchestra_BPEL_Prefix=\"http://orchestra.ow2.org\">3</Orchestra_BPEL_Prefix:ORCHESTRA_anonymous_element>", (String)this.removeIndentation(XmlUtil.toString((Node)((Element)assignVariableUpdate.getValue()))));
            assignVariableUpdate = (VariableUpdate)it.next();
            Assert.assertTrue((boolean)assignVariableUpdate.getActivityUUID().equals((Object)scopeActivityFullInstance.getEnclosedActivity().getUUID()));
            Assert.assertEquals((String)"var5", (String)assignVariableUpdate.getName());
            Assert.assertEquals((String)XmlUtil.toString((Node)XmlUtil.getDocumentFromString((String)"<message><input><subtypestest xmlns=\"http://orchestra.ow2.org/subtypestest\">5</subtypestest></input></message>", (boolean)false)), (String)((MessageVariable)assignVariableUpdate.getValue()).toString());
            assignVariableUpdate = (VariableUpdate)it.next();
            Assert.assertTrue((boolean)assignVariableUpdate.getActivityUUID().equals((Object)scopeActivityFullInstance.getEnclosedActivity().getUUID()));
            Assert.assertEquals((String)"var6", (String)assignVariableUpdate.getName());
            Assert.assertEquals((String)XmlUtil.toString((Node)XmlUtil.getDocumentFromString((String)"<message><payload><submitRequest xmlns=\"http://orchestra.ow2.org/subtypestest\"><toto xmlns=\"\">12</toto></submitRequest></payload></message>", (boolean)false)), (String)((MessageVariable)assignVariableUpdate.getValue()).toString());
        }
    }

    public void checkScopeReceive(ActivityFullInstance enclosedActivityFullInstance, Iterator<VariableUpdate> variableUpdateIterator) {
        ActivityInstanceUUID receiveActivityInstanceUUID = enclosedActivityFullInstance.getUUID();
        VariableUpdate assignVariableUpdate = variableUpdateIterator.next();
        int i = 2;
        while (!assignVariableUpdate.getName().equals("varReceiveTest")) {
            if (--i == 0) {
                Assert.fail((String)("No variable named " + assignVariableUpdate.getName()));
            }
            assignVariableUpdate = variableUpdateIterator.next();
        }
        Assert.assertTrue((boolean)assignVariableUpdate.getActivityUUID().equals((Object)receiveActivityInstanceUUID));
        Assert.assertEquals((String)"varReceiveTest", (String)assignVariableUpdate.getName());
        Assert.assertEquals((String)XmlUtil.toString((Node)XmlUtil.getDocumentFromString((String)"<message><input><subtypestest xmlns=\"http://orchestra.ow2.org/subtypestest\">5</subtypestest></input></message>", (boolean)false)), (String)((MessageVariable)assignVariableUpdate.getValue()).toString());
    }

    public void checkScopeInvoke(ActivityFullInstance enclosedActivityFullInstance, Iterator<VariableUpdate> variableUpdateIterator) {
        ActivityInstanceUUID invokeActivityInstanceUUID = ((ScopeActivityFullInstance)enclosedActivityFullInstance).getEnclosedActivityUUID();
        VariableUpdate assignVariableUpdate = variableUpdateIterator.next();
        int i = 2;
        while (!assignVariableUpdate.getName().equals("stringWSResponse")) {
            if (--i == 0) {
                Assert.fail((String)("No variable named " + assignVariableUpdate.getName()));
            }
            assignVariableUpdate = variableUpdateIterator.next();
        }
        Assert.assertTrue((boolean)assignVariableUpdate.getActivityUUID().equals((Object)invokeActivityInstanceUUID));
        Assert.assertEquals((String)"stringWSResponse", (String)assignVariableUpdate.getName());
        Assert.assertEquals((String)XmlUtil.toString((Node)XmlUtil.getDocumentFromString((String)"<message><output><suffix xmlns=\"http://orchestra.ow2.org/stringWS\">5-response</suffix></output></message>", (boolean)false)), (String)((MessageVariable)assignVariableUpdate.getValue()).toString());
    }

    public void checkRepeatUntil(ActivityFullInstance activityFullInstance) {
        RepeatUntilActivityFullInstance repeatUntilActivityFullInstance = (RepeatUntilActivityFullInstance)activityFullInstance;
        Assert.assertEquals((int)12, (int)repeatUntilActivityFullInstance.getEnclosedActivities().size());
        for (ActivityFullInstance enclosedActivityFullInstance : repeatUntilActivityFullInstance.getEnclosedActivities()) {
            Assert.assertEquals((Object)ActivityType.ASSIGN, (Object)enclosedActivityFullInstance.getType());
        }
    }

    public void checkWhile(ActivityFullInstance activityFullInstance) {
        WhileActivityFullInstance whileActivityFullInstance = (WhileActivityFullInstance)activityFullInstance;
        Assert.assertEquals((int)7, (int)whileActivityFullInstance.getEnclosedActivities().size());
        for (ActivityFullInstance enclosedActivityFullInstance : whileActivityFullInstance.getEnclosedActivities()) {
            Assert.assertEquals((Object)ActivityType.ASSIGN, (Object)enclosedActivityFullInstance.getType());
        }
    }

    public void checkWait(ActivityFullInstance activityFullInstance) {
        WaitActivityFullInstance waitActivityFullInstance = (WaitActivityFullInstance)activityFullInstance;
        Assert.assertNotNull((Object)waitActivityFullInstance.getWaitingActivity().getExpectedStartedDate());
        Assert.assertTrue((waitActivityFullInstance.getWaitingActivity().getExpectedStartedDate().getTime() <= waitActivityFullInstance.getEndedDate().getTime() ? 1 : 0) != 0);
        Assert.assertTrue((waitActivityFullInstance.getWaitingActivity().getExpectedStartedDate().getTime() >= waitActivityFullInstance.getStartedDate().getTime() ? 1 : 0) != 0);
    }

    public void checkForeach(ActivityFullInstance activityFullInstance) {
        ForeachActivityFullInstance foreachActivityFullInstance = (ForeachActivityFullInstance)activityFullInstance;
        Assert.assertEquals((int)2, (int)foreachActivityFullInstance.getStartValue());
        Assert.assertEquals((int)6, (int)foreachActivityFullInstance.getStopValue());
    }

    public void checkSequence(ActivityFullInstance activityFullInstance) {
        Assert.assertTrue((boolean)(activityFullInstance instanceof SequenceActivityFullInstance));
    }
}

