/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.util;

import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.orchestra.facade.exception.IncompatibleWSDLException;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.ow2.orchestra.wsdl.WsdlComparator;

public class WsdlComparatorTest
extends TestCase {
    public void testCompareSamePort() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        WsdlComparator.checkSamePort((Port)port, (Port)port2);
    }

    public void testComparePortName() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld2.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort2");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testComparePortAddress() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld3.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        WsdlComparator.checkSamePort((Port)port, (Port)port2);
    }

    public void testCompareBindingName() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld4.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareBindingStyle() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld5.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareBindingTransport() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld6.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareBindingSOAPAction() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld7.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareInputUse() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld8.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareOutputUse() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld9.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareOperationName() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld10.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareOperationOutput() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld11.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareOperationInputMessage() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld12.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareOperationOutputMessage() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld13.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareMessagePartName() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld14.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareMessagePartNumber() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld15.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareMessagePartElement() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld16.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareMessagePartType() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld17.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareMissingOperation() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld18.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        try {
            WsdlComparator.checkSamePort((Port)port, (Port)port2);
            Assert.fail((String)"Exception expected");
        }
        catch (IncompatibleWSDLException e) {
            // empty catch block
        }
    }

    public void testCompareAddPortType() {
        Definition def = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld.wsdl"));
        Service svc = def.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port = svc.getPort("helloworldPort");
        Definition def2 = WsdlUtil.readWsdl((URL)WsdlComparatorTest.class.getResource("wsdl/helloworld19.wsdl"));
        Service svc2 = def2.getService(new QName("http://example.com/helloworld", "helloworldService"));
        Port port2 = svc2.getPort("helloworldPort");
        WsdlComparator.checkSamePort((Port)port, (Port)port2);
    }
}

