/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.var.fromEii;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FromEiiTest
extends BpelTestCase {
    public FromEiiTest() {
        super("http://example.com/fromEii", "fromEii");
    }

    public void testFromEii() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() {
        URL request = ((Object)((Object)this)).getClass().getResource("request.xml");
        this.assertExists(request);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("p", XmlUtil.getDocumentFromURL((URL)request).getDocumentElement());
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        long endTime = System.currentTimeMillis();
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Assert.assertNotNull(callResult.getVariables());
                FromEiiTest.this.assertProductAmount(FromEiiTest.this.getVariableValue(callResult, "productAmount1"));
                FromEiiTest.this.assertProductReference(FromEiiTest.this.getVariableValue(callResult, "productReference1"));
                FromEiiTest.this.assertApprovalNotice2Var(FromEiiTest.this.getVariableValue(callResult, "approvalNotice2Var"));
                FromEiiTest.this.assertPoHeaderVar2(FromEiiTest.this.getVariableValue(callResult, "poHeaderVar2"));
                FromEiiTest.this.assertPoHeaderVar4(FromEiiTest.this.getVariableValue(callResult, "poHeaderVar4"));
                FromEiiTest.this.assertApprovalNotice3Var(FromEiiTest.this.getVariableValue(callResult, "approvalNotice3Var"));
                FromEiiTest.this.assertApprovalNotice4Var(FromEiiTest.this.getVariableValue(callResult, "approvalNotice4Var"));
                FromEiiTest.this.deleteInstance(callResult);
                return null;
            }
        });
        return endTime;
    }

    private void assertProductAmount(Object o) {
        Element root = this.assertTopElementNS(o, "product");
        Assert.assertEquals((String)"52", (String)root.getAttribute("amount"));
        Assert.assertEquals((String)"", (String)root.getAttribute("reference"));
        Assert.assertNull((Object)root.getFirstChild());
    }

    private void assertProductReference(Object o) {
        Element root = this.assertTopElementNS(o, "product");
        Assert.assertEquals((String)"", (String)root.getAttribute("amount"));
        Assert.assertEquals((String)"myProduct", (String)root.getAttribute("reference"));
        Assert.assertNull((Object)root.getFirstChild());
    }

    private void assertPoHeaderVar2(Object o) {
        Element root = this.assertTopElementNS(o, "poHeader");
        List children = XmlUtil.elements((Element)root, (String)this.getProcessNamespace(), (String)"billingAddr");
        Assert.assertEquals((int)1, (int)children.size());
        Element billingAddr = (Element)children.get(0);
        Assert.assertEquals((String)"true", (String)billingAddr.getAttribute("verified"));
        this.assertElementNSContentAndNoChild(billingAddr, "street", "123 Main Street");
        this.assertElementNSContentAndNoChild(billingAddr, "city", "SomeWhere City");
        this.assertElementNSContentAndNoChild(billingAddr, "country", "UK");
    }

    private void assertPoHeaderVar4(Object o) {
        Element root = this.assertTopElementNS(o, "poHeader");
        System.out.println("poHeader4 = " + XmlUtil.toString((Node)root));
        List children = XmlUtil.elements((Element)root, (String)this.getProcessNamespace(), (String)"USshippingAddr");
        Assert.assertEquals((int)1, (int)children.size());
        Element usShippingAddr = (Element)children.get(0);
        Assert.assertEquals((String)"true", (String)usShippingAddr.getAttribute("verified"));
        this.assertElementNSContentAndNoChild(usShippingAddr, "street", "123 Main Street");
        this.assertElementNSContentAndNoChild(usShippingAddr, "city", "SomeWhere City");
        this.assertElementNSContentAndNoChild(usShippingAddr, "country", "USA");
        this.assertElementNSContentAndNoChild(usShippingAddr, "zipcode", "98765");
    }

    private void assertApprovalNotice2Var(Object o) {
        Element root = this.assertTopElementNS(o, "approvalNotice");
        this.assertNoElementChild(root);
        Assert.assertEquals((String)"4500", (String)root.getAttribute("amt"));
        Assert.assertEquals((String)"", (String)root.getTextContent());
    }

    private void assertApprovalNotice3Var(Object o) {
        Element root = this.assertTopElementNS(o, "approvalNotice");
        this.assertNoElementChild(root);
        Assert.assertEquals((String)"4500", (String)root.getTextContent());
    }

    private void assertApprovalNotice4Var(Object o) {
        Element root = this.assertTopElementNS(o, "approvalNotice");
        this.assertNoElementChild(root);
        Assert.assertEquals((String)"AXR", (String)root.getAttribute("code"));
        Assert.assertEquals((String)"4500", (String)root.getTextContent());
    }
}

