/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.xml.namespace.QName;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.persistence.Transaction;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.PartnerLinkRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.services.itf.TestValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestValidatorImpl
implements TestValidator {
    private final Map<BpelExecution, InstanceRecord> records = new HashMap<BpelExecution, InstanceRecord>();

    public void recordVariable(final BpelExecution instance, final QName processQName, final VariableRuntime variableRuntime) {
        ((Transaction)Environment.getFromCurrent(Transaction.class)).registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    List<VariableRuntime> instanceVariables;
                    InstanceRecord instanceRecord = (InstanceRecord)TestValidatorImpl.this.records.get(instance);
                    if (instanceRecord == null) {
                        TestValidatorImpl.this.records.put(instance, new InstanceRecord());
                        instanceRecord = (InstanceRecord)TestValidatorImpl.this.records.get(instance);
                    }
                    if ((instanceVariables = instanceRecord.variables.get(processQName)) == null) {
                        instanceRecord.variables.put(processQName, new ArrayList());
                        instanceVariables = instanceRecord.variables.get(processQName);
                    }
                    instanceVariables.add(variableRuntime);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    public List<VariableRuntime> getRecordedVariables(BpelExecution instance, QName processQName) {
        InstanceRecord instanceRecord = this.records.get(instance);
        if (instanceRecord != null) {
            return instanceRecord.variables.get(processQName);
        }
        return null;
    }

    public void recordPartnerLink(final BpelExecution instance, final QName processQName, final PartnerLinkRuntime partnerLinkRuntime) {
        ((Transaction)Environment.getFromCurrent(Transaction.class)).registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    List<PartnerLinkRuntime> instancePartnerlinks;
                    InstanceRecord instanceRecord = (InstanceRecord)TestValidatorImpl.this.records.get(instance);
                    if (instanceRecord == null) {
                        TestValidatorImpl.this.records.put(instance, new InstanceRecord());
                        instanceRecord = (InstanceRecord)TestValidatorImpl.this.records.get(instance);
                    }
                    if ((instancePartnerlinks = instanceRecord.partnerLinks.get(processQName)) == null) {
                        instanceRecord.partnerLinks.put(processQName, new ArrayList());
                        instancePartnerlinks = instanceRecord.partnerLinks.get(processQName);
                    }
                    instancePartnerlinks.add(partnerLinkRuntime);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    public List<PartnerLinkRuntime> getRecordedPartnerLinks(BpelExecution instance, QName processQName) {
        InstanceRecord instanceRecord = this.records.get(instance);
        if (instanceRecord != null) {
            return instanceRecord.partnerLinks.get(processQName);
        }
        return null;
    }

    public void recordEvent(final BpelExecution instance, final QName processQName, final String event) {
        ((Transaction)Environment.getFromCurrent(Transaction.class)).registerSynchronization(new Synchronization(){

            public void afterCompletion(int status) {
                if (status == 3) {
                    List<String> instanceEventss;
                    InstanceRecord instanceRecord = (InstanceRecord)TestValidatorImpl.this.records.get(instance);
                    if (instanceRecord == null) {
                        TestValidatorImpl.this.records.put(instance, new InstanceRecord());
                        instanceRecord = (InstanceRecord)TestValidatorImpl.this.records.get(instance);
                    }
                    if ((instanceEventss = instanceRecord.events.get(processQName)) == null) {
                        instanceRecord.events.put(processQName, new ArrayList());
                        instanceEventss = instanceRecord.events.get(processQName);
                    }
                    instanceEventss.add(event);
                }
            }

            public void beforeCompletion() {
            }
        });
    }

    public List<String> getRecordedEvents(BpelExecution instance, QName processQName) {
        InstanceRecord instanceRecord = this.records.get(instance);
        if (instanceRecord != null) {
            return instanceRecord.events.get(processQName);
        }
        return null;
    }

    public void clean(BpelExecution instance) {
        this.records.remove(instance);
    }

    private static class InstanceRecord {
        protected Map<QName, List<VariableRuntime>> variables = new HashMap<QName, List<VariableRuntime>>();
        protected Map<QName, List<PartnerLinkRuntime>> partnerLinks = new HashMap<QName, List<PartnerLinkRuntime>>();
        protected Map<QName, List<String>> events = new HashMap<QName, List<String>>();

        private InstanceRecord() {
        }
    }
}

