/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class ForEachTest
extends BpelTestCase {
    public ForEachTest() {
        super("http://orchestra.ow2.org/foreach", "foreach", BpelTestCase.EnvironmentType.JOURNAL);
    }

    public void testForEach() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void testInvalidStartForEachDueToANegativeIndex() {
        this.deploy();
        BpelFaultException e = this.launchInvalid("-8", "6");
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void testInvalidStartForEachDueToANonNumberIndex() {
        this.deploy();
        BpelFaultException e = this.launchInvalid("abc", "3");
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void testInvalidStopForEachDueToANonNumberIndex() {
        this.deploy();
        BpelFaultException e = this.launchInvalid("1", "def");
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void launch() {
        boolean start = true;
        int stop = 4;
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(1)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(4)));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        MessageVariable reply = callResult.getMessageCarrier().getMessage();
        int countTotal = Integer.parseInt(reply.getPartValue("count").getTextContent());
        Assert.assertEquals((int)4, (int)countTotal);
        this.deleteInstance(callResult);
    }

    public BpelFaultException launchInvalid(String start, String stop) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)start));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)stop));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        BpelFaultException exception = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.class);
        this.deleteInstances(1);
        return exception;
    }
}

