/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.data.runtime.PendingMessageData;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmx.RemoteDeployerImpl;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class PendingMessageManagementTest
extends BpelTestCase {
    private RemoteDeployerMBean remoteDeployer;
    private final long time = 3L;

    public void setUp() throws Exception {
        super.setUp();
        this.remoteDeployer = new RemoteDeployerImpl(this.getEnvironmentFactory());
    }

    public void tearDown() throws Exception {
        this.remoteDeployer = null;
        super.tearDown();
    }

    public PendingMessageManagementTest() {
        super("http://orchestra.ow2.org/ExitTest", "ExitTest");
    }

    public void testGetPendingMessages() throws ProcessNotFoundException {
        ProcessDefinition processDef = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"));
        List messages = this.remoteDeployer.getPendingMessages();
        int messageSize = messages.size();
        this.remoteDeployer.retire(processDef.getProcessDefinitionUUID());
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)("PT" + this.time + "S")));
        parts.put("message", BpelXmlUtil.createElementWithContent((String)"message"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        String operationName = "ExitTestOperation";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "ExitTestOperation");
        messages = this.remoteDeployer.getPendingMessages();
        Assert.assertEquals((int)(messageSize + 1), (int)messages.size());
        PendingMessageData message = Collections.max(messages, new Comparator<PendingMessageData>(){

            @Override
            public int compare(PendingMessageData o1, PendingMessageData o2) {
                return o1.getAddedDate().compareTo(o2.getAddedDate());
            }
        });
        Assert.assertEquals((Object)processDef.getQName(), (Object)message.getProcessQName());
        Assert.assertEquals((Object)portTypeQName, (Object)message.getPortTypeQName());
        Assert.assertEquals((String)"ExitTestOperation", (String)message.getOperationName());
        this.undeploy(processDef);
    }

    public void testRemovePendingMessage() throws ProcessNotFoundException {
        ProcessDefinition processDef = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"));
        List messages = this.remoteDeployer.getPendingMessages();
        int messageSize = messages.size();
        this.remoteDeployer.retire(processDef.getProcessDefinitionUUID());
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("duration", BpelXmlUtil.createElementWithContent((String)("PT" + this.time + "S")));
        parts.put("message", BpelXmlUtil.createElementWithContent((String)"message"));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PortType");
        String operationName = "ExitTestOperation";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "ExitTestOperation");
        messages = this.remoteDeployer.getPendingMessages();
        Assert.assertEquals((int)(messageSize + 1), (int)messages.size());
        PendingMessageData message = Collections.max(messages, new Comparator<PendingMessageData>(){

            @Override
            public int compare(PendingMessageData o1, PendingMessageData o2) {
                return o1.getAddedDate().compareTo(o2.getAddedDate());
            }
        });
        this.remoteDeployer.removePendingMessage(message);
        messages = this.remoteDeployer.getPendingMessages();
        Assert.assertEquals((int)messageSize, (int)messages.size());
        for (PendingMessageData pmd : messages) {
            Assert.assertFalse((pmd.getMessageId() == message.getMessageId() ? 1 : 0) != 0);
        }
        this.undeploy(processDef);
    }
}

