/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.jmx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.criteria.Criteria;
import org.ow2.orchestra.facade.criteria.FilterField;
import org.ow2.orchestra.facade.criteria.Order;
import org.ow2.orchestra.facade.criteria.PagedResult;
import org.ow2.orchestra.facade.criteria.ProcessInstancesFiltersFields;
import org.ow2.orchestra.facade.criteria.ProcessInstancesSortableFields;
import org.ow2.orchestra.facade.criteria.Restriction;
import org.ow2.orchestra.facade.criteria.SortableField;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.runtime.ProcessInstanceStateUpdate;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.QueryRuntimeAPIImpl;
import org.ow2.orchestra.runtime.BpelInstance;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.services.runtime.HistoryTest;
import org.ow2.orchestra.test.wsutils.WaitWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.EnvTool;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstancesPageTest
extends BpelTestCase {
    private static final String PROCESS_NAME = "waitingInvoke";
    private static final String NAME_SPACE = "http://orchestra.ow2.org/waitingInvoke";
    private WaitWS waitWS;
    private ProcessDefinition waitProcess;
    private ProcessDefinition echoProcess;
    private ProcessDefinition helloProcess;

    public ProcessInstancesPageTest() {
        super(NAME_SPACE, PROCESS_NAME, BpelTestCase.EnvironmentType.CUSTOM);
    }

    @Override
    protected DefaultEnvXMLGenerator getCustomEnvGenerator() {
        return HistoryTest.getHistoryEnvGenerator();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.waitProcess = this.deploy(((Object)((Object)this)).getClass().getResource("waitingInvoke.bpel"));
        this.waitWS = new WaitWS();
        WSRepository.addWS(WaitWS.PORTTYPE_QNAME, this.waitWS);
        this.echoProcess = this.deploy(((Object)((Object)this)).getClass().getResource("echo.bpel"));
        this.helloProcess = this.deploy(((Object)((Object)this)).getClass().getResource("hello.bpel"));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.waitWS.getQueueLength() > 0) {
            this.waitWS.releaseAll();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        WSRepository.removeWS(WaitWS.PORTTYPE_QNAME);
        this.waitWS = null;
        this.deleteInstances(this.waitProcess.getQName());
        this.undeploy();
        this.waitProcess = null;
        this.deleteInstances(this.echoProcess.getQName());
        this.deleteInstances(this.helloProcess.getQName());
        this.undeploy(this.echoProcess);
        this.undeploy(this.helloProcess);
        this.echoProcess = null;
        this.helloProcess = null;
        super.tearDown();
    }

    public void testPageInstances() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(5);
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        this.waitWS.release(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesLessThanMaxResult() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(100);
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        this.waitWS.release(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesLessThanMaxResultNotStartingAtFirst() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        int firstResult = 5;
        Criteria criteria = new Criteria().setFirstResult(firstResult).setMaxResults(100);
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)(nbInstances - firstResult), (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        this.waitWS.release(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesDefaultCriteria() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria();
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        this.waitWS.release(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesFirstResultGreaterThanTotalInstancesCount() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(100);
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)0, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        criteria = new Criteria().setFirstResult(100).setMaxResults(10);
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)0, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        this.waitWS.release(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesNoInstancesStarted() {
        int nbInstances = 0;
        this.startInstances(nbInstances);
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(new Criteria());
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        page = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setMaxResults(10));
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        page = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setFirstResult(10));
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        page = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setFirstResult(10).setMaxResults(10));
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
    }

    public void testPageInstancesWithStartDateDescSort() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances, 100);
        this.waitWS.release(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(5).setDescendingOrder(ProcessInstancesSortableFields.START_DATE);
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return o1.getStartedDate().compareTo(o2.getStartedDate()) * -1;
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
    }

    public void testPageInstancesWithStartDateAscSort() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances, 100);
        this.waitWS.release(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(2).setMaxResults(5).setOrder(Order.ascending((SortableField)ProcessInstancesSortableFields.START_DATE));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return o1.getStartedDate().compareTo(o2.getStartedDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
    }

    public void testPageInstancesWithStateDescSort() {
        int nbInstances = 7;
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(nbInstances).setOrder(Order.descending((SortableField)ProcessInstancesSortableFields.STATE));
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        int nbReleased = 4;
        this.waitWS.release(nbReleased);
        for (int i = 0; i < nbReleased; ++i) {
            this.waitForInstanceEnd(uuids.get(i));
        }
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        ArrayList<ActivityState> orderedActivityStates = new ArrayList<ActivityState>();
        ArrayList<ActivityState> pagedActivityStates = new ArrayList<ActivityState>();
        for (ProcessInstance processInstance : page.getElements()) {
            orderedActivityStates.add(processInstance.getState());
            pagedActivityStates.add(processInstance.getState());
        }
        Collections.sort(orderedActivityStates, new Comparator<ActivityState>(){

            @Override
            public int compare(ActivityState o1, ActivityState o2) {
                return -1 * o1.toString().compareTo(o2.toString());
            }
        });
        Assert.assertEquals(orderedActivityStates, pagedActivityStates);
        this.waitWS.release(nbInstances - nbReleased);
        for (int i = nbReleased; i < nbInstances; ++i) {
            this.waitForInstanceEnd(uuids.get(i));
        }
    }

    public void testPageInstancesWithStateAscSort() {
        int nbInstances = 7;
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(nbInstances).setOrder(Order.ascending((SortableField)ProcessInstancesSortableFields.STATE));
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        int nbReleased = 4;
        this.waitWS.release(nbReleased);
        for (int i = 0; i < nbReleased; ++i) {
            this.waitForInstanceEnd(uuids.get(i));
        }
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        ArrayList<ActivityState> orderedActivityStates = new ArrayList<ActivityState>();
        ArrayList<ActivityState> pagedActivityStates = new ArrayList<ActivityState>();
        for (ProcessInstance processInstance : page.getElements()) {
            orderedActivityStates.add(processInstance.getState());
            pagedActivityStates.add(processInstance.getState());
        }
        Collections.sort(orderedActivityStates, new Comparator<ActivityState>(){

            @Override
            public int compare(ActivityState o1, ActivityState o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        Assert.assertEquals(orderedActivityStates, pagedActivityStates);
        this.waitWS.release(nbInstances - nbReleased);
        for (int i = nbReleased; i < nbInstances; ++i) {
            this.waitForInstanceEnd(uuids.get(i));
        }
    }

    public void testPageInstancesWithLastUpdateDescSort() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(processInstanceUUID);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(5).setOrder(Order.descending((SortableField)ProcessInstancesSortableFields.LAST_UPDATE_DATE));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return -1 * ((ProcessInstanceStateUpdate)o1.getProcessInstanceStateUpdate().get(o1.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(((ProcessInstanceStateUpdate)o2.getProcessInstanceStateUpdate().get(o2.getProcessInstanceStateUpdate().size() - 1)).getDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
    }

    public void testPageInstancesWithLastUpdateAscSort() {
        int nbInstances = 7;
        List<ProcessInstanceUUID> uuids = this.startInstances(nbInstances);
        for (ProcessInstanceUUID processInstanceUUID : uuids) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(processInstanceUUID);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(5).setAscendingOrder(ProcessInstancesSortableFields.LAST_UPDATE_DATE);
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbInstances, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return ((ProcessInstanceStateUpdate)o1.getProcessInstanceStateUpdate().get(o1.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(((ProcessInstanceStateUpdate)o2.getProcessInstanceStateUpdate().get(o2.getProcessInstanceStateUpdate().size() - 1)).getDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
    }

    public void testPageInstancesWithRestrictionOnProcessID() {
        int nbWaitInstances = 7;
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(5).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertEquals((Object)this.waitProcess.getUUID(), (Object)processInstance.getProcessDefinitionUUID());
        }
        this.waitWS.release(nbWaitInstances);
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesLessThanMaxResultWithRestrictionOnProcessID() {
        int nbWaitInstances = 7;
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(100);
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbWaitInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertEquals((Object)this.waitProcess.getUUID(), (Object)processInstance.getProcessDefinitionUUID());
        }
        this.waitWS.release(nbWaitInstances);
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesLessThanMaxResultNotStartingAtFirstWithRestrictionOnProcessID() {
        int nbWaitInstances = 7;
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        int firstResult = 5;
        Criteria criteria = new Criteria().setFirstResult(firstResult).setMaxResults(100);
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)(nbWaitInstances - firstResult), (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertEquals((Object)this.waitProcess.getUUID(), (Object)processInstance.getProcessDefinitionUUID());
        }
        this.waitWS.release(nbWaitInstances);
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesFirstResultGreaterThanTotalInstancesCountWithRestrictionOnProcessID() {
        int nbWaitInstances = 7;
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(100);
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)0, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        criteria = new Criteria().setFirstResult(100).setMaxResults(10);
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)0, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        this.waitWS.release(nbWaitInstances);
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesNoInstancesStartedWithRestrictionOnProcessID() {
        int nbWaitInstances = 0;
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(new Criteria().addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID())));
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbWaitInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        page = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setMaxResults(10).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID())));
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbWaitInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        page = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setFirstResult(10).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID())));
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbWaitInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        page = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setFirstResult(10).setMaxResults(10).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID())));
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbWaitInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesWithStartDateDescSortWithRestrictionOnProcessID() {
        int nbWaitInstances = 7;
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances, 1001);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        this.waitWS.release(nbWaitInstances);
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(5).setOrder(Order.descending((SortableField)ProcessInstancesSortableFields.START_DATE));
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return o1.getStartedDate().compareTo(o2.getStartedDate()) * -1;
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
    }

    public void testPageInstancesWithStartDateAscSortWithRestrictionOnProcessID() {
        int nbWaitInstances = 7;
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances, 1001);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        this.waitWS.release(nbWaitInstances);
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(2).setMaxResults(5).setOrder(Order.ascending((SortableField)ProcessInstancesSortableFields.START_DATE));
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return o1.getStartedDate().compareTo(o2.getStartedDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
    }

    public void testPageInstancesWithStateDescSortWithRestrictionOnProcessID() {
        int nbWaitInstances = 7;
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(nbWaitInstances).setOrder(Order.descending((SortableField)ProcessInstancesSortableFields.STATE));
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        int nbReleased = 4;
        this.waitWS.release(nbReleased);
        for (int i = 0; i < nbReleased; ++i) {
            this.waitForInstanceEnd(waitUuids.get(i));
        }
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbWaitInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        ArrayList<ActivityState> orderedActivityStates = new ArrayList<ActivityState>();
        ArrayList<ActivityState> pagedActivityStates = new ArrayList<ActivityState>();
        for (ProcessInstance processInstance : page.getElements()) {
            orderedActivityStates.add(processInstance.getState());
            pagedActivityStates.add(processInstance.getState());
        }
        Collections.sort(orderedActivityStates, new Comparator<ActivityState>(){

            @Override
            public int compare(ActivityState o1, ActivityState o2) {
                return -1 * o1.toString().compareTo(o2.toString());
            }
        });
        Assert.assertEquals(orderedActivityStates, pagedActivityStates);
        this.waitWS.release(nbWaitInstances - nbReleased);
        for (int i = nbReleased; i < nbWaitInstances; ++i) {
            this.waitForInstanceEnd(waitUuids.get(i));
        }
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertEquals((Object)this.waitProcess.getUUID(), (Object)processInstance.getProcessDefinitionUUID());
        }
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesWithStateAscSortWithRestrictionOnProcessID() {
        int nbWaitInstances = 7;
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(nbWaitInstances).setOrder(Order.ascending((SortableField)ProcessInstancesSortableFields.STATE));
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        int nbReleased = 4;
        this.waitWS.release(nbReleased);
        for (int i = 0; i < nbReleased; ++i) {
            this.waitForInstanceEnd(waitUuids.get(i));
        }
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)nbWaitInstances, (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        ArrayList<ActivityState> orderedActivityStates = new ArrayList<ActivityState>();
        ArrayList<ActivityState> pagedActivityStates = new ArrayList<ActivityState>();
        for (ProcessInstance processInstance : page.getElements()) {
            orderedActivityStates.add(processInstance.getState());
            pagedActivityStates.add(processInstance.getState());
        }
        Collections.sort(orderedActivityStates, new Comparator<ActivityState>(){

            @Override
            public int compare(ActivityState o1, ActivityState o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        Assert.assertEquals(orderedActivityStates, pagedActivityStates);
        this.waitWS.release(nbWaitInstances - nbReleased);
        for (int i = nbReleased; i < nbWaitInstances; ++i) {
            this.waitForInstanceEnd(waitUuids.get(i));
        }
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertEquals((Object)this.waitProcess.getUUID(), (Object)processInstance.getProcessDefinitionUUID());
        }
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
    }

    public void testPageInstancesWithLastUpdateDescSortWithRestrictionOnProcessID() {
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        int nbWaitInstances = 7;
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        for (ProcessInstanceUUID processInstanceUUID : waitUuids) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(processInstanceUUID);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(5).setOrder(Order.descending((SortableField)ProcessInstancesSortableFields.LAST_UPDATE_DATE));
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return -1 * ((ProcessInstanceStateUpdate)o1.getProcessInstanceStateUpdate().get(o1.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(((ProcessInstanceStateUpdate)o2.getProcessInstanceStateUpdate().get(o2.getProcessInstanceStateUpdate().size() - 1)).getDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
    }

    public void testPageInstancesWithLastUpdateAscSortWithRestrictionOnProcessID() {
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        int nbWaitInstances = 7;
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        allUuids.addAll(waitUuids);
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        for (ProcessInstanceUUID processInstanceUUID : waitUuids) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(processInstanceUUID);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(2).setMaxResults(5).setOrder(Order.ascending((SortableField)ProcessInstancesSortableFields.LAST_UPDATE_DATE));
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)criteria.getMaxResults(), (int)page.getElements().size());
        Assert.assertEquals((long)nbWaitInstances, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return ((ProcessInstanceStateUpdate)o1.getProcessInstanceStateUpdate().get(o1.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(((ProcessInstanceStateUpdate)o2.getProcessInstanceStateUpdate().get(o2.getProcessInstanceStateUpdate().size() - 1)).getDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
    }

    public void testPageInstancesWithRestrictionOnState() {
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.STATE, (Object)ActivityState.RUNNING));
        int nbWaitInstances = 5;
        List<ProcessInstanceUUID> waitUuids = this.startInstances(5);
        int waitFor = 3;
        Assert.assertTrue((boolean)true);
        for (int i = 0; i < 3; ++i) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(waitUuids.get(i));
        }
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)2, (int)page.getElements().size());
        Assert.assertEquals((long)2L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertEquals((Object)ActivityState.RUNNING, (Object)processInstance.getState());
        }
        this.waitWS.release(2);
        for (int i = 3; i < 5; ++i) {
            this.waitForInstanceEnd(waitUuids.get(i));
        }
    }

    public void testPageInstancesWithLastUpdateDescSortWithRestrictionOnState() {
        int nbWaitInstances = 7;
        int waitFor = 3;
        Assert.assertTrue((boolean)true);
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(0).setMaxResults(3).setOrder(Order.descending((SortableField)ProcessInstancesSortableFields.LAST_UPDATE_DATE));
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.STATE, (Object)ActivityState.FINISHED));
        List<ProcessInstanceUUID> waitUuids = this.startInstances(7);
        for (int i = 0; i < 3; ++i) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(waitUuids.get(i));
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)3, (int)page.getElements().size());
        Assert.assertEquals((long)3L, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return -1 * ((ProcessInstanceStateUpdate)o1.getProcessInstanceStateUpdate().get(o1.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(((ProcessInstanceStateUpdate)o2.getProcessInstanceStateUpdate().get(o2.getProcessInstanceStateUpdate().size() - 1)).getDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertEquals((Object)ActivityState.FINISHED, (Object)processInstance.getState());
        }
        this.waitWS.release(4);
        for (int i = 3; i < 7; ++i) {
            this.waitForInstanceEnd(waitUuids.get(i));
        }
    }

    public void testPageInstancesWithLastUpdateAscSortWithRestrictionOnProcessIDAndState() {
        int startIndex = 2;
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        Criteria criteria = new Criteria().setFirstResult(2);
        criteria.setOrder(Order.ascending((SortableField)ProcessInstancesSortableFields.LAST_UPDATE_DATE));
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID())).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.STATE, (Object)ActivityState.FINISHED));
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
        int nbWaitInstances = 7;
        int waitFor = 4;
        Assert.assertTrue((4 < nbWaitInstances ? 1 : 0) != 0);
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        allUuids.addAll(waitUuids);
        for (int i = 0; i < 4; ++i) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(waitUuids.get(i));
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)Math.max(0, 2), (int)page.getElements().size());
        Assert.assertEquals((long)4L, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return ((ProcessInstanceStateUpdate)o1.getProcessInstanceStateUpdate().get(o1.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(((ProcessInstanceStateUpdate)o2.getProcessInstanceStateUpdate().get(o2.getProcessInstanceStateUpdate().size() - 1)).getDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertEquals((Object)ActivityState.FINISHED, (Object)processInstance.getState());
        }
        this.waitWS.release(nbWaitInstances - 4);
        for (int i = 4; i < nbWaitInstances; ++i) {
            this.waitForInstanceEnd(waitUuids.get(i));
        }
    }

    public void testPageInstancesWithRestrictionOnStartDateAndProcessId() {
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        int nbWaitInstancesTotal = 7;
        int nbWaitInstancesFirstPass = 3;
        Assert.assertTrue((boolean)true);
        List<ProcessInstanceUUID> waitUuidsFirstPass = this.startInstances(3);
        PagedResult pagedResult = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setMaxResults(3));
        Assert.assertEquals((int)3, (int)pagedResult.getElements().size());
        Date beginDate = ((ProcessInstance)pagedResult.getElements().get(0)).getStartedDate();
        Date intermediateDate = ((ProcessInstance)pagedResult.getElements().get(0)).getStartedDate();
        for (ProcessInstance processInstance : pagedResult.getElements()) {
            if (beginDate.after(processInstance.getStartedDate())) {
                beginDate = processInstance.getStartedDate();
            }
            if (!intermediateDate.before(processInstance.getStartedDate())) continue;
            intermediateDate = processInstance.getStartedDate();
        }
        intermediateDate.setTime(intermediateDate.getTime() + 1000L);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        List<ProcessInstanceUUID> waitUuidsSecondPass = this.startInstances(4);
        pagedResult = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setMaxResults(7));
        Assert.assertEquals((int)7, (int)pagedResult.getElements().size());
        Date finalDate = ((ProcessInstance)pagedResult.getElements().get(0)).getStartedDate();
        for (ProcessInstance processInstance : pagedResult.getElements()) {
            if (!finalDate.before(processInstance.getStartedDate())) continue;
            finalDate = processInstance.getStartedDate();
        }
        this.waitWS.release(7);
        for (ProcessInstanceUUID instanceUUID : waitUuidsFirstPass) {
            this.waitForInstanceEnd(instanceUUID);
        }
        for (ProcessInstanceUUID instanceUUID : waitUuidsSecondPass) {
            this.waitForInstanceEnd(instanceUUID);
        }
        Criteria criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.ge((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)beginDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)7, (int)page.getElements().size());
        Assert.assertEquals((long)7L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'ge' restriction for started date", (processInstance.getStartedDate().compareTo(beginDate) >= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.gt((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)intermediateDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)4, (int)page.getElements().size());
        Assert.assertEquals((long)4L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'gt' restriction for started date", (boolean)processInstance.getStartedDate().after(intermediateDate));
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.lt((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)intermediateDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)3, (int)page.getElements().size());
        Assert.assertEquals((long)3L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'lt' restriction for started date", (boolean)processInstance.getStartedDate().before(intermediateDate));
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.le((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)finalDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)7, (int)page.getElements().size());
        Assert.assertEquals((long)7L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'le' restriction for started date", (processInstance.getStartedDate().compareTo(finalDate) <= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.between((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)beginDate, (Object)finalDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)7, (int)page.getElements().size());
        Assert.assertEquals((long)7L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'between' restriction for started date", (processInstance.getStartedDate().compareTo(beginDate) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Error in 'between' restriction for started date", (processInstance.getStartedDate().compareTo(finalDate) <= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.between((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)beginDate, (Object)intermediateDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)3, (int)page.getElements().size());
        Assert.assertEquals((long)3L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'between' restriction for started date", (processInstance.getStartedDate().compareTo(beginDate) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Error in 'between' restriction for started date", (processInstance.getStartedDate().compareTo(intermediateDate) <= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.between((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)intermediateDate, (Object)finalDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)4, (int)page.getElements().size());
        Assert.assertEquals((long)4L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'between' restriction for started date", (processInstance.getStartedDate().compareTo(intermediateDate) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Error in 'between' restriction for started date", (processInstance.getStartedDate().compareTo(finalDate) <= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.between((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)finalDate, (Object)beginDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)0, (int)page.getElements().size());
        Assert.assertEquals((long)0L, (long)page.getTotalElementsCount());
    }

    public void testPageInstancesWithRestrictionOnLastUpdateDateAndProcessId() {
        Date beginDate;
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        int nbWaitInstancesTotal = 7;
        int nbWaitInstancesFirstPass = 3;
        Assert.assertTrue((boolean)true);
        List<ProcessInstanceUUID> waitUuidsFirstPass = this.startInstances(3);
        for (ProcessInstanceUUID instanceUUID : waitUuidsFirstPass) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(instanceUUID);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        PagedResult pagedResult = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setMaxResults(3));
        Assert.assertEquals((int)3, (int)pagedResult.getElements().size());
        Date intermediateDate = beginDate = ((ProcessInstanceStateUpdate)((ProcessInstance)pagedResult.getElements().get(0)).getProcessInstanceStateUpdate().get(((ProcessInstance)pagedResult.getElements().get(0)).getProcessInstanceStateUpdate().size() - 1)).getDate();
        for (ProcessInstance processInstance : pagedResult.getElements()) {
            if (beginDate.after(((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate())) {
                beginDate = ((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate();
            }
            if (!intermediateDate.before(((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate())) continue;
            intermediateDate = ((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate();
        }
        intermediateDate.setTime(intermediateDate.getTime() + 1000L);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        List<ProcessInstanceUUID> waitUuidsSecondPass = this.startInstances(4);
        this.waitWS.release(4);
        for (ProcessInstanceUUID instanceUUID : waitUuidsSecondPass) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(instanceUUID);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        pagedResult = queryRuntimeAPI.findProcessInstancesPage(new Criteria().setMaxResults(7));
        Assert.assertEquals((int)7, (int)pagedResult.getElements().size());
        Date finalDate = intermediateDate;
        for (ProcessInstance processInstance : pagedResult.getElements()) {
            if (!finalDate.before(((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate())) continue;
            finalDate = ((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate();
        }
        Criteria criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.ge((FilterField)ProcessInstancesFiltersFields.LAST_UPDATE_DATE, (Object)beginDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)7, (int)page.getElements().size());
        Assert.assertEquals((long)7L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'ge' restriction for last update date", (((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(beginDate) >= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.gt((FilterField)ProcessInstancesFiltersFields.LAST_UPDATE_DATE, (Object)intermediateDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)4, (int)page.getElements().size());
        Assert.assertEquals((long)4L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'gt' restriction for last update date", (boolean)((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().after(intermediateDate));
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.lt((FilterField)ProcessInstancesFiltersFields.LAST_UPDATE_DATE, (Object)intermediateDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)3, (int)page.getElements().size());
        Assert.assertEquals((long)3L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'lt' restriction for last update date", (boolean)((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().before(intermediateDate));
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.le((FilterField)ProcessInstancesFiltersFields.LAST_UPDATE_DATE, (Object)finalDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)7, (int)page.getElements().size());
        Assert.assertEquals((long)7L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'le' restriction for last update date", (((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(finalDate) <= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.between((FilterField)ProcessInstancesFiltersFields.LAST_UPDATE_DATE, (Object)beginDate, (Object)finalDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)7, (int)page.getElements().size());
        Assert.assertEquals((long)7L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'between' restriction for last update date", (((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(beginDate) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Error in 'between' restriction for last update date", (((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(finalDate) <= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.between((FilterField)ProcessInstancesFiltersFields.LAST_UPDATE_DATE, (Object)beginDate, (Object)intermediateDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)3, (int)page.getElements().size());
        Assert.assertEquals((long)3L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'between' restriction for last update date", (((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(beginDate) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Error in 'between' restriction for last update date", (((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(intermediateDate) <= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.between((FilterField)ProcessInstancesFiltersFields.LAST_UPDATE_DATE, (Object)intermediateDate, (Object)finalDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)4, (int)page.getElements().size());
        Assert.assertEquals((long)4L, (long)page.getTotalElementsCount());
        for (ProcessInstance processInstance : page.getElements()) {
            Assert.assertTrue((String)"Error in 'between' restriction for last update date", (((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(intermediateDate) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Error in 'between' restriction for last update date", (((ProcessInstanceStateUpdate)processInstance.getProcessInstanceStateUpdate().get(processInstance.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(finalDate) <= 0 ? 1 : 0) != 0);
        }
        criteria = new Criteria().setMaxResults(7);
        criteria.addRestriction(Restriction.between((FilterField)ProcessInstancesFiltersFields.LAST_UPDATE_DATE, (Object)finalDate, (Object)beginDate)).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID()));
        page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)0, (int)page.getElements().size());
        Assert.assertEquals((long)0L, (long)page.getTotalElementsCount());
    }

    public void testPageInstancesWithLastUpdateAscSortWithRestrictionOnProcessIDAndStateAndStartedDate() {
        int startIndex = 2;
        QueryRuntimeAPIImpl queryRuntimeAPI = new QueryRuntimeAPIImpl(this.getEnvironmentFactory());
        ArrayList<ProcessInstanceUUID> allUuids = new ArrayList<ProcessInstanceUUID>();
        int nbEchoInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Echo message", true, nbEchoInstances));
        Date intermediateDate = new Date();
        int nbHelloInstances = 5;
        allUuids.addAll(this.launchEchoOrHello("Hello message", false, nbHelloInstances));
        for (ProcessInstanceUUID processInstanceUUID : allUuids) {
            this.waitForInstanceEnd(processInstanceUUID);
        }
        Criteria criteria = new Criteria().setFirstResult(2);
        criteria.setAscendingOrder(ProcessInstancesSortableFields.LAST_UPDATE_DATE);
        criteria.addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.PROCESS_ID, (Object)this.waitProcess.getUUID())).addRestriction(Restriction.eq((FilterField)ProcessInstancesFiltersFields.STATE, (Object)ActivityState.FINISHED)).addRestriction(Restriction.ge((FilterField)ProcessInstancesFiltersFields.START_DATE, (Object)intermediateDate));
        int nbWaitInstances = 7;
        int waitFor = 4;
        Assert.assertTrue((4 < nbWaitInstances ? 1 : 0) != 0);
        List<ProcessInstanceUUID> waitUuids = this.startInstances(nbWaitInstances);
        for (int i = 0; i < 4; ++i) {
            this.waitWS.release(1);
            this.waitForInstanceEnd(waitUuids.get(i));
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        PagedResult page = queryRuntimeAPI.findProcessInstancesPage(criteria);
        Assert.assertNotNull((Object)page);
        Assert.assertNotNull((Object)page.getElements());
        Assert.assertEquals((int)Math.max(0, 2), (int)page.getElements().size());
        Assert.assertEquals((long)4L, (long)page.getTotalElementsCount());
        ArrayList orderedProcessInstances = new ArrayList(page.getElements());
        Collections.sort(orderedProcessInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return ((ProcessInstanceStateUpdate)o1.getProcessInstanceStateUpdate().get(o1.getProcessInstanceStateUpdate().size() - 1)).getDate().compareTo(((ProcessInstanceStateUpdate)o2.getProcessInstanceStateUpdate().get(o2.getProcessInstanceStateUpdate().size() - 1)).getDate());
            }
        });
        Assert.assertEquals(orderedProcessInstances, (Object)page.getElements());
        this.waitWS.release(nbWaitInstances - 4);
        for (int i = 4; i < nbWaitInstances; ++i) {
            this.waitForInstanceEnd(waitUuids.get(i));
        }
    }

    private List<ProcessInstanceUUID> startInstances(int nbInstances) {
        return this.startInstances(nbInstances, true);
    }

    private List<ProcessInstanceUUID> startInstances(int nbInstances, boolean waitInstances) {
        ArrayList<ProcessInstanceUUID> result = new ArrayList<ProcessInstanceUUID>();
        for (int i = 1; i <= nbInstances; ++i) {
            result.add(this.launch("Message nb: " + i));
            if (!waitInstances) continue;
            this.waitForInstancesToBeBlocked(i);
        }
        return result;
    }

    private List<ProcessInstanceUUID> startInstances(int nbInstances, int delay) {
        ArrayList<ProcessInstanceUUID> result = new ArrayList<ProcessInstanceUUID>();
        for (int i = 0; i < nbInstances; ++i) {
            result.add(this.launch("Message nb: " + i));
            if (delay <= 0 || i >= nbInstances) continue;
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private ProcessInstanceUUID launch(String message) {
        Assert.assertNotNull((Object)this.waitWS);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("input", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName(this.getProcessNamespace(), "waitingInvokePT");
        String operationName = "start";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        return (ProcessInstanceUUID)commandService.execute((Command)new Command<ProcessInstanceUUID>(){
            private static final long serialVersionUID = 1L;

            public ProcessInstanceUUID execute(Environment environment) {
                return callResult.getInstance().getProcessInstanceUUID();
            }
        });
    }

    private void waitForInstancesToBeBlocked(int nbInstances) {
        Assert.assertNotNull((Object)this.waitWS);
        while (this.waitWS.getQueueLength() < nbInstances) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private List<ProcessInstanceUUID> launchEchoOrHello(String message, boolean isEcho, int nbInstances) {
        ArrayList<ProcessInstanceUUID> uuids = new ArrayList<ProcessInstanceUUID>();
        for (int i = 0; i < nbInstances; ++i) {
            uuids.add(this.launchEchoOrHello(message, isEcho));
        }
        return uuids;
    }

    private ProcessInstanceUUID launchEchoOrHello(String message, boolean isEcho) {
        String serviceName = isEcho ? "echo" : "hello";
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("inputType", BpelXmlUtil.createElementWithContent((String)message));
        QName portTypeQName = new QName("http://localhost/" + serviceName + "/" + serviceName, "portType1");
        QName processQName = new QName("http://enterprise.netbeans.org/bpel/" + serviceName + "/" + serviceName + "_1", serviceName);
        String operationName = "operation1";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "operation1", processQName);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        return (ProcessInstanceUUID)commandService.execute((Command)new Command<ProcessInstanceUUID>(){
            private static final long serialVersionUID = 1L;

            public ProcessInstanceUUID execute(Environment environment) {
                return callResult.getInstance().getProcessInstanceUUID();
            }
        });
    }

    private void deleteInstances(final QName processQName) {
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                List execs = ((Repository)environment.get(Repository.class)).getInstances(processQName);
                for (BpelInstance bpelInstance : execs) {
                    ((Repository)environment.get(Repository.class)).removeInstance(bpelInstance, true);
                    EnvTool.getQuerier().removeProcessInstance(bpelInstance.getProcessInstanceUUID());
                }
                return null;
            }
        });
    }
}

