/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.perf.addition;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.perf.AbstractPerfTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class AdditionTest
extends AbstractPerfTestCase {
    public AdditionTest() {
        super("http://orchestra.ow2.org/addition", "addition");
    }

    public long launch() {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        int base = Misc.random((int)0, (int)100000);
        int toAdd = Misc.random((int)-555, (int)100000);
        parts.put("base", BpelXmlUtil.createElementWithContent((String)Integer.toString(base)));
        parts.put("toAdd", BpelXmlUtil.createElementWithContent((String)Integer.toString(toAdd)));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "add";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "add");
        MessageVariable reply = callResult.getMessageCarrier().getMessage();
        long endTime = callResult.getEndTime();
        if (reply == null) {
            throw new OrchestraRuntimeException("reply is null");
        }
        Element element = reply.getPartValue("total");
        if (element == null) {
            throw new OrchestraRuntimeException("reply.total is null");
        }
        String totalSt = element.getTextContent();
        if (totalSt == null) {
            throw new OrchestraRuntimeException("reply.total.textContent is null");
        }
        int total = new Integer(totalSt);
        if (total != base + toAdd) {
            throw new OrchestraRuntimeException("reply.total.textContent is not " + (base + toAdd) + ", it is : " + total);
        }
        this.deleteInstance(callResult);
        return endTime;
    }

    public void testAddition() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void testAdditionHibernateCache() {
        this.deploy();
        this.launch();
        this.beginCacheTest();
        this.launch();
        this.endCacheTest();
        this.undeploy();
    }

    public String getAlias() {
        return "class.add";
    }
}

