/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.runtime.incomingcalls.missingReply;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.services.commands.Command;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class TestReceiveMissingReply
extends BpelTestCase {
    public TestReceiveMissingReply() {
        super("http://orchestra.ow2.org/testReceiveMissingReply", "testReceiveMissingReply");
    }

    public void testReceiveMissingReply() {
        this.deploy();
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            callResult.getMessageCarrier().getMessage();
            TestReceiveMissingReply.fail((String)"exception expected");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available because the process execution failed.", (String)e.getMessage());
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResult.getInstance().getCurrentScopeRuntime();
                Assert.assertNotNull((Object)scopeRuntime.getLastException());
                Assert.assertEquals((Object)BpelFaultException.BpelFault.missingReply.getQName(), (Object)scopeRuntime.getLastException().getFaultName());
                return null;
            }
        });
        this.deleteInstance(callResult);
        this.undeploy();
    }

    public void testReceiveMissingReplyCatched() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "Catched.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        MessageVariable resultMessage = callResult.getMessageCarrier().getMessage();
        Assert.assertEquals((int)1, (int)resultMessage.getParts().size());
        Assert.assertEquals((String)message, (String)resultMessage.getPartValue("payload").getTextContent());
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResult.getInstance().getCurrentScopeRuntime();
                Assert.assertNull((Object)scopeRuntime.getLastException());
                return null;
            }
        });
        this.deleteInstance(callResult);
        this.undeploy(processDefinition);
    }

    public void testReceiveMissingReplyCatchedParentScope() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "CatchedParentScope.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            callResult.getMessageCarrier().getMessage();
            TestReceiveMissingReply.fail((String)"exception expected");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available because the process execution failed.", (String)e.getMessage());
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResult.getInstance().getCurrentScopeRuntime();
                Assert.assertNotNull((Object)scopeRuntime.getLastException());
                Assert.assertEquals((Object)BpelFaultException.BpelFault.missingRequest.getQName(), (Object)scopeRuntime.getLastException().getFaultName());
                return null;
            }
        });
        this.deleteInstance(callResult);
        this.undeploy(processDefinition);
    }

    public void testReceiveReply() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource("testReceiveReply.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        MessageVariable resultMessage = callResult.getMessageCarrier().getMessage();
        Assert.assertEquals((int)1, (int)resultMessage.getParts().size());
        Assert.assertEquals((String)message, (String)resultMessage.getPartValue("payload").getTextContent());
        this.deleteInstance(callResult);
        this.undeploy(processDefinition);
    }

    public void testReceiveReplyScope() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource("testReceiveReplyScope.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        MessageVariable resultMessage = callResult.getMessageCarrier().getMessage();
        Assert.assertEquals((int)1, (int)resultMessage.getParts().size());
        Assert.assertEquals((String)message, (String)resultMessage.getPartValue("payload").getTextContent());
        this.deleteInstance(callResult);
        this.undeploy(processDefinition);
    }

    public void testReceiveMissingReplyInCH() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "InCH.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResultInit = this.call(parts, portTypeQName, "init");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            callResult.getMessageCarrier().getMessage();
            TestReceiveMissingReply.fail((String)"exception expected");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available because the process execution failed.", (String)e.getMessage());
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResultInit.getInstance().getCurrentScopeRuntime();
                Assert.assertNotNull((Object)scopeRuntime.getLastException());
                Assert.assertEquals((Object)new QName(TestReceiveMissingReply.this.getProcessNamespace(), "fault3"), (Object)scopeRuntime.getLastException().getFaultName());
                return null;
            }
        });
        this.deleteInstance(callResultInit);
        this.undeploy(processDefinition);
    }

    public void testReceiveMissingReplyInTH() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "InTH.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResultInit = this.call(parts, portTypeQName, "init");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            callResult.getMessageCarrier().getMessage();
            TestReceiveMissingReply.fail((String)"exception expected");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available because the process execution failed.", (String)e.getMessage());
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResultInit.getInstance().getCurrentScopeRuntime();
                Assert.assertNotNull((Object)scopeRuntime.getLastException());
                Assert.assertEquals((Object)new QName(TestReceiveMissingReply.this.getProcessNamespace(), "fault2"), (Object)scopeRuntime.getLastException().getFaultName());
                return null;
            }
        });
        this.deleteInstance(callResultInit);
        this.undeploy(processDefinition);
    }

    public void testReceiveMissingReplyInFH() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "InFH.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResultInit = this.call(parts, portTypeQName, "init");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            callResult.getMessageCarrier().getMessage();
            TestReceiveMissingReply.fail((String)"exception expected");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available because the process execution failed.", (String)e.getMessage());
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResultInit.getInstance().getCurrentScopeRuntime();
                Assert.assertNotNull((Object)scopeRuntime.getLastException());
                Assert.assertEquals((Object)new QName(TestReceiveMissingReply.this.getProcessNamespace(), "fault3"), (Object)scopeRuntime.getLastException().getFaultName());
                return null;
            }
        });
        this.deleteInstance(callResultInit);
        this.undeploy(processDefinition);
    }

    public void testReceiveMissingReplyFaultInCH() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "FaultInCH.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResultInit = this.call(parts, portTypeQName, "init");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            callResult.getMessageCarrier().getMessage();
            TestReceiveMissingReply.fail((String)"exception expected");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available because the process execution failed.", (String)e.getMessage());
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResultInit.getInstance().getCurrentScopeRuntime();
                Assert.assertNotNull((Object)scopeRuntime.getLastException());
                Assert.assertEquals((Object)new QName(TestReceiveMissingReply.this.getProcessNamespace(), "fault4"), (Object)scopeRuntime.getLastException().getFaultName());
                return null;
            }
        });
        this.deleteInstance(callResultInit);
        this.undeploy(processDefinition);
    }

    public void testReceiveMissingReplyFaultInFH() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "FaultInFH.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResultInit = this.call(parts, portTypeQName, "init");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            callResult.getMessageCarrier().getMessage();
            TestReceiveMissingReply.fail((String)"exception expected");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available because the process execution failed.", (String)e.getMessage());
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResultInit.getInstance().getCurrentScopeRuntime();
                Assert.assertNotNull((Object)scopeRuntime.getLastException());
                Assert.assertEquals((Object)new QName(TestReceiveMissingReply.this.getProcessNamespace(), "fault4"), (Object)scopeRuntime.getLastException().getFaultName());
                return null;
            }
        });
        this.deleteInstance(callResultInit);
        this.undeploy(processDefinition);
    }

    public void testReceiveMissingReplyFaultInTH() {
        ProcessDefinition processDefinition = this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "FaultInTH.bpel"));
        String message = Misc.getRandomString((int)10);
        HashMap<String, Element> parts = new HashMap<String, Element>();
        QName portTypeQName = new QName(this.getProcessNamespace(), "receivePT");
        parts.put("payload", BpelXmlUtil.createElementWithContent((String)message));
        final BpelTestCase.CallResult callResultInit = this.call(parts, portTypeQName, "init");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        try {
            callResult.getMessageCarrier().getMessage();
            TestReceiveMissingReply.fail((String)"exception expected");
        }
        catch (OrchestraRuntimeException e) {
            Assert.assertEquals((String)"No reply message available because the process execution failed.", (String)e.getMessage());
        }
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Void>(){

            public Void execute(Environment environment) {
                ScopeRuntime scopeRuntime = callResultInit.getInstance().getCurrentScopeRuntime();
                Assert.assertNotNull((Object)scopeRuntime.getLastException());
                Assert.assertEquals((Object)new QName(TestReceiveMissingReply.this.getProcessNamespace(), "fault2"), (Object)scopeRuntime.getLastException().getFaultName());
                return null;
            }
        });
        this.deleteInstance(callResultInit);
        this.undeploy(processDefinition);
    }
}

