/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.facade.criteria.FilterField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Restriction<T>
implements Serializable {
    public static final long serialVersionUID = -8141907675530673225L;
    public static final String EQUALS = "=";
    public static final String BETWEEN = "><";
    public static final String LESS_THAN = "lt";
    public static final String LESS_THAN_EQUALS = "le";
    public static final String GREATER_THAN = "gt";
    public static final String GREATER_THAN_EQUALS = "ge";
    private FilterField<T> field;
    private List<Object> values;
    private String operation;

    private Restriction(FilterField<T> field, List<Object> values, String operation) {
        this.field = field;
        this.values = values;
        this.operation = operation;
    }

    public final FilterField<T> getField() {
        return this.field;
    }

    public final List getValues() {
        return this.values;
    }

    public final String getOperation() {
        return this.operation;
    }

    public static <C> Restriction<C> eq(FilterField<C> field, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        return new Restriction<C>(field, values, EQUALS);
    }

    public static <C> Restriction<C> between(FilterField<C> field, Object lower, Object upper) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(lower);
        values.add(upper);
        return new Restriction<C>(field, values, BETWEEN);
    }

    public static <C> Restriction<C> lt(FilterField<C> field, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        return new Restriction<C>(field, values, LESS_THAN);
    }

    public static <C> Restriction<C> le(FilterField<C> field, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        return new Restriction<C>(field, values, LESS_THAN_EQUALS);
    }

    public static <C> Restriction<C> gt(FilterField<C> field, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        return new Restriction<C>(field, values, GREATER_THAN);
    }

    public static <C> Restriction<C> ge(FilterField<C> field, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        return new Restriction<C>(field, values, GREATER_THAN_EQUALS);
    }
}

